/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.AutoAimable;
import com.atsuishio.superbwarfare.entity.vehicle.base.DefenseEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.common.container.ContainerBlockItem;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LaserTowerEntity
extends VehicleEntity
implements GeoEntity,
OwnableEntity,
AutoAimable,
DefenseEntity {
    public static final EntityDataAccessor<Integer> COOL_DOWN = SynchedEntityData.m_135353_(LaserTowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.m_135353_(LaserTowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(LaserTowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(LaserTowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final EntityDataAccessor<Float> LASER_LENGTH = SynchedEntityData.m_135353_(LaserTowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int changeTargetTimer = 60;

    public LaserTowerEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<LaserTowerEntity>)((EntityType)ModEntities.LASER_TOWER.get()), world);
    }

    public LaserTowerEntity(EntityType<LaserTowerEntity> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
    }

    public LaserTowerEntity(LivingEntity owner, Level level) {
        super((EntityType)ModEntities.LASER_TOWER.get(), level);
        if (owner != null) {
            this.setOwnerUUID(owner.m_20148_());
        }
    }

    public boolean isOwnedBy(LivingEntity pEntity) {
        return pEntity == this.m_269323_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_UUID, (Object)"none");
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(COOL_DOWN, (Object)0);
        this.f_19804_.m_135372_(LASER_LENGTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ACTIVE, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("CoolDown", ((Integer)this.f_19804_.m_135370_(COOL_DOWN)).intValue());
        compound.m_128379_("Active", ((Boolean)this.f_19804_.m_135370_(ACTIVE)).booleanValue());
        if (this.m_21805_() != null) {
            compound.m_128362_("Owner", this.m_21805_());
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        UUID uuid;
        super.m_7378_(compound);
        this.f_19804_.m_135381_(COOL_DOWN, (Object)compound.m_128451_("CoolDown"));
        this.f_19804_.m_135381_(ACTIVE, (Object)compound.m_128471_("Active"));
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String s = compound.m_128461_("Owner");
            try {
                uuid = this.m_20194_() == null ? UUID.fromString(s) : OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
            }
            catch (Exception exception) {
                Mod.LOGGER.error("Couldn't load owner UUID of {}: {}", (Object)this, (Object)exception);
                uuid = null;
            }
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21205_();
        if (player.m_6047_()) {
            if (stack.m_204117_(ModTags.Items.CROWBAR) && (this.m_269323_() == null || player == this.m_269323_())) {
                ItemStack container = ContainerBlockItem.createInstance(this);
                if (!player.m_36356_(container)) {
                    player.m_36176_(container, false);
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                this.m_146870_();
                return InteractionResult.SUCCESS;
            }
            if (this.m_21805_() == null) {
                this.setOwnerUUID(player.m_20148_());
            }
            if (this.m_269323_() == player) {
                this.f_19804_.m_135381_(ACTIVE, (Object)((Boolean)this.f_19804_.m_135370_(ACTIVE) == false ? 1 : 0));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), SoundEvents.f_11686_, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    @NotNull
    public Vec3 m_20184_() {
        return new Vec3(0.0, Math.min((double)super.m_20184_().f_82480_, (double)0.0), 0.0);
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        if ((Integer)this.f_19804_.m_135370_(COOL_DOWN) > 0) {
            this.f_19804_.m_135381_(COOL_DOWN, (Object)((Integer)this.f_19804_.m_135370_(COOL_DOWN) - 1));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.m_20096_()) {
            this.m_20256_(Vec3.f_82478_);
        } else {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.autoAim();
    }

    @Override
    public void handleClientSync() {
        if (this.m_6109_()) {
            this.interpolationSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedYaw = Mth.m_14175_((double)(this.serverYRot - (double)this.m_146908_()));
        this.m_146922_(this.m_146908_() + (float)interpolatedYaw / (float)this.interpolationSteps);
        this.m_146926_(this.m_146909_() + (float)(this.serverXRot - (double)this.m_146909_()) / (float)this.interpolationSteps);
        this.m_19915_(this.m_146908_(), this.m_146909_());
    }

    @Override
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.serverYRot = yaw;
        this.serverXRot = pitch;
        this.interpolationSteps = 10;
    }

    public void autoAim() {
        Entity target;
        Entity naerestEntity;
        if (this.getEnergy() <= 0 || !((Boolean)this.f_19804_.m_135370_(ACTIVE)).booleanValue()) {
            return;
        }
        Vec3 barrelRootPos = new Vec3(this.m_20185_(), this.m_20186_() + 1.390625, this.m_20189_());
        if (((String)this.f_19804_.m_135370_(TARGET_UUID)).equals("none") && this.f_19797_ % 10 == 0 && (Integer)this.f_19804_.m_135370_(COOL_DOWN) == 0 && (naerestEntity = this.seekNearLivingEntity(this, barrelRootPos, -40.0, 90.0, 1.0, 72.0, 0.01)) != null) {
            this.f_19804_.m_135381_(TARGET_UUID, (Object)naerestEntity.m_20149_());
        }
        if ((target = EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(TARGET_UUID))) != null && SeekTool.smokeFilter(target)) {
            LivingEntity living;
            Player player1;
            if (target instanceof Player && ((player1 = (Player)target).m_5833_() || player1.m_7500_())) {
                this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                return;
            }
            if (VehicleEntity.getSubmergedHeight(target) >= (double)target.m_20206_()) {
                this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                return;
            }
            if (target.m_20270_((Entity)this) > 72.0f) {
                this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                return;
            }
            if (target instanceof LivingEntity && (living = (LivingEntity)target).m_21223_() <= 0.0f) {
                this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                return;
            }
            if (target == this || target instanceof TargetEntity) {
                this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                return;
            }
            if (target instanceof Projectile && (VectorTool.calculateAngle(target.m_20184_().m_82541_(), target.m_20182_().m_82505_(this.m_20182_()).m_82541_()) > 60.0 || target.m_20096_() || target.m_20184_().m_82556_() < 0.001)) {
                this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                return;
            }
            Vec3 targetVec = barrelRootPos.m_82505_(target.m_146892_()).m_82541_();
            double d0 = targetVec.f_82479_;
            double d1 = targetVec.f_82480_;
            double d2 = targetVec.f_82481_;
            double d3 = Math.sqrt((double)(d0 * d0 + d2 * d2));
            this.m_146926_(Mth.m_14036_((float)Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875)))), (float)-90.0f, (float)40.0f));
            float targetY = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
            float diffY = Math.clamp((float)-90.0f, (float)90.0f, (float)Mth.m_14177_((float)(targetY - this.m_146908_())));
            this.turretTurnSound(0.0f, diffY, 1.1f);
            this.m_146922_(this.m_146908_() + Mth.m_14036_((float)(0.5f * diffY), (float)-60.0f, (float)60.0f));
            this.m_19915_(this.m_146908_(), this.m_146909_());
            if ((Integer)this.f_19804_.m_135370_(COOL_DOWN) == 0 && VectorTool.calculateAngle(this.m_20252_(1.0f), targetVec) < 1.0) {
                ++this.changeTargetTimer;
            }
            if ((Integer)this.f_19804_.m_135370_(COOL_DOWN) == 0 && VectorTool.calculateAngle(this.m_20252_(1.0f), targetVec) < 1.0 && this.checkNoClip(this, target, barrelRootPos)) {
                this.f_19804_.m_135381_(COOL_DOWN, (Object)((Integer)VehicleConfig.LASER_TOWER_COOLDOWN.get()));
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.m_9236_().m_245803_((Entity)this, this.m_20097_(), (SoundEvent)ModSounds.LASER_TOWER_SHOOT.get(), SoundSource.PLAYERS, 2.0f, this.f_19796_.m_188501_() * 0.1f + 1.0f);
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123810_, target.m_20185_(), target.m_20188_(), target.m_20189_(), 12, 0.0, 0.0, 0.0, 0.05, true);
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123756_, target.m_20185_(), target.m_20188_(), target.m_20189_(), 4, 0.0, 0.0, 0.0, 0.15, true);
                }
                DamageHandler.doDamage(target, ModDamageTypes.causeLaserStaticDamage(this.m_9236_().m_9598_(), this, (Entity)this.m_269323_()), ((Integer)VehicleConfig.LASER_TOWER_DAMAGE.get()).intValue());
                target.f_19802_ = 0;
                this.f_19804_.m_135381_(LASER_LENGTH, (Object)Float.valueOf(this.m_20270_(target)));
                if (Math.random() < 0.25 && target instanceof LivingEntity) {
                    LivingEntity living2 = (LivingEntity)target;
                    living2.m_20254_(2);
                }
                if (target instanceof Projectile) {
                    this.causeAirExplode(target.m_20182_());
                    target.m_146870_();
                }
                if (!target.m_6084_()) {
                    this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                }
                this.consumeEnergy((Integer)VehicleConfig.LASER_TOWER_SHOOT_COST.get());
            }
        } else {
            this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
        }
        if (this.changeTargetTimer > 60) {
            this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
            this.changeTargetTimer = 0;
        }
    }

    @Override
    public boolean basicEnemyFilter(Entity pEntity) {
        if (pEntity instanceof Projectile) {
            return false;
        }
        if (this.m_269323_() == null) {
            return false;
        }
        if (pEntity.m_5647_() == null) {
            return false;
        }
        return !pEntity.m_7307_((Entity)this.m_269323_()) || pEntity.m_5647_() != null && pEntity.m_5647_().m_5758_().equals("TDM");
    }

    @Override
    public boolean basicEnemyProjectileFilter(Projectile projectile) {
        if (this.m_269323_() == null) {
            return false;
        }
        if (projectile.m_19749_() != null && projectile.m_19749_() == this.m_269323_()) {
            return false;
        }
        return projectile.m_19749_() != null && !projectile.m_19749_().m_7307_((Entity)this.m_269323_()) || projectile.m_19749_() != null && projectile.m_19749_().m_5647_() != null && projectile.m_19749_().m_5647_().m_5758_().equals("TDM") || projectile.m_19749_() == null;
    }

    private void causeAirExplode(Vec3 vec3) {
        this.createCustomExplosion().damage(5.0f).radius(1.0f).keepBlock().attacker((Entity)this.m_269323_()).position(vec3).withParticleType(ParticleTool.ParticleType.MEDIUM).explode();
    }

    private PlayState movementPredicate(AnimationState<LaserTowerEntity> event) {
        if ((Integer)this.f_19804_.m_135370_(COOL_DOWN) > 10) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.lt.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.lt.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/laser_tower_icon.png");
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/defense.png");
    }

    @Override
    public boolean hasEnergyStorage() {
        return true;
    }
}

