/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArtilleryEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.CannonEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.LaserWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AnnihilatorEntity
extends VehicleEntity
implements GeoEntity,
CannonEntity,
OBBEntity,
ArtilleryEntity {
    public static final EntityDataAccessor<Integer> COOL_DOWN = SynchedEntityData.m_135353_(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> LASER_LEFT_LENGTH = SynchedEntityData.m_135353_(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> LASER_MIDDLE_LENGTH = SynchedEntityData.m_135353_(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> LASER_RIGHT_LENGTH = SynchedEntityData.m_135353_(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> PITCH = SynchedEntityData.m_135353_(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> YAW = SynchedEntityData.m_135353_(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<String> SHOOTER_UUID = SynchedEntityData.m_135353_(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public OBB obb;
    public OBB obb2;
    public OBB obb3;
    public OBB obb4;
    public OBB obb5;
    public Vec3 barrelLookAt;

    public AnnihilatorEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<AnnihilatorEntity>)((EntityType)ModEntities.ANNIHILATOR.get()), world);
    }

    public AnnihilatorEntity(EntityType<AnnihilatorEntity> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
        this.obb = new OBB(this.m_20182_().m_252839_(), new Vector3f(6.4375f, 1.84375f, 4.125f), new Quaternionf(), OBB.Part.BODY);
        this.obb2 = new OBB(this.m_20182_().m_252839_(), new Vector3f(5.0625f, 1.40625f, 1.5f), new Quaternionf(), OBB.Part.BODY);
        this.obb3 = new OBB(this.m_20182_().m_252839_(), new Vector3f(5.1875f, 1.84375f, 1.96875f), new Quaternionf(), OBB.Part.BODY);
        this.obb4 = new OBB(this.m_20182_().m_252839_(), new Vector3f(4.125f, 1.84375f, 0.75f), new Quaternionf(), OBB.Part.BODY);
        this.obb5 = new OBB(this.m_20182_().m_252839_(), new Vector3f(7.75f, 0.71875f, 1.46875f), new Quaternionf(), OBB.Part.BODY);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(this.m_146908_()));
        this.f_19804_.m_135381_(PITCH, (Object)Float.valueOf(this.m_146909_()));
    }

    @Override
    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new LaserWeapon()}};
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(16.0 + 2.0 * ClientMouseHandler.custom3pDistanceLerp, 1.3, 0.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COOL_DOWN, (Object)0);
        this.f_19804_.m_135372_(SHOOTER_UUID, (Object)"none");
        this.f_19804_.m_135372_(LASER_LEFT_LENGTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LASER_MIDDLE_LENGTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LASER_RIGHT_LENGTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(YAW, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("CoolDown", ((Integer)this.f_19804_.m_135370_(COOL_DOWN)).intValue());
        compound.m_128350_("Pitch", ((Float)this.f_19804_.m_135370_(PITCH)).floatValue());
        compound.m_128350_("Yaw", ((Float)this.f_19804_.m_135370_(YAW)).floatValue());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(COOL_DOWN, (Object)compound.m_128451_("CoolDown"));
        this.f_19804_.m_135381_(PITCH, (Object)Float.valueOf(compound.m_128457_("Pitch")));
        this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(compound.m_128457_("Yaw")));
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21205_();
        if (player.m_21205_().m_41720_() == ModItems.FIRING_PARAMETERS.get() && player.m_6047_()) {
            this.setTarget(player.m_21206_());
            return InteractionResult.SUCCESS;
        }
        if (player.m_21206_().m_41720_() == ModItems.FIRING_PARAMETERS.get() && player.m_6047_()) {
            this.setTarget(player.m_21206_());
            return InteractionResult.SUCCESS;
        }
        if (stack.m_204117_(ModTags.Items.CROWBAR) && !player.m_6047_()) {
            if ((Integer)this.f_19804_.m_135370_(COOL_DOWN) == 0) {
                this.vehicleShoot((LivingEntity)player, 0);
                this.f_19804_.m_135381_(SHOOTER_UUID, (Object)player.m_20149_());
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(player, hand);
    }

    public void setTarget(ItemStack stack) {
        int targetX = stack.m_41784_().m_128451_("TargetX");
        int targetY = stack.m_41784_().m_128451_("TargetY");
        int targetZ = stack.m_41784_().m_128451_("TargetZ");
        this.look(new Vec3((double)targetX, (double)targetY, (double)targetZ));
    }

    private void look(Vec3 pTarget) {
        float yRot = this.m_146908_();
        if (yRot < 0.0f) {
            yRot += 360.0f;
        }
        Vector3d BarrelRoot = new Vector3d(4.95, 2.25, 0.0);
        BarrelRoot.rotateY((double)(-(yRot += 90.0f) * ((float)Math.PI / 180)));
        Vec3 vec3 = new Vec3(this.m_20185_() + BarrelRoot.x, this.m_20186_() + BarrelRoot.y, this.m_20189_() + BarrelRoot.z);
        double d0 = pTarget.f_82479_ - vec3.f_82479_;
        double d1 = pTarget.f_82480_ - vec3.f_82480_;
        double d2 = pTarget.f_82481_ - vec3.f_82481_;
        double d3 = org.joml.Math.sqrt((double)(d0 * d0 + d2 * d2));
        this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f))));
        this.f_19804_.m_135381_(PITCH, (Object)Float.valueOf(Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875))))));
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleFlatTransform(1.0f);
        float x = 0.0f;
        float y = 3.3f;
        float z = 1.5f;
        Vector4f worldPosition = this.transformPosition(transform, x, y, z);
        passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 3.0f) * damage.floatValue()));
    }

    @NotNull
    public Vec3 m_20184_() {
        return new Vec3(0.0, org.joml.Math.min((double)super.m_20184_().f_82480_, (double)0.0), 0.0);
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        this.updateOBB();
        if ((Integer)this.f_19804_.m_135370_(COOL_DOWN) > 0) {
            this.f_19804_.m_135381_(COOL_DOWN, (Object)((Integer)this.f_19804_.m_135370_(COOL_DOWN) - 1));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.m_20096_()) {
            this.m_20256_(Vec3.f_82478_);
        } else {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.lowHealthWarning();
        float delta = org.joml.Math.abs((float)(this.m_146908_() - this.f_19859_));
        while (this.m_146908_() > 180.0f) {
            this.m_146922_(this.m_146908_() - 360.0f);
            this.f_19859_ = this.m_146908_() - delta;
        }
        while (this.m_146908_() <= -180.0f) {
            this.m_146922_(this.m_146908_() + 360.0f);
            this.f_19859_ = delta + this.m_146908_();
        }
        float yRot = this.m_146908_();
        if (yRot < 0.0f) {
            yRot += 360.0f;
        }
        Vector3d BarrelRoot = new Vector3d(4.95, 2.25, 0.0);
        BarrelRoot.rotateY((double)(-(yRot += 90.0f) * ((float)Math.PI / 180)));
        Vec3 BarrelRootPos = new Vec3(this.m_20185_() + BarrelRoot.x, this.m_20186_() + BarrelRoot.y, this.m_20189_() + BarrelRoot.z);
        Vector3d leftPos = new Vector3d(16.0, 0.0, -2.703125);
        leftPos.rotateZ((double)(-this.m_146909_() * ((float)Math.PI / 180)));
        leftPos.rotateY((double)(-yRot * ((float)Math.PI / 180)));
        Vec3 BarrelLeftPos = new Vec3(BarrelRootPos.f_82479_ + leftPos.x, BarrelRootPos.f_82480_ + leftPos.y, BarrelRootPos.f_82481_ + leftPos.z);
        Vector3d middlePos = new Vector3d(16.0, 0.0, 0.0);
        middlePos.rotateZ((double)(-this.m_146909_() * ((float)Math.PI / 180)));
        middlePos.rotateY((double)(-yRot * ((float)Math.PI / 180)));
        Vec3 BarrelMiddlePos = new Vec3(BarrelRootPos.f_82479_ + middlePos.x, BarrelRootPos.f_82480_ + middlePos.y, BarrelRootPos.f_82481_ + middlePos.z);
        Vector3d rightPos = new Vector3d(16.0, 0.0, 2.703125);
        rightPos.rotateZ((double)(-this.m_146909_() * ((float)Math.PI / 180)));
        rightPos.rotateY((double)(-yRot * ((float)Math.PI / 180)));
        Vec3 BarrelRightPos = new Vec3(BarrelRootPos.f_82479_ + rightPos.x, BarrelRootPos.f_82480_ + rightPos.y, BarrelRootPos.f_82481_ + rightPos.z);
        if ((Integer)this.f_19804_.m_135370_(COOL_DOWN) > 88) {
            this.f_19804_.m_135381_(LASER_LEFT_LENGTH, (Object)Float.valueOf(org.joml.Math.min((float)this.laserLength(BarrelLeftPos, this), (float)this.laserLengthEntity(BarrelLeftPos, this))));
            this.f_19804_.m_135381_(LASER_MIDDLE_LENGTH, (Object)Float.valueOf(org.joml.Math.min((float)this.laserLength(BarrelMiddlePos, this), (float)this.laserLengthEntity(BarrelMiddlePos, this))));
            this.f_19804_.m_135381_(LASER_RIGHT_LENGTH, (Object)Float.valueOf(org.joml.Math.min((float)this.laserLength(BarrelRightPos, this), (float)this.laserLengthEntity(BarrelRightPos, this))));
        }
        if ((Integer)this.f_19804_.m_135370_(COOL_DOWN) == 20) {
            this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ModSounds.ANNIHILATOR_RELOAD.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public void handleClientSync() {
        if (this.m_6109_()) {
            this.interpolationSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedYaw = Mth.m_14175_((double)(this.serverYRot - (double)this.m_146908_()));
        this.m_146922_(this.m_146908_() + (float)interpolatedYaw / (float)this.interpolationSteps);
        this.m_146926_(this.m_146909_() + (float)(this.serverXRot - (double)this.m_146909_()) / (float)this.interpolationSteps);
        this.m_19915_(this.m_146908_(), this.m_146909_());
    }

    @Override
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.serverYRot = yaw;
        this.serverXRot = pitch;
        this.interpolationSteps = 10;
    }

    private float laserLength(Vec3 pos, Entity cannon) {
        if (this.m_9236_() instanceof ServerLevel) {
            BlockHitResult result = cannon.m_9236_().m_45547_(new ClipContext(pos, pos.m_82549_(cannon.m_20252_(1.0f).m_82490_(512.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, cannon));
            Vec3 looking = Vec3.m_82528_((Vec3i)result.m_82425_());
            Vec3 hitPos = result.m_82450_();
            BlockPos _pos = BlockPos.m_274561_((double)looking.f_82479_, (double)looking.f_82480_, (double)looking.f_82481_);
            float hardness = this.m_9236_().m_8055_(_pos).m_60734_().m_155943_();
            if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue() && hardness != -1.0f) {
                Block.m_49892_((BlockState)this.m_9236_().m_8055_(_pos), (LevelAccessor)this.m_9236_(), (BlockPos)_pos, null);
                this.m_9236_().m_46961_(_pos, true);
            }
            if ((Integer)this.f_19804_.m_135370_(COOL_DOWN) > 98) {
                this.laserExplosion(hitPos);
            }
            if (this.m_146895_() != null) {
                this.m_9236_().m_254849_(this.m_146895_(), hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 5.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
            } else {
                Entity shooter = EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(SHOOTER_UUID));
                this.m_9236_().m_254849_(shooter, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 5.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
            }
        }
        return (float)pos.m_82554_(Vec3.m_82528_((Vec3i)cannon.m_9236_().m_45547_(new ClipContext(pos, pos.m_82549_(cannon.m_20252_(1.0f).m_82490_(512.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, cannon)).m_82425_()));
    }

    private float laserLengthEntity(Vec3 pos, Entity cannon) {
        if (this.m_9236_() instanceof ServerLevel) {
            AABB aabb;
            double blockReach;
            double distance = 262144.0;
            HitResult hitResult = cannon.m_19907_(512.0, 1.0f, false);
            if (hitResult.m_6662_() != HitResult.Type.MISS && (distance = hitResult.m_82450_().m_82557_(pos)) > (blockReach = 5.0) * blockReach) {
                Vec3 posB = hitResult.m_82450_();
                hitResult = BlockHitResult.m_82426_((Vec3)posB, (Direction)Direction.m_122366_((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_), (BlockPos)BlockPos.m_274446_((Position)posB));
            }
            Vec3 viewVec = cannon.m_20252_(1.0f);
            Vec3 toVec = pos.m_82520_(viewVec.f_82479_ * 512.0, viewVec.f_82480_ * 512.0, viewVec.f_82481_ * 512.0);
            EntityHitResult entityhitresult = ProjectileUtil.m_37287_((Entity)cannon, (Vec3)pos, (Vec3)toVec, (AABB)(aabb = cannon.m_20191_().m_82369_(viewVec.m_82490_(512.0)).m_82377_(1.0, 1.0, 1.0)), p -> !p.m_5833_(), (double)distance);
            if (entityhitresult != null) {
                Vec3 targetPos = entityhitresult.m_82450_();
                double distanceToTarget = pos.m_82557_(targetPos);
                if (distanceToTarget > distance || distanceToTarget > 262144.0) {
                    hitResult = BlockHitResult.m_82426_((Vec3)targetPos, (Direction)Direction.m_122366_((double)viewVec.f_82479_, (double)viewVec.f_82480_, (double)viewVec.f_82481_), (BlockPos)BlockPos.m_274446_((Position)targetPos));
                } else if (distanceToTarget < distance) {
                    hitResult = entityhitresult;
                }
                if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
                    Entity passenger = this.m_146895_();
                    Entity target = ((EntityHitResult)hitResult).m_82443_();
                    if (passenger != null) {
                        DamageHandler.doDamage(target, ModDamageTypes.causeLaserDamage(this.m_9236_().m_9598_(), this, passenger), 200.0f);
                    } else {
                        Entity shooter = EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(SHOOTER_UUID));
                        DamageHandler.doDamage(target, ModDamageTypes.causeLaserDamage(this.m_9236_().m_9598_(), this, shooter), 200.0f);
                    }
                    target.f_19802_ = 0;
                    if ((Integer)this.f_19804_.m_135370_(COOL_DOWN) > 98) {
                        this.laserExplosion(targetPos);
                    }
                    return (float)pos.m_82554_(target.m_20182_());
                }
            }
        }
        return 512.0f;
    }

    private void laserExplosion(Vec3 pos) {
        Entity passenger = this.m_146895_();
        if (passenger != null) {
            this.createCustomExplosion().damage(300.0f).radius(15.0f).position(pos).withParticleType(ParticleTool.ParticleType.HUGE).explode();
        } else {
            Entity shooter = EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(SHOOTER_UUID));
            this.createCustomExplosion().damage(300.0f).radius(15.0f).attacker(shooter).withParticleType(ParticleTool.ParticleType.HUGE).position(pos).explode();
        }
    }

    @Override
    public void vehicleShoot(LivingEntity living, int type) {
        if ((Integer)this.f_19804_.m_135370_(COOL_DOWN) > 0) {
            return;
        }
        if (!this.canConsume((Integer)VehicleConfig.ANNIHILATOR_SHOOT_COST.get()) && living instanceof Player) {
            Player player = (Player)living;
            player.m_5661_((Component)Component.m_237115_((String)"tips.superbwarfare.annihilator.energy_not_enough").m_130940_(ChatFormatting.RED), true);
            return;
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (living instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)living;
                SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.ANNIHILATOR_FIRE_1P.get(), 1.0f, 1.0f);
            }
            serverLevel.m_5594_(null, this.m_20097_(), (SoundEvent)ModSounds.ANNIHILATOR_FIRE_3P.get(), SoundSource.PLAYERS, 6.0f, 1.0f);
            serverLevel.m_5594_(null, this.m_20097_(), (SoundEvent)ModSounds.ANNIHILATOR_FAR.get(), SoundSource.PLAYERS, 16.0f, 1.0f);
            serverLevel.m_5594_(null, this.m_20097_(), (SoundEvent)ModSounds.ANNIHILATOR_VERYFAR.get(), SoundSource.PLAYERS, 32.0f, 1.0f);
            this.f_19804_.m_135381_(COOL_DOWN, (Object)100);
            this.consumeEnergy((Integer)VehicleConfig.ANNIHILATOR_SHOOT_COST.get());
            ShakeClientMessage.sendToNearbyPlayers(this, 20.0, 15.0, 15.0, 25.0);
        }
    }

    @Override
    public void travel() {
        Entity passenger = this.m_146895_();
        if (this.getEnergy() <= 0) {
            return;
        }
        if (passenger instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)passenger;
            float yRot = this.m_146908_();
            if (yRot < 0.0f) {
                yRot += 360.0f;
            }
            Vector3d BarrelRoot = new Vector3d(4.95, 2.25, 0.0);
            BarrelRoot.rotateY((double)(-(yRot += 90.0f) * ((float)Math.PI / 180)));
            Vec3 barrelRootPos = new Vec3(this.m_20185_() + BarrelRoot.x, this.m_20186_() + BarrelRoot.y, this.m_20189_() + BarrelRoot.z);
            Vec3 passengersEyePos = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
            Entity lookingAt = TraceTool.findLookingEntity((Entity)entity, 512.0);
            if (lookingAt == null) {
                BlockHitResult result = entity.m_9236_().m_45547_(new ClipContext(passengersEyePos, passengersEyePos.m_82549_(entity.m_20252_(1.0f).m_82490_(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity));
                Vec3 blockHitPos = result.m_82450_();
                this.barrelLookAt = new Vec3(blockHitPos.f_82479_ - barrelRootPos.f_82479_, blockHitPos.f_82480_ - barrelRootPos.f_82480_, blockHitPos.f_82481_ - barrelRootPos.f_82481_);
            } else {
                this.barrelLookAt = new Vec3(lookingAt.m_20185_() - barrelRootPos.f_82479_, lookingAt.m_20188_() - barrelRootPos.f_82480_, lookingAt.m_20189_() - barrelRootPos.f_82481_);
            }
            float offset = (float)VectorTool.calculateAngle(entity.m_20252_(1.0f), this.barrelLookAt);
            this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(passenger.m_6080_()));
            this.f_19804_.m_135381_(PITCH, (Object)Float.valueOf(Mth.m_14036_((float)(passenger.m_146909_() - offset), (float)-45.0f, (float)5.0f)));
        }
        float diffY = Mth.m_14177_((float)(((Float)this.f_19804_.m_135370_(YAW)).floatValue() - this.m_146908_()));
        float diffX = Mth.m_14177_((float)(((Float)this.f_19804_.m_135370_(PITCH)).floatValue() - this.m_146909_()));
        this.turretTurnSound(diffX, diffY, 0.8f);
        this.m_146922_(this.m_146908_() + Mth.m_14036_((float)(0.5f * diffY), (float)-0.6f, (float)0.6f));
        this.m_146926_(Mth.m_14036_((float)(this.m_146909_() + Mth.m_14036_((float)diffX, (float)-0.8f, (float)0.8f)), (float)-45.0f, (float)5.0f));
    }

    public void autoAim() {
        if (this.getEnergy() <= 0) {
            return;
        }
        Entity target = SeekTool.seekLivingEntity(this, this.m_9236_(), 64.0, 30.0);
        if (target == null) {
            return;
        }
        float yRot = this.m_146908_();
        if (yRot < 0.0f) {
            yRot += 360.0f;
        }
        Vector3d BarrelRoot = new Vector3d(4.95, 2.25, 0.0);
        BarrelRoot.rotateY((double)(-(yRot += 90.0f) * ((float)Math.PI / 180)));
        Vec3 barrelRootPos = new Vec3(this.m_20185_() + BarrelRoot.x, this.m_20186_() + BarrelRoot.y, this.m_20189_() + BarrelRoot.z);
        Vec3 targetVec = new Vec3(target.m_20185_() - barrelRootPos.f_82479_, target.m_20188_() - barrelRootPos.f_82480_, target.m_20189_() - barrelRootPos.f_82481_).m_82541_();
        double d0 = targetVec.f_82479_;
        double d1 = targetVec.f_82480_;
        double d2 = targetVec.f_82481_;
        double d3 = org.joml.Math.sqrt((double)(d0 * d0 + d2 * d2));
        this.m_146926_(Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875)))));
        float targetY = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
        float diffY = org.joml.Math.clamp((float)-90.0f, (float)90.0f, (float)Mth.m_14177_((float)(targetY - this.m_146908_())));
        this.m_146922_(this.m_146908_() + Mth.m_14036_((float)(0.5f * diffY), (float)-1.0f, (float)1.0f));
        this.m_19915_(this.m_146908_(), this.m_146909_());
    }

    protected void clampRotation(Entity entity) {
        float f = Mth.m_14177_((float)entity.m_146909_());
        float f1 = Mth.m_14036_((float)f, (float)-45.0f, (float)5.0f);
        entity.f_19860_ += f1 - f;
        entity.m_146926_(entity.m_146909_() + f1 - f);
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    private PlayState movementPredicate(AnimationState<AnnihilatorEntity> event) {
        if ((Integer)this.f_19804_.m_135370_(COOL_DOWN) > 85) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.annihilator.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.annihilator.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public int mainGunRpm(LivingEntity living) {
        return 0;
    }

    @Override
    public boolean canShoot(LivingEntity living) {
        return true;
    }

    @Override
    public int getAmmoCount(LivingEntity living) {
        return (int)((float)this.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0).intValue() * 100.0f / (float)this.getMaxEnergy());
    }

    @Override
    public boolean hidePassenger(int index) {
        return true;
    }

    @Override
    public int zoomFov() {
        return 5;
    }

    @Override
    public int getWeaponHeat(LivingEntity living) {
        return 0;
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/annihilator_icon.png");
    }

    @Override
    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return zoom ? 0.15 : 0.3;
    }

    @Override
    public boolean isEnclosed(int index) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            return new Vec2(Mth.m_14179_((float)partialTicks, (float)player.f_19859_, (float)player.m_146908_()), Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean useFixedCameraPos(Entity entity) {
        return true;
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/defense.png");
    }

    @Override
    public List<OBB> getOBBs() {
        return List.of(this.obb, this.obb2, this.obb3, this.obb4, this.obb5);
    }

    @Override
    public void updateOBB() {
        Matrix4f transform = this.getVehicleHorizontalTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 2.28125f, 0.875f);
        this.obb.center().set((Vector3fc)new Vector3f(worldPosition.x, worldPosition.y, worldPosition.z));
        this.obb.setRotation(VectorTool.combineRotationsYaw(1.0f, this));
        Vector4f worldPosition2 = this.transformPosition(transform, 0.0f, 1.84375f, 6.5f);
        this.obb2.center().set((Vector3fc)new Vector3f(worldPosition2.x, worldPosition2.y, worldPosition2.z));
        this.obb2.setRotation(VectorTool.combineRotationsYaw(1.0f, this));
        Vector4f worldPosition3 = this.transformPosition(transform, 0.0f, 2.28125f, -5.21875f);
        this.obb3.center().set((Vector3fc)new Vector3f(worldPosition3.x, worldPosition3.y, worldPosition3.z));
        this.obb3.setRotation(VectorTool.combineRotationsYaw(1.0f, this));
        Vector4f worldPosition4 = this.transformPosition(transform, 0.0f, 2.28125f, -7.9375f);
        this.obb4.center().set((Vector3fc)new Vector3f(worldPosition4.x, worldPosition4.y, worldPosition4.z));
        this.obb4.setRotation(VectorTool.combineRotationsYaw(1.0f, this));
        Vector4f worldPosition5 = this.transformPosition(transform, 0.0f, 2.46875f, -5.28125f);
        this.obb5.center().set((Vector3fc)new Vector3f(worldPosition5.x, worldPosition5.y, worldPosition5.z));
        this.obb5.setRotation(VectorTool.combineRotationsYaw(1.0f, this));
    }

    @Override
    public boolean hasEnergyStorage() {
        return true;
    }
}

