/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SwarmDroneEntity
extends FastThrowableProjectile
implements GeoEntity,
ExplosiveProjectile {
    public static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.m_135353_(SwarmDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Float> TARGET_X = SynchedEntityData.m_135353_(SwarmDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> TARGET_Y = SynchedEntityData.m_135353_(SwarmDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> TARGET_Z = SynchedEntityData.m_135353_(SwarmDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(SwarmDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean distracted = false;
    private float explosionDamage = 80.0f;
    private float explosionRadius = 5.0f;
    private float gravity = 0.1f;
    private float randomFloat;
    private int guideType = 0;
    private static final DamageModifier DAMAGE_MODIFIER = DamageModifier.createDefaultModifier().immuneTo((EntityType)ModEntities.SWARM_DRONE.get());

    public SwarmDroneEntity(EntityType<? extends SwarmDroneEntity> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
    }

    public SwarmDroneEntity(double x, double y, double z, Level level) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.SWARM_DRONE.get()), x, y, z, level);
        this.f_19811_ = true;
    }

    public SwarmDroneEntity(LivingEntity entity, Level level, float explosionDamage, float explosionRadius) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.SWARM_DRONE.get()), (Entity)entity, level);
        this.f_19811_ = true;
        this.explosionDamage = explosionDamage;
        this.explosionRadius = explosionRadius;
    }

    public SwarmDroneEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends SwarmDroneEntity>)((EntityType)ModEntities.SWARM_DRONE.get()), level);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.SWARM_DRONE.get();
    }

    public void setTargetUuid(String uuid) {
        this.f_19804_.m_135381_(TARGET_UUID, (Object)uuid);
    }

    public void setGuideType(int guideType) {
        this.guideType = guideType;
    }

    public void setTargetVec(Vec3 targetPos) {
        this.f_19804_.m_135381_(TARGET_X, (Object)Float.valueOf((float)targetPos.f_82479_));
        this.f_19804_.m_135381_(TARGET_Y, (Object)Float.valueOf((float)targetPos.f_82480_));
        this.f_19804_.m_135381_(TARGET_Z, (Object)Float.valueOf((float)targetPos.f_82481_));
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        amount = DAMAGE_MODIFIER.compute(source, amount);
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() - amount));
        return super.m_6469_(source, amount);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(10.0f));
        this.f_19804_.m_135372_(TARGET_UUID, (Object)"none");
        this.f_19804_.m_135372_(TARGET_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TARGET_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TARGET_Z, (Object)Float.valueOf(0.0f));
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Health")) {
            this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(compound.m_128457_("Health")));
        }
        if (compound.m_128441_("TargetUUID")) {
            this.f_19804_.m_135381_(TARGET_UUID, (Object)compound.m_128461_("TargetUUID"));
        }
        if (compound.m_128441_("TargetX")) {
            this.f_19804_.m_135381_(TARGET_X, (Object)Float.valueOf(compound.m_128457_("TargetX")));
        }
        if (compound.m_128441_("TargetY")) {
            this.f_19804_.m_135381_(TARGET_X, (Object)Float.valueOf(compound.m_128457_("TargetY")));
        }
        if (compound.m_128441_("TargetZ")) {
            this.f_19804_.m_135381_(TARGET_X, (Object)Float.valueOf(compound.m_128457_("TargetZ")));
        }
        if (compound.m_128441_("ExplosionDamage")) {
            this.explosionDamage = compound.m_128457_("ExplosionDamage");
        }
        if (compound.m_128441_("Radius")) {
            this.explosionRadius = compound.m_128457_("Radius");
        }
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Health", ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue());
        compound.m_128359_("TargetUUID", (String)this.f_19804_.m_135370_(TARGET_UUID));
        compound.m_128350_("TargetX", ((Float)this.f_19804_.m_135370_(TARGET_X)).floatValue());
        compound.m_128350_("TargetY", ((Float)this.f_19804_.m_135370_(TARGET_Y)).floatValue());
        compound.m_128350_("TargetZ", ((Float)this.f_19804_.m_135370_(TARGET_Z)).floatValue());
        compound.m_128350_("ExplosionDamage", this.explosionDamage);
        compound.m_128350_("Radius", this.explosionRadius);
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }

    @Override
    protected void m_5790_(EntityHitResult result) {
        LivingEntity living;
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (entity instanceof SwarmDroneEntity) {
            return;
        }
        if (this.m_19749_() != null && this.m_19749_().m_20202_() != null && entity == this.m_19749_().m_20202_()) {
            return;
        }
        Entity entity2 = this.m_19749_();
        if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).m_9236_().m_5776_() && living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            living.m_9236_().m_5594_(null, living.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
            Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
        }
        if (this.m_9236_() instanceof ServerLevel) {
            this.causeMissileExplode(ModDamageTypes.causeCustomExplosionDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.explosionDamage, this.explosionRadius);
        }
    }

    @Override
    public void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.m_9236_() instanceof ServerLevel) {
            this.causeMissileExplode(ModDamageTypes.causeCustomExplosionDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.explosionDamage, this.explosionRadius);
        }
    }

    @Override
    public void m_8119_() {
        Entity e2;
        super.m_8119_();
        Entity entity = EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(TARGET_UUID));
        List<Entity> decoy = SeekTool.seekLivingEntities((Entity)this, this.m_9236_(), 32.0, 90.0);
        for (Entity e2 : decoy) {
            if (!e2.m_6095_().m_204039_(ModTags.EntityTypes.DECOY) || this.distracted) continue;
            this.f_19804_.m_135381_(TARGET_UUID, (Object)e2.m_20149_());
            this.distracted = true;
            break;
        }
        if (this.f_19797_ == 1 && !this.m_9236_().m_5776_() && (e2 = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)e2;
            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123796_, this.f_19854_, this.f_19855_, this.f_19856_, 15, 0.8, 0.8, 0.8, 0.01, true);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123777_, this.f_19854_, this.f_19855_, this.f_19856_, 10, 0.8, 0.8, 0.8, 0.01, true);
        }
        if (this.f_19797_ > 10 && this.m_19749_() != null) {
            Vec3 targetPos;
            Entity shooter = this.m_19749_();
            if (this.guideType == 0 && entity != null) {
                targetPos = entity.m_146892_();
                this.f_19804_.m_135381_(TARGET_X, (Object)Float.valueOf((float)targetPos.f_82479_));
                this.f_19804_.m_135381_(TARGET_Y, (Object)Float.valueOf((float)targetPos.f_82480_));
                this.f_19804_.m_135381_(TARGET_Z, (Object)Float.valueOf((float)targetPos.f_82481_));
            } else {
                targetPos = new Vec3((double)((Float)this.f_19804_.m_135370_(TARGET_X)).floatValue(), (double)((Float)this.f_19804_.m_135370_(TARGET_Y)).floatValue(), (double)((Float)this.f_19804_.m_135370_(TARGET_Z)).floatValue());
            }
            if (this.f_19797_ % 5 == 0) {
                this.randomFloat = this.f_19796_.m_188501_();
            }
            double dis = this.m_20182_().m_82554_(targetPos);
            double disShooter = shooter.m_20182_().m_82554_(targetPos);
            double randomPos = (double)(Mth.m_14031_((float)(0.25f * ((float)this.f_19797_ + this.randomFloat))) * this.randomFloat) * Mth.m_14008_((double)Mth.m_14031_((float)((float)(3.1415927410125732 * (dis / disShooter)))), (double)0.0, (double)0.8);
            Vec3 toVec = this.m_20182_().m_82505_(targetPos).m_82541_().m_82549_(new Vec3(randomPos, 0.1 * randomPos, randomPos));
            this.m_20256_(this.m_20184_().m_82549_(toVec.m_82490_(0.5)));
            this.m_20256_(this.m_20184_().m_82542_(0.85, 0.85, 0.85));
            if (dis < 0.5) {
                if (this.m_9236_() instanceof ServerLevel) {
                    this.causeMissileExplode(ModDamageTypes.causeCustomExplosionDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.explosionDamage, this.explosionRadius);
                }
                this.m_146870_();
            }
        }
        if (this.f_19797_ > 300 || this.m_20069_() || ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() <= 0.0f) {
            if (this.m_9236_() instanceof ServerLevel) {
                this.causeMissileExplode(ModDamageTypes.causeCustomExplosionDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.explosionDamage, this.explosionRadius);
            }
            this.m_146870_();
        }
    }

    protected void m_37283_() {
    }

    public void causeMissileExplode(@Nullable DamageSource source, float damage, float radius) {
        new CustomExplosion.Builder((Entity)this).damageSource(source).damage(damage).radius(radius).damageMultiplier(1.25f).withParticleType(ParticleTool.ParticleType.MEDIUM).explode();
        this.m_146870_();
    }

    private PlayState movementPredicate(AnimationState<SwarmDroneEntity> event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.sd.fly"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public boolean shouldSyncMotion() {
        return true;
    }

    @Override
    @NotNull
    public SoundEvent getCloseSound() {
        return (SoundEvent)ModSounds.DRONE_SOUND.get();
    }

    @Override
    public float getVolume() {
        return 0.6f;
    }

    @Override
    public void setDamage(float damage) {
    }

    @Override
    public void setExplosionDamage(float explosionDamage) {
        this.explosionDamage = explosionDamage;
    }

    @Override
    public void setExplosionRadius(float radius) {
        this.explosionRadius = radius;
    }

    public float m_7139_() {
        return this.f_19797_ > 10 ? 0.0f : this.gravity;
    }

    @Override
    public void setGravity(float gravity) {
        this.gravity = gravity;
    }
}

