/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.datagen;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.advancement.criteria.OttoSprintTrigger;
import com.atsuishio.superbwarfare.advancement.criteria.RPGMeleeExplosionTrigger;
import com.atsuishio.superbwarfare.datagen.ModAdvancement;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModTags;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class ModAdvancementProvider
implements DataProvider {
    private final PackOutput packOutput;
    private final ExistingFileHelper existingFileHelper;
    public static final List<ModAdvancement> ADVANCEMENTS = new ArrayList<ModAdvancement>();
    public static ModAdvancement START = null;
    public static ModAdvancement MAIN_ROOT = ModAdvancementProvider.advancement("root", builder -> builder.icon((ItemLike)ModItems.TASER.get()).type(ModAdvancement.Type.SILENT).awardedForFree().rewardLootTable(Mod.loc("grant_manual")));
    public static ModAdvancement BEST_FRIEND = ModAdvancementProvider.advancement("best_friend", builder -> builder.icon((ItemLike)ModItems.CLAYMORE_MINE.get()).whenIconCollected().type(ModAdvancement.Type.SECRET).parent(MAIN_ROOT));
    public static ModAdvancement BANZAI = ModAdvancementProvider.advancement("banzai", builder -> builder.icon((ItemLike)ModItems.LUNGE_MINE.get()).whenIconCollected().parent(MAIN_ROOT));
    public static ModAdvancement HAMMER = ModAdvancementProvider.advancement("hammer", builder -> builder.icon((ItemLike)ModItems.HAMMER.get()).whenItemCollected(ModTags.Items.HAMMER).parent(MAIN_ROOT));
    public static ModAdvancement PHYSICS_EXCALIBUR = ModAdvancementProvider.advancement("physics_excalibur", builder -> builder.icon((ItemLike)ModItems.CROWBAR.get()).whenIconCollected().parent(MAIN_ROOT));
    public static ModAdvancement CLEAN_ENERGY = ModAdvancementProvider.advancement("clean_energy", builder -> builder.icon((ItemLike)ModItems.CHARGING_STATION.get()).whenIconCollected().parent(PHYSICS_EXCALIBUR));
    public static ModAdvancement SUPER_CONTAINER = ModAdvancementProvider.advancement("super_container", builder -> builder.icon((ItemLike)ModItems.CONTAINER.get()).whenIconCollected().parent(CLEAN_ENERGY));
    public static ModAdvancement BLUEPRINT = ModAdvancementProvider.advancement("blueprint", builder -> builder.icon((ItemLike)ModItems.TRACHELIUM_BLUEPRINT.get()).whenItemCollected(ModTags.Items.BLUEPRINT).parent(MAIN_ROOT));
    public static ModAdvancement COMMON_BLUEPRINT = ModAdvancementProvider.advancement("common_blueprint", builder -> builder.icon((ItemLike)ModItems.TRACHELIUM_BLUEPRINT.get()).whenItemCollected(ModTags.Items.COMMON_BLUEPRINT).parent(BLUEPRINT));
    public static ModAdvancement RARE_BLUEPRINT = ModAdvancementProvider.advancement("rare_blueprint", builder -> builder.icon((ItemLike)ModItems.TRACHELIUM_BLUEPRINT.get()).whenItemCollected(ModTags.Items.RARE_BLUEPRINT).parent(COMMON_BLUEPRINT));
    public static ModAdvancement EPIC_BLUEPRINT = ModAdvancementProvider.advancement("epic_blueprint", builder -> builder.icon((ItemLike)ModItems.TRACHELIUM_BLUEPRINT.get()).whenItemCollected(ModTags.Items.EPIC_BLUEPRINT).parent(RARE_BLUEPRINT));
    public static ModAdvancement LEGENDARY_BLUEPRINT = ModAdvancementProvider.advancement("legendary_blueprint", builder -> builder.icon((ItemLike)ModItems.TRACHELIUM_BLUEPRINT.get()).whenItemCollected(ModTags.Items.LEGENDARY_BLUEPRINT).parent(EPIC_BLUEPRINT));
    public static ModAdvancement CANNON_BLUEPRINT = ModAdvancementProvider.advancement("cannon_blueprint", builder -> builder.icon((ItemLike)ModItems.MK_42_BLUEPRINT.get()).whenItemCollected(ModTags.Items.CANNON_BLUEPRINT).parent(BLUEPRINT));
    public static ModAdvancement ANCIENT_TECHNOLOGY = ModAdvancementProvider.advancement("ancient_technology", builder -> builder.icon((ItemLike)ModItems.ANCIENT_CPU.get()).whenIconCollected().type(ModAdvancement.Type.GOAL).parent(MAIN_ROOT));
    public static ModAdvancement ENCLAVE = ModAdvancementProvider.advancement("enclave", builder -> builder.icon((ItemLike)ModItems.REFORGING_TABLE.get()).whenIconCollected().type(ModAdvancement.Type.GOAL).parent(ANCIENT_TECHNOLOGY));
    public static ModAdvancement HANDSOME_FRAME = ModAdvancementProvider.advancement("handsome_frame", builder -> builder.icon((ItemLike)ModItems.INTELLIGENT_CHIP.get()).whenIconCollected().type(ModAdvancement.Type.GOAL).parent(ENCLAVE));
    public static ModAdvancement BOOMSTICK_MELEE = ModAdvancementProvider.advancement("boomstick_melee", builder -> builder.icon((ItemLike)ModItems.RPG_ROCKET_TBG.get()).externalTrigger((CriterionTriggerInstance)RPGMeleeExplosionTrigger.TriggerInstance.get()).type(ModAdvancement.Type.SECRET_CHALLENGE).parent(MAIN_ROOT));
    public static ModAdvancement RUSH_RUSH_RUN = ModAdvancementProvider.advancement("rush_rush_run", builder -> builder.icon((ItemLike)ModItems.ELECTRIC_BATON.get()).externalTrigger((CriterionTriggerInstance)OttoSprintTrigger.TriggerInstance.get()).type(ModAdvancement.Type.SECRET_CHALLENGE).parent(MAIN_ROOT));
    public static ModAdvancement END = null;

    public ModAdvancementProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        this.packOutput = output;
        this.existingFileHelper = existingFileHelper;
    }

    private static ModAdvancement advancement(String id, UnaryOperator<ModAdvancement.Builder> b) {
        return new ModAdvancement(id, b);
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput pOutput) {
        ArrayList futures = new ArrayList();
        PackOutput.PathProvider pathProvider = this.packOutput.m_245269_(PackOutput.Target.DATA_PACK, "advancements");
        Consumer<Advancement> mainConsumer = advancement -> {
            ResourceLocation id = advancement.m_138327_();
            if (this.existingFileHelper.exists(id, PackType.SERVER_DATA, ".json", "advancements")) {
                throw new IllegalStateException("Duplicate advancement " + id);
            }
            Path path = pathProvider.m_245731_(id);
            futures.add(DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)advancement.m_138313_().m_138400_(), (Path)path));
        };
        for (ModAdvancement advancement2 : ADVANCEMENTS) {
            advancement2.save(mainConsumer);
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    @NotNull
    public String m_6055_() {
        return "Superb Warfare Advancements";
    }
}

