/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.datagen;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.datagen.ModAdvancementProvider;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EffectsChangedTrigger;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ModAdvancement {
    public static final ResourceLocation MAIN_BACKGROUND = Mod.loc("textures/block/sandbag.png");
    public static final ResourceLocation LEGENDARY_BACKGROUND = Mod.loc("textures/block/steel_block.png");
    private final Advancement.Builder builder = Advancement.Builder.m_138353_();
    private ModAdvancement parent;
    public Advancement result;
    private final String id;
    private final Group group;

    public ModAdvancement(String id, UnaryOperator<Builder> b) {
        this.id = id;
        Builder builtInBuilder = new Builder();
        b.apply(builtInBuilder);
        this.group = builtInBuilder.group;
        ResourceLocation bg = null;
        if (id.equals("root")) {
            if (this.group == Group.MAIN) {
                bg = MAIN_BACKGROUND;
            }
            if (this.group == Group.LEGENDARY) {
                bg = LEGENDARY_BACKGROUND;
            }
        }
        this.builder.m_138362_(builtInBuilder.icon, this.titleComponent(), (Component)Component.m_237115_((String)this.description()), bg, builtInBuilder.type.frame, builtInBuilder.type.toast, builtInBuilder.type.announce, builtInBuilder.type.hide);
        ModAdvancementProvider.ADVANCEMENTS.add(this);
    }

    private String title() {
        return "superbwarfare.advancement." + this.group.path + "." + this.id;
    }

    private Component titleComponent() {
        if (this.group == Group.LEGENDARY && !this.id.equals("root")) {
            return Component.m_237115_((String)this.title()).m_130940_(ChatFormatting.GOLD);
        }
        return Component.m_237115_((String)this.title());
    }

    private String description() {
        return this.title() + ".des";
    }

    public void save(Consumer<Advancement> t) {
        if (this.parent != null) {
            this.builder.m_138398_(this.parent.result);
        }
        this.result = this.builder.m_138389_(t, Mod.loc(this.group.path + "/" + this.id).toString());
    }

    public class Builder {
        private Type type = Type.DEFAULT;
        private int keyIndex;
        private ItemStack icon;
        private Group group = Group.MAIN;

        Builder type(Type type) {
            this.type = type;
            return this;
        }

        Builder parent(ModAdvancement other) {
            ModAdvancement.this.parent = other;
            return this;
        }

        Builder icon(ItemLike item) {
            return this.icon(new ItemStack(item));
        }

        Builder icon(ItemStack stack) {
            this.icon = stack;
            return this;
        }

        Builder whenBlockPlaced(Block block) {
            return this.externalTrigger((CriterionTriggerInstance)ItemUsedOnLocationTrigger.TriggerInstance.m_286031_((Block)block));
        }

        Builder whenIconCollected() {
            return this.externalTrigger((CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{this.icon.m_41720_()}));
        }

        Builder whenItemCollected(ItemLike itemProvider) {
            return this.externalTrigger((CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{itemProvider}));
        }

        Builder whenItemCollected(TagKey<Item> tag) {
            return this.externalTrigger((CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{new ItemPredicate(tag, null, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, EnchantmentPredicate.f_30465_, EnchantmentPredicate.f_30465_, null, NbtPredicate.f_57471_)}));
        }

        Builder whenItemConsumed(ItemLike itemProvider) {
            return this.externalTrigger((CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)itemProvider));
        }

        Builder whenIconConsumed() {
            return this.externalTrigger((CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)this.icon.m_41720_()));
        }

        Builder awardedForFree() {
            return this.externalTrigger((CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_272050_());
        }

        Builder whenEffectChanged(MobEffectsPredicate predicate) {
            return this.externalTrigger((CriterionTriggerInstance)EffectsChangedTrigger.TriggerInstance.m_26780_((MobEffectsPredicate)predicate));
        }

        Builder externalTrigger(CriterionTriggerInstance trigger) {
            ModAdvancement.this.builder.m_138386_(String.valueOf(this.keyIndex), trigger);
            ++this.keyIndex;
            return this;
        }

        Builder requirement(RequirementsStrategy strategy) {
            ModAdvancement.this.builder.m_138360_(strategy);
            return this;
        }

        Builder group(Group group) {
            this.group = group;
            return this;
        }

        Builder rewardExp(int exp) {
            ModAdvancement.this.builder.m_138356_(AdvancementRewards.Builder.m_10005_((int)exp).m_10004_());
            return this;
        }

        Builder rewardLootTable(ResourceLocation location) {
            ModAdvancement.this.builder.m_138356_(AdvancementRewards.Builder.m_144822_((ResourceLocation)location).m_10004_());
            return this;
        }
    }

    static enum Group {
        MAIN("main"),
        LEGENDARY("legendary");

        public final String path;

        private Group(String path) {
            this.path = path;
        }
    }

    static enum Type {
        DEFAULT(FrameType.TASK, true, true, false),
        DEFAULT_NO_ANNOUNCE(FrameType.TASK, true, false, false),
        DEFAULT_CHALLENGE(FrameType.CHALLENGE, true, true, false),
        SILENT(FrameType.TASK, false, false, false),
        GOAL(FrameType.GOAL, true, true, false),
        SECRET(FrameType.TASK, true, true, true),
        SECRET_CHALLENGE(FrameType.CHALLENGE, true, true, true);

        private final FrameType frame;
        private final boolean toast;
        private final boolean announce;
        private final boolean hide;

        private Type(FrameType frame, boolean toast, boolean announce, boolean hide) {
            this.frame = frame;
            this.toast = toast;
            this.announce = announce;
            this.hide = hide;
        }
    }
}

