/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.DataLoader;
import com.atsuishio.superbwarfare.data.DefaultDataSupplier;
import com.atsuishio.superbwarfare.data.Prop;
import com.atsuishio.superbwarfare.data.PropertyModifier;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringPropModifier<DATA extends DefaultDataSupplier<DEFAULT_DATA>, DEFAULT_DATA>
implements PropertyModifier<DATA, DEFAULT_DATA> {
    private final Map<Prop<DATA, DEFAULT_DATA, ?>, Prop.PropModifyContext<DATA, DEFAULT_DATA, ?>> modifiers = new HashMap();
    private Pair<String, JsonObject> propertyOverrideCache = new Pair((Object)"", null);
    private boolean isOverrideValid = true;
    private static final Gson GSON = DataLoader.GSON;

    @Override
    @NotNull
    public Map<Prop<DATA, DEFAULT_DATA, ?>, Prop.PropModifyContext<DATA, DEFAULT_DATA, ?>> getPropModifiers() {
        return this.modifiers;
    }

    public <T> void modifyPropertyByString(@Nullable String string, Prop<DATA, DEFAULT_DATA, T> prop) {
        if (string != null && !string.isEmpty()) {
            JsonObject propJson;
            if (!((String)this.propertyOverrideCache.getFirst()).equals(string)) {
                this.modifiers.clear();
                try {
                    this.propertyOverrideCache = new Pair((Object)string, (Object)((JsonObject)GSON.fromJson(string, JsonObject.class)));
                    this.isOverrideValid = true;
                }
                catch (Exception exception) {
                    Mod.LOGGER.error("invalid property override string {}", (Object)string);
                    this.propertyOverrideCache = new Pair((Object)string, (Object)new JsonObject());
                    this.isOverrideValid = false;
                }
            }
            if ((propJson = (JsonObject)this.propertyOverrideCache.getSecond()) != null && propJson.has(prop.name) && this.isOverrideValid && !this.modifiers.containsKey(prop)) {
                try {
                    Object parsedValue = DataLoader.processValue(GSON.fromJson(propJson.get(prop.name).toString(), prop.getFieldType()));
                    this.setProperty(prop, (DATA data, T value) -> parsedValue);
                }
                catch (Exception exception) {
                    Mod.LOGGER.error("invalid property override type for prop {}: {}", (Object)prop.name, (Object)propJson.get(prop.name).toString());
                    this.isOverrideValid = false;
                }
            }
        } else {
            this.modifiers.clear();
        }
    }
}

