/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data;

import com.atsuishio.superbwarfare.data.DefaultDataSupplier;
import com.atsuishio.superbwarfare.data.Prop;
import com.atsuishio.superbwarfare.data.PropModifier;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PropertyModifier<DATA extends DefaultDataSupplier<DEFAULT_DATA>, DEFAULT_DATA> {
    @NotNull
    public <P extends Prop<DATA, DEFAULT_DATA, ?>> Map<P, Prop.PropModifyContext<DATA, DEFAULT_DATA, ?>> getPropModifiers();

    @Nullable
    default public <T, P extends Prop<DATA, DEFAULT_DATA, T>> Prop.PropModifyContext<DATA, DEFAULT_DATA, T> getModifier(P prop) {
        return this.getPropModifiers().get(prop);
    }

    default public <T, P extends Prop<DATA, DEFAULT_DATA, T>> void setProperty(P prop, @Nullable Function<T, T> modifier) {
        if (modifier == null) {
            return;
        }
        this.setProperty(prop, (PropModifier<DATA, ?, T> pm, DATA data, T value) -> modifier.apply(value));
    }

    default public <T, P extends Prop<DATA, DEFAULT_DATA, T>> void setProperty(P prop, @Nullable BiFunction<DATA, T, T> modifier) {
        if (modifier == null) {
            return;
        }
        this.getPropModifiers().put(prop, (pm, data, value) -> modifier.apply(data, value));
    }

    default public <T, P extends Prop<DATA, DEFAULT_DATA, T>> void setProperty(P prop, @Nullable Prop.PropModifyContext<DATA, DEFAULT_DATA, T> modifier) {
        if (modifier == null) {
            return;
        }
        this.getPropModifiers().put(prop, (pm, data, value) -> modifier.apply(pm, data, value));
    }

    default public <T, P extends Prop<DATA, DEFAULT_DATA, T>> void appendModification(P prop, @Nullable Function<T, T> modifier) {
        if (modifier == null) {
            return;
        }
        this.appendModification(prop, (PropModifier<DATA, ?, T> pm, DATA data, T value) -> modifier.apply(value));
    }

    default public <T, P extends Prop<DATA, DEFAULT_DATA, T>> void appendModification(P prop, @Nullable BiFunction<DATA, T, T> modifier) {
        if (modifier == null) {
            return;
        }
        this.appendModification(prop, (PropModifier<DATA, ?, T> pm, DATA data, T value) -> modifier.apply(data, value));
    }

    default public <T, P extends Prop<DATA, DEFAULT_DATA, T>> void appendModification(P prop, @Nullable Prop.PropModifyContext<DATA, DEFAULT_DATA, T> modifier) {
        if (modifier == null) {
            return;
        }
        Map<P, Prop.PropModifyContext<DATA, DEFAULT_DATA, ?>> modifiers = this.getPropModifiers();
        Prop.PropModifyContext current = modifiers.get(prop);
        if (current == null) {
            this.setProperty(prop, modifier);
        } else {
            modifiers.put(prop, (pm, data, v) -> {
                Object value = current.apply(pm, data, v);
                return modifier.apply(pm, data, value);
            });
        }
    }
}

