/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.tooltip;

import com.atsuishio.superbwarfare.client.tooltip.ClientGunImageTooltip;
import com.atsuishio.superbwarfare.client.tooltip.component.GunImageComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class ClientEnergyImageTooltip
extends ClientGunImageTooltip {
    public ClientEnergyImageTooltip(GunImageComponent tooltip) {
        super(tooltip);
    }

    @Override
    public void m_183452_(@NotNull Font font, int x, int y, GuiGraphics guiGraphics) {
        guiGraphics.m_280168_().m_85836_();
        this.renderDamageAndRpmTooltip(font, guiGraphics, x, y);
        this.renderLevelAndUpgradePointTooltip(font, guiGraphics, x, y + 10);
        int yo = 20;
        if (this.shouldRenderBypassAndHeadshotTooltip()) {
            this.renderBypassAndHeadshotTooltip(font, guiGraphics, x, y + yo);
            yo += 10;
        }
        if (this.shouldRenderEnergyTooltip()) {
            this.renderEnergyTooltip(font, guiGraphics, x, y + (yo += 10));
            yo += 10;
        }
        if (this.shouldRenderEditTooltip()) {
            this.renderWeaponEditTooltip(font, guiGraphics, x, y + yo);
            yo += 20;
        }
        if (this.shouldRenderPerks()) {
            if (!Screen.m_96638_()) {
                this.renderPerksShortcut(font, guiGraphics, x, y + yo);
            } else {
                this.renderPerks(font, guiGraphics, x, y + yo);
            }
        }
        guiGraphics.m_280168_().m_85849_();
    }

    protected boolean shouldRenderEnergyTooltip() {
        return this.stack.getCapability(ForgeCapabilities.ENERGY).isPresent() && this.stack.getCapability(ForgeCapabilities.ENERGY).resolve().isPresent();
    }

    protected void renderEnergyTooltip(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280430_(font, this.getEnergyComponent(), x, y, 0xFFFFFF);
    }

    protected Component getEnergyComponent() {
        int i;
        assert (this.stack.getCapability(ForgeCapabilities.ENERGY).resolve().isPresent());
        IEnergyStorage storage = (IEnergyStorage)this.stack.getCapability(ForgeCapabilities.ENERGY).resolve().get();
        int energy = storage.getEnergyStored();
        int maxEnergy = storage.getMaxEnergyStored();
        float percentage = Mth.m_14036_((float)((float)energy / (float)maxEnergy), (float)0.0f, (float)1.0f);
        MutableComponent component = Component.m_237119_();
        ChatFormatting format = percentage <= 0.2f ? ChatFormatting.RED : (percentage <= 0.6f ? ChatFormatting.YELLOW : ChatFormatting.GREEN);
        int count = (int)(percentage * 50.0f);
        for (i = 0; i < count; ++i) {
            component.m_7220_((Component)Component.m_237113_((String)"|").m_130940_(format));
        }
        component.m_7220_((Component)Component.m_237119_().m_130940_(ChatFormatting.RESET));
        for (i = 0; i < 50 - count; ++i) {
            component.m_7220_((Component)Component.m_237113_((String)"|").m_130940_(ChatFormatting.GRAY));
        }
        component.m_7220_((Component)Component.m_237113_((String)(" " + energy + "/" + maxEnergy + " FE")).m_130940_(ChatFormatting.GRAY));
        return component;
    }

    @Override
    public int m_142103_() {
        int height = super.m_142103_();
        if (this.shouldRenderEnergyTooltip()) {
            height += 20;
        }
        return height;
    }

    @Override
    public int m_142069_(@NotNull Font font) {
        int width = super.m_142069_(font);
        if (this.shouldRenderEnergyTooltip()) {
            width = Math.max(width, font.m_92724_(this.getEnergyComponent().m_7532_()) + 10);
        }
        return width;
    }
}

