/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.particle;

import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class CustomSmokeOption
implements ParticleOptions {
    public static final Codec<CustomSmokeOption> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.fieldOf("r").forGetter(option -> Float.valueOf(option.red)), (App)Codec.FLOAT.fieldOf("g").forGetter(option -> Float.valueOf(option.green)), (App)Codec.FLOAT.fieldOf("b").forGetter(option -> Float.valueOf(option.blue))).apply((Applicative)builder, CustomSmokeOption::new));
    public static final ParticleOptions.Deserializer<CustomSmokeOption> DESERIALIZER = new ParticleOptions.Deserializer<CustomSmokeOption>(){

        public CustomSmokeOption fromCommand(ParticleType<CustomSmokeOption> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            return new CustomSmokeOption(r, g, b);
        }

        public CustomSmokeOption fromNetwork(ParticleType<CustomSmokeOption> particleType, FriendlyByteBuf buffer) {
            return new CustomSmokeOption(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    private final float red;
    private final float green;
    private final float blue;

    public CustomSmokeOption(float r, float g, float b) {
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)ModParticleTypes.CUSTOM_SMOKE.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
    }

    public String m_5942_() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()) + " [" + this.red + ", " + this.green + ", " + this.blue + "]";
    }
}

