/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.config.client.DisplayConfig;
import com.atsuishio.superbwarfare.entity.projectile.MineEntity;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.AircraftEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArtilleryEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.BoatVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.DefenseEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.HelicopterEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@OnlyIn(value=Dist.CLIENT)
public class IFFOverlay
implements IGuiOverlay {
    public static final String ID = "superbwarfare_iff";
    public static final ResourceLocation FRIENDLY_INDICATOR = Mod.loc("textures/screens/teammate/friendly_indicator.png");
    public static final ResourceLocation FRIENDLY_AIRCRAFT = Mod.loc("textures/screens/teammate/friendly_aircraft.png");
    public static final ResourceLocation FRIENDLY_ARMOR = Mod.loc("textures/screens/teammate/friendly_armor.png");
    public static final ResourceLocation FRIENDLY_ARTILLERY = Mod.loc("textures/screens/teammate/friendly_artillery.png");
    public static final ResourceLocation FRIENDLY_BOAT = Mod.loc("textures/screens/teammate/friendly_boat.png");
    public static final ResourceLocation FRIENDLY_DEFENSE = Mod.loc("textures/screens/teammate/friendly_defense.png");
    public static final ResourceLocation FRIENDLY_DRONE = Mod.loc("textures/screens/teammate/friendly_drone.png");
    public static final ResourceLocation FRIENDLY_HELICOPTER = Mod.loc("textures/screens/teammate/friendly_helicopter.png");
    public static final ResourceLocation FRIENDLY_MINE = Mod.loc("textures/screens/teammate/friendly_mine.png");

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        if (!((Boolean)DisplayConfig.VEHICLE_INFO.get()).booleanValue()) {
            return;
        }
        Minecraft mc = gui.getMinecraft();
        LocalPlayer player = mc.f_91074_;
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        if (player == null) {
            return;
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(arg_0 -> IFFOverlay.lambda$render$1((Player)player, cameraPos, partialTick, guiGraphics, screenWidth, screenHeight, arg_0));
    }

    private static ResourceLocation getResourceLocation(Entity team) {
        ResourceLocation icon = FRIENDLY_INDICATOR;
        if (team instanceof BoatVehicleEntity || team instanceof Boat) {
            icon = FRIENDLY_BOAT;
        } else if (team instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)team;
            if (vehicle instanceof AircraftEntity) {
                icon = FRIENDLY_AIRCRAFT;
            }
            if (vehicle instanceof HelicopterEntity) {
                icon = FRIENDLY_HELICOPTER;
            }
            if (vehicle instanceof LandArmorEntity) {
                icon = FRIENDLY_ARMOR;
            }
            if (vehicle instanceof ArtilleryEntity) {
                icon = FRIENDLY_ARTILLERY;
            }
            if (vehicle instanceof DroneEntity) {
                icon = FRIENDLY_DRONE;
            }
            if (vehicle instanceof DefenseEntity) {
                icon = FRIENDLY_DEFENSE;
            }
        } else if (team instanceof MineEntity) {
            icon = FRIENDLY_MINE;
        }
        return icon;
    }

    public static boolean checkNoClip(Player player, Entity teammate, Vec3 pos) {
        return player.m_9236_().m_45547_(new ClipContext(pos, teammate.m_20182_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player)).m_6662_() != HitResult.Type.BLOCK;
    }

    public static double calculateAngle(Entity entityA, Camera camera) {
        Vec3 v1 = camera.m_90583_().m_82505_(entityA.m_20182_());
        Vec3 v2 = new Vec3(camera.m_253058_());
        return VectorTool.calculateAngle(v1, v2);
    }

    private static /* synthetic */ void lambda$render$1(Player player, Vec3 cameraPos, float partialTick, GuiGraphics guiGraphics, int screenWidth, int screenHeight, ICuriosItemHandler c) {
        c.findFirstCurio((Item)ModItems.IFF.get()).ifPresent(s -> {
            List<Entity> entities = SeekTool.getTeammate(player, player.m_9236_());
            for (Entity e : entities) {
                if (e == null || e == player || !VectorUtil.canSee(e.m_20182_()) || e == player.m_20202_()) continue;
                Entity team = e;
                if (e.m_20202_() != null) {
                    team = e.m_20202_();
                }
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                if (IFFOverlay.checkNoClip(player, team, cameraPos)) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
                }
                Vec3 pos = new Vec3(Mth.m_14139_((double)partialTick, (double)team.f_19854_, (double)team.m_20185_()), Mth.m_14139_((double)partialTick, (double)(team.f_19855_ + (double)(team.m_20206_() / 2.0f)), (double)(team.m_20186_() + (double)(team.m_20206_() / 2.0f))), Mth.m_14139_((double)partialTick, (double)team.f_19856_, (double)team.m_20189_()));
                Vec3 point = VectorUtil.worldToScreen(pos);
                float xf = (float)point.f_82479_;
                float yf = (float)point.f_82480_;
                ResourceLocation icon = IFFOverlay.getResourceLocation(team);
                RenderHelper.preciseBlit(guiGraphics, icon, Mth.m_14036_((float)(xf - 6.0f), (float)0.0f, (float)(screenWidth - 12)), Mth.m_14036_((float)(yf - 6.0f), (float)0.0f, (float)(screenHeight - 12)), 0.0f, 0.0f, 12.0f, 12.0f, 12.0f, 12.0f);
            }
        });
    }
}

