/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client;

import com.atsuishio.superbwarfare.data.gun.GunData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.cache.object.GeoBone;

public class ItemModelHelper {
    public static void handleGunAttachments(GeoBone bone, ItemStack stack, String name) {
        CompoundTag tag = GunData.from(stack).attachment();
        ItemModelHelper.splitBoneName(bone, name, "Scope", tag);
        ItemModelHelper.splitBoneName(bone, name, "Magazine", tag);
        ItemModelHelper.splitBoneName(bone, name, "Barrel", tag);
        ItemModelHelper.splitBoneName(bone, name, "Stock", tag);
        ItemModelHelper.splitBoneName(bone, name, "Grip", tag);
        ItemModelHelper.splitBoneName(bone, name, GunData.from((ItemStack)stack).selectedAmmoType.get());
    }

    private static void splitBoneName(GeoBone bone, String boneName, String tagName, CompoundTag tag) {
        try {
            String[] parts;
            if (boneName.startsWith(tagName) && (parts = boneName.split("(?<=\\D)(?=\\d)")).length == 2) {
                int index = Integer.parseInt(parts[1]);
                bone.setHidden(tag.m_128451_(tagName) != index);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static void splitBoneName(GeoBone bone, String boneName, int ammoType) {
        try {
            String[] parts;
            if (boneName.startsWith("AmmoType") && (parts = boneName.split("(?<=\\D)(?=\\d)")).length == 2) {
                int index = Integer.parseInt(parts[1]);
                bone.setHidden(ammoType != index);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static void hideAllAttachments(GeoBone bone, String name) {
        ItemModelHelper.splitAndHideBone(bone, name, "Scope");
        ItemModelHelper.splitAndHideBone(bone, name, "Magazine");
        ItemModelHelper.splitAndHideBone(bone, name, "Barrel");
        ItemModelHelper.splitAndHideBone(bone, name, "Stock");
        ItemModelHelper.splitAndHideBone(bone, name, "Grip");
        ItemModelHelper.splitAndHideBoneAmmoType(bone, name);
    }

    private static void splitAndHideBone(GeoBone bone, String boneName, String tagName) {
        try {
            String[] parts;
            if (boneName.startsWith(tagName) && (parts = boneName.split("(?<=\\D)(?=\\d)")).length == 2) {
                int index = Integer.parseInt(parts[1]);
                bone.setHidden(index != 0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static void splitAndHideBoneAmmoType(GeoBone bone, String boneName) {
        try {
            String[] parts;
            if (boneName.startsWith("AmmoType") && (parts = boneName.split("(?<=\\D)(?=\\d)")).length == 2) {
                int index = Integer.parseInt(parts[1]);
                bone.setHidden(index != 0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

