/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client;

public class AnimationTicker {
    private int tick = 0;
    private int prevTick = 0;
    private int duration;

    public AnimationTicker(int duration) {
        this.duration = duration;
    }

    public void setDuration(int duration) {
        this.tick = 0;
        this.prevTick = 0;
        this.duration = duration;
    }

    public int getTick() {
        return this.tick;
    }

    public boolean isStopped() {
        return this.tick == 0 && this.prevTick == 0;
    }

    public boolean isEnded() {
        return this.tick == this.duration || this.prevTick == this.duration;
    }

    public int getPrevTick() {
        return this.prevTick;
    }

    public int getDuration() {
        return this.duration;
    }

    public void changeTimer(boolean flag) {
        this.changeTimer(flag, 1);
    }

    public void changeTimer(boolean add, int time) {
        if (add) {
            this.increaseTimer(time);
        } else {
            this.decreaseTimer(time);
        }
    }

    public void increaseTimer(int time) {
        int newTime = this.tick + time;
        this.tick = newTime <= this.duration && newTime >= 0 ? newTime : (newTime < 0 ? 0 : this.duration);
    }

    public void decreaseTimer(int time) {
        this.tick = (double)(this.tick - time) > 0.0 ? (this.tick -= time) : 0;
    }

    public void updatePrevTimer() {
        this.prevTick = this.tick;
    }

    public void resetTimer() {
        this.tick = 0;
        this.prevTick = 0;
    }
}

