/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.api.event.RenderPlayerArmEvent;
import com.atsuishio.superbwarfare.client.renderer.ModRenderTypes;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.util.RenderUtils;

public class AnimationHelper {
    public static void renderPartOverBone(ModelPart model, GeoBone bone, PoseStack stack, VertexConsumer buffer, int packedLightIn, int packedOverlayIn, float alpha) {
        AnimationHelper.renderPartOverBone(model, bone, stack, buffer, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, alpha);
    }

    public static void renderPartOverBone(ModelPart model, GeoBone bone, PoseStack stack, VertexConsumer buffer, int packedLightIn, int packedOverlayIn, float r, float g, float b, float a) {
        AnimationHelper.setupModelFromBone(model, bone);
        model.m_104306_(stack, buffer, packedLightIn, packedOverlayIn, r, g, b, a);
    }

    public static void setupModelFromBone(ModelPart model, GeoBone bone) {
        model.m_104227_(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
        model.f_104203_ = 0.0f;
        model.f_104204_ = 0.0f;
        model.f_104205_ = 0.0f;
    }

    public static void renderPartOverBone2(ModelPart model, GeoBone bone, PoseStack stack, VertexConsumer buffer, int packedLightIn, int packedOverlayIn, float alpha) {
        AnimationHelper.renderPartOverBone2(model, bone, stack, buffer, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, alpha);
    }

    public static void renderPartOverBone2(ModelPart model, GeoBone bone, PoseStack stack, VertexConsumer buffer, int packedLightIn, int packedOverlayIn, float r, float g, float b, float a) {
        AnimationHelper.setupModelFromBone2(model, bone);
        model.m_104306_(stack, buffer, packedLightIn, packedOverlayIn, r, g, b, a);
    }

    public static void setupModelFromBone2(ModelPart model, GeoBone bone) {
        model.m_104227_(bone.getPivotX(), bone.getPivotY() + 7.0f, bone.getPivotZ());
        model.f_104203_ = 0.0f;
        model.f_104204_ = (float)Math.PI;
        model.f_104205_ = (float)Math.PI;
    }

    public static void handleShellsAnimation(AnimationProcessor<?> animationProcessor, float x, float y) {
        CoreGeoBone shell1 = animationProcessor.getBone("shell1");
        CoreGeoBone shell2 = animationProcessor.getBone("shell2");
        CoreGeoBone shell3 = animationProcessor.getBone("shell3");
        CoreGeoBone shell4 = animationProcessor.getBone("shell4");
        CoreGeoBone shell5 = animationProcessor.getBone("shell5");
        ClientEventHandler.handleShells(x, y, shell1, shell2, shell3, shell4, shell5);
    }

    public static void handleReloadShakeAnimation(ItemStack stack, CoreGeoBone main, CoreGeoBone camera, float roll, float pitch) {
        if (GunData.from((ItemStack)stack).reload.time() > 0) {
            main.setRotX(roll * main.getRotX());
            main.setRotY(roll * main.getRotY());
            main.setRotZ(roll * main.getRotZ());
            main.setPosX(pitch * main.getPosX());
            main.setPosY(pitch * main.getPosY());
            main.setPosZ(pitch * main.getPosZ());
            camera.setRotX(roll * camera.getRotX());
            camera.setRotY(roll * camera.getRotY());
            camera.setRotZ(roll * camera.getRotZ());
        }
    }

    public static void handleShootFlare(String name, PoseStack stack, ItemStack itemStack, GeoBone bone, MultiBufferSource buffer, int packedLightIn, double x, double y, double z, double size) {
        if (name.equals("flare") && ClientEventHandler.firePosTimer > 0.0 && ClientEventHandler.firePosTimer < 0.5 && GunData.from((ItemStack)itemStack).attachment.get(AttachmentType.BARREL) != 2) {
            bone.setScaleX((float)(size + 0.8 * size * (Math.random() - 0.5)));
            bone.setScaleY((float)(size + 0.8 * size * (Math.random() - 0.5)));
            bone.setRotZ((float)(0.5 * (Math.random() - 0.5)));
            float height = 0.0f;
            if ((GunData.from((ItemStack)itemStack).attachment.get(AttachmentType.SCOPE) == 2 || GunData.from((ItemStack)itemStack).attachment.get(AttachmentType.SCOPE) == 3) && ClientEventHandler.zoom) {
                height = -0.07f;
            }
            stack.m_85836_();
            stack.m_85837_(x, y + 0.02 + (double)height, -z);
            RenderUtils.translateMatrixToBone((PoseStack)stack, (CoreGeoBone)bone);
            RenderUtils.translateToPivotPoint((PoseStack)stack, (CoreGeoBone)bone);
            RenderUtils.rotateMatrixAroundBone((PoseStack)stack, (CoreGeoBone)bone);
            RenderUtils.scaleMatrixForBone((PoseStack)stack, (CoreGeoBone)bone);
            RenderUtils.translateAwayFromPivotPoint((PoseStack)stack, (CoreGeoBone)bone);
            PoseStack.Pose $$6 = stack.m_85850_();
            Matrix4f $$7 = $$6.m_252922_();
            Matrix3f $$8 = $$6.m_252943_();
            VertexConsumer $$9 = buffer.m_6299_(ModRenderTypes.MUZZLE_FLASH_TYPE.apply(Mod.loc("textures/particle/flare.png")));
            AnimationHelper.vertex($$9, $$7, $$8, packedLightIn, 0.0f, 0.0f, 0, 1);
            AnimationHelper.vertex($$9, $$7, $$8, packedLightIn, 1.0f, 0.0f, 1, 1);
            AnimationHelper.vertex($$9, $$7, $$8, packedLightIn, 1.0f, 1.0f, 1, 0);
            AnimationHelper.vertex($$9, $$7, $$8, packedLightIn, 0.0f, 1.0f, 0, 0);
            stack.m_85849_();
        }
    }

    private static void vertex(VertexConsumer pConsumer, Matrix4f pPose, Matrix3f pNormal, int pLightmapUV, float pX, float pY, int pU, int pV) {
        pConsumer.m_252986_(pPose, pX - 0.5f, pY - 0.5f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)pU, (float)pV).m_86008_(OverlayTexture.f_118083_).m_85969_(pLightmapUV).m_252939_(pNormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void handleZoomCrossHair(MultiBufferSource currentBuffer, RenderType renderType, String boneName, PoseStack stack, GeoBone bone, MultiBufferSource buffer, double x, double y, double z, float size, int r, int g, int b, int a, String name, boolean hasBlackPart) {
        if (boneName.equals("cross") && ClientEventHandler.zoomPos > 0.8) {
            stack.m_85836_();
            stack.m_85837_(x, y, -z);
            RenderUtils.translateMatrixToBone((PoseStack)stack, (CoreGeoBone)bone);
            RenderUtils.translateToPivotPoint((PoseStack)stack, (CoreGeoBone)bone);
            RenderUtils.rotateMatrixAroundBone((PoseStack)stack, (CoreGeoBone)bone);
            RenderUtils.scaleMatrixForBone((PoseStack)stack, (CoreGeoBone)bone);
            RenderUtils.translateAwayFromPivotPoint((PoseStack)stack, (CoreGeoBone)bone);
            PoseStack.Pose $$6 = stack.m_85850_();
            Matrix4f $$7 = $$6.m_252922_();
            Matrix3f $$8 = $$6.m_252943_();
            ResourceLocation tex = Mod.loc("textures/crosshair/" + name + ".png");
            int alpha = hasBlackPart ? a : (int)(0.12 * (double)a);
            VertexConsumer blackPart = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)tex));
            AnimationHelper.vertexRGB(blackPart, $$7, $$8, 255, 0.0f, 0.0f, 0, 1, r, g, b, alpha, size);
            AnimationHelper.vertexRGB(blackPart, $$7, $$8, 255, size, 0.0f, 1, 1, r, g, b, alpha, size);
            AnimationHelper.vertexRGB(blackPart, $$7, $$8, 255, size, size, 1, 0, r, g, b, alpha, size);
            AnimationHelper.vertexRGB(blackPart, $$7, $$8, 255, 0.0f, size, 0, 0, r, g, b, alpha, size);
            VertexConsumer $$9 = buffer.m_6299_(ModRenderTypes.MUZZLE_FLASH_TYPE.apply(tex));
            AnimationHelper.vertexRGB($$9, $$7, $$8, 255, 0.0f, 0.0f, 0, 1, r, g, b, a, size);
            AnimationHelper.vertexRGB($$9, $$7, $$8, 255, size, 0.0f, 1, 1, r, g, b, a, size);
            AnimationHelper.vertexRGB($$9, $$7, $$8, 255, size, size, 1, 0, r, g, b, a, size);
            AnimationHelper.vertexRGB($$9, $$7, $$8, 255, 0.0f, size, 0, 0, r, g, b, a, size);
            stack.m_85849_();
        }
        currentBuffer.m_6299_(renderType);
    }

    private static void vertexRGB(VertexConsumer pConsumer, Matrix4f pPose, Matrix3f pNormal, int pLightmapUV, float pX, float pY, int pU, int pV, int r, int g, int b, int a, float size) {
        pConsumer.m_252986_(pPose, pX - 0.5f * size, pY - 0.5f * size, 0.0f).m_6122_(r, g, b, a).m_7421_((float)pU, (float)pV).m_86008_(OverlayTexture.f_118083_).m_85969_(pLightmapUV).m_252939_(pNormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void renderArms(LocalPlayer localPlayer, ItemDisplayContext transformType, PoseStack stack, String name, GeoBone bone, MultiBufferSource currentBuffer, RenderType renderType, int packedLightIn, boolean useOldHandRender) {
        if (transformType != null && transformType.m_269069_()) {
            Minecraft mc = Minecraft.m_91087_();
            if (localPlayer == null) {
                return;
            }
            PlayerRenderer playerRenderer = (PlayerRenderer)mc.m_91290_().m_114382_((Entity)localPlayer);
            PlayerModel model = (PlayerModel)playerRenderer.m_7200_();
            stack.m_85836_();
            RenderUtils.translateMatrixToBone((PoseStack)stack, (CoreGeoBone)bone);
            RenderUtils.translateToPivotPoint((PoseStack)stack, (CoreGeoBone)bone);
            RenderUtils.rotateMatrixAroundBone((PoseStack)stack, (CoreGeoBone)bone);
            RenderUtils.scaleMatrixForBone((PoseStack)stack, (CoreGeoBone)bone);
            RenderUtils.translateAwayFromPivotPoint((PoseStack)stack, (CoreGeoBone)bone);
            HumanoidArm arm = "Lefthand".equals(name) ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
            RenderPlayerArmEvent renderPlayerArmEvent = new RenderPlayerArmEvent(localPlayer, transformType, stack, arm, bone, currentBuffer, renderType, packedLightIn, useOldHandRender);
            if (MinecraftForge.EVENT_BUS.post((Event)renderPlayerArmEvent)) {
                currentBuffer.m_6299_(renderType);
                stack.m_85849_();
                return;
            }
            ResourceLocation loc = localPlayer.m_108560_();
            VertexConsumer armBuilder = currentBuffer.m_6299_(RenderType.m_110446_((ResourceLocation)loc));
            VertexConsumer sleeveBuilder = currentBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            if (arm == HumanoidArm.LEFT) {
                if (!model.f_102812_.f_104207_) {
                    model.f_102812_.f_104207_ = true;
                }
                if (!model.f_103374_.f_104207_ && mc.f_91066_.m_168416_(PlayerModelPart.LEFT_SLEEVE)) {
                    model.f_103374_.f_104207_ = true;
                }
                stack.m_252880_(-0.0625f, 0.125f, 0.0f);
                if (useOldHandRender) {
                    AnimationHelper.renderPartOverBone(model.f_102812_, bone, stack, armBuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f);
                    AnimationHelper.renderPartOverBone(model.f_103374_, bone, stack, sleeveBuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f);
                } else {
                    AnimationHelper.renderPartOverBone2(model.f_102812_, bone, stack, armBuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f);
                    AnimationHelper.renderPartOverBone2(model.f_103374_, bone, stack, sleeveBuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f);
                }
            } else {
                if (!model.f_102811_.f_104207_) {
                    model.f_102811_.f_104207_ = true;
                }
                if (!model.f_103375_.f_104207_ && mc.f_91066_.m_168416_(PlayerModelPart.RIGHT_SLEEVE)) {
                    model.f_103375_.f_104207_ = true;
                }
                stack.m_252880_(0.0625f, 0.125f, 0.0f);
                if (useOldHandRender) {
                    AnimationHelper.renderPartOverBone(model.f_102811_, bone, stack, armBuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f);
                    AnimationHelper.renderPartOverBone(model.f_103375_, bone, stack, sleeveBuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f);
                } else {
                    AnimationHelper.renderPartOverBone2(model.f_102811_, bone, stack, armBuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f);
                    AnimationHelper.renderPartOverBone2(model.f_103375_, bone, stack, sleeveBuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f);
                }
            }
            currentBuffer.m_6299_(renderType);
            stack.m_85849_();
        }
    }
}

