/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block.entity;

import com.atsuishio.superbwarfare.block.FuMO25Block;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.menu.FuMO25Menu;
import com.atsuishio.superbwarfare.network.dataslot.ContainerEnergyData;
import com.atsuishio.superbwarfare.tools.SeekTool;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.network.SerializableDataTicket;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FuMO25BlockEntity
extends BlockEntity
implements MenuProvider,
GeoBlockEntity {
    public static SerializableDataTicket<Integer> FUMO25_TICK;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final int MAX_ENERGY = 1000000;
    public static final int DEFAULT_RANGE = 96;
    public static final int MAX_RANGE = 128;
    public static final int GLOW_RANGE = 64;
    public static final int DEFAULT_ENERGY_COST = 256;
    public static final int MAX_ENERGY_COST = 1024;
    public static final int DEFAULT_MIN_ENERGY = 64000;
    public static final int MAX_DATA_COUNT = 5;
    private LazyOptional<EnergyStorage> energyHandler;
    public FuncType type = FuncType.NORMAL;
    public int time = 0;
    public boolean powered = false;
    public int tick = 0;
    public float yRot0 = 0.0f;
    protected final ContainerEnergyData dataAccess = new ContainerEnergyData(){

        @Override
        public long get(int pIndex) {
            return switch (pIndex) {
                case 0 -> FuMO25BlockEntity.this.energyHandler.map(EnergyStorage::getEnergyStored).orElse(0).intValue();
                case 1 -> FuMO25BlockEntity.this.type.ordinal();
                case 2 -> FuMO25BlockEntity.this.time;
                case 3 -> {
                    if (FuMO25BlockEntity.this.powered) {
                        yield 1L;
                    }
                    yield 0L;
                }
                case 4 -> FuMO25BlockEntity.this.tick;
                default -> 0L;
            };
        }

        @Override
        public void set(int pIndex, long pValue) {
            switch (pIndex) {
                case 0: {
                    FuMO25BlockEntity.this.energyHandler.ifPresent(handler -> handler.receiveEnergy((int)pValue, false));
                    break;
                }
                case 1: {
                    FuMO25BlockEntity.this.type = FuncType.values()[(int)pValue];
                    break;
                }
                case 2: {
                    FuMO25BlockEntity.this.time = (int)pValue;
                    break;
                }
                case 3: {
                    FuMO25BlockEntity.this.powered = pValue == 1L;
                    break;
                }
                case 4: {
                    FuMO25BlockEntity.this.tick = (int)pValue;
                }
            }
        }

        @Override
        public int getCount() {
            return 5;
        }
    };

    public FuMO25BlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.FUMO_25.get(), pPos, pBlockState);
        this.energyHandler = LazyOptional.of(() -> new EnergyStorage(1000000));
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, FuMO25BlockEntity blockEntity) {
        FuncType funcType;
        int energyCost;
        int energy = blockEntity.energyHandler.map(EnergyStorage::getEnergyStored).orElse(0);
        if (((Boolean)pState.m_61143_((Property)FuMO25Block.POWERED)).booleanValue()) {
            ++blockEntity.tick;
            blockEntity.setAnimData(FUMO25_TICK, blockEntity.tick);
        }
        if (energy < (energyCost = (funcType = blockEntity.type) == FuncType.WIDER ? 1024 : 256)) {
            if (((Boolean)pState.m_61143_((Property)FuMO25Block.POWERED)).booleanValue()) {
                pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)FuMO25Block.POWERED, (Comparable)Boolean.valueOf(false)));
                pLevel.m_5594_(null, pPos, (SoundEvent)ModSounds.RADAR_SEARCH_END.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                blockEntity.powered = false;
                FuMO25BlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            }
            if (blockEntity.time > 0) {
                blockEntity.time = 0;
                blockEntity.m_6596_();
            }
        } else if (!((Boolean)pState.m_61143_((Property)FuMO25Block.POWERED)).booleanValue()) {
            if (energy >= 64000) {
                pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)FuMO25Block.POWERED, (Comparable)Boolean.valueOf(true)));
                pLevel.m_5594_(null, pPos, (SoundEvent)ModSounds.RADAR_SEARCH_START.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                blockEntity.powered = true;
                FuMO25BlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            }
        } else {
            blockEntity.energyHandler.ifPresent(handler -> handler.extractEnergy(energyCost, false));
            if (blockEntity.tick == 200) {
                pLevel.m_5594_(null, pPos, (SoundEvent)ModSounds.RADAR_SEARCH_IDLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (blockEntity.time > 0) {
                if (blockEntity.time % 100 == 0) {
                    blockEntity.setGlowEffect();
                }
                --blockEntity.time;
                blockEntity.m_6596_();
            }
        }
        if (blockEntity.tick >= 200) {
            blockEntity.tick = 0;
        }
        if (blockEntity.time <= 0 && blockEntity.type != FuncType.NORMAL) {
            blockEntity.type = FuncType.NORMAL;
            blockEntity.m_6596_();
        }
    }

    private void setGlowEffect() {
        if (this.type != FuncType.GLOW) {
            return;
        }
        Level level = this.f_58857_;
        if (level == null) {
            return;
        }
        BlockPos pos = this.m_58899_();
        List<Entity> entities = SeekTool.getEntitiesWithinRange(pos, level, 64.0);
        entities.forEach(e -> {
            if (e instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)e;
                living.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 100, 0, true, false));
            }
        });
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("Energy")) {
            this.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> ((EnergyStorage)handler).deserializeNBT(pTag.m_128423_("Energy")));
        }
        this.type = FuncType.values()[Mth.m_14045_((int)pTag.m_128451_("Type"), (int)0, (int)3)];
        this.time = pTag.m_128451_("Time");
        this.powered = pTag.m_128471_("Powered");
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        this.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> pTag.m_128365_("Energy", ((EnergyStorage)handler).serializeNBT()));
        pTag.m_128405_("Type", this.type.ordinal());
        pTag.m_128405_("Time", this.time);
        pTag.m_128379_("Powered", this.powered);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237119_();
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        if (this.f_58857_ == null) {
            return null;
        }
        return new FuMO25Menu(pContainerId, pPlayerInventory, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.m_58899_()), this.dataAccess);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.energyHandler = LazyOptional.of(() -> new EnergyStorage(1000000));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum FuncType {
        NORMAL,
        WIDER,
        GLOW,
        GUIDE;

    }
}

