/*
 * Decompiled with CFR 0.152.
 */
package com.example.SoundOfRain;

import com.example.SoundOfRain.SoundOfRainConfig;
import com.example.SoundOfRain.SoundOverrideHandler;
import com.example.SoundOfRain.SoundRegistry;
import com.example.SoundOfRain.ThunderSoundHandler;
import com.example.SoundOfRain.materialsound.MaterialRainSoundHandler;
import com.example.SoundOfRain.materialsound.MaterialRainSoundRegister;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="soundofrain")
public class SoundOfRainMod {
    public static final String MOD_ID = "soundofrain";
    private static final Logger LOGGER = LogManager.getLogger();
    private MaterialRainSoundHandler materialRainSoundHandler;
    private ThunderSoundHandler thunderSoundHandler;
    private SoundOverrideHandler soundOverrideHandler;

    public SoundOfRainMod() {
        LOGGER.info("Initializing Sound of Rain mod");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::loadComplete);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::onConfigLoad);
        SoundRegistry.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SoundOfRainConfig.CLIENT_SPEC);
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Sound of Rain: common setup complete");
    }

    private void clientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Sound of Rain client setup complete");
        MaterialRainSoundHandler.initSoundCache();
        this.setupSoundHandlers();
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        LOGGER.info("Sound of Rain mod load complete");
        MaterialRainSoundRegister.loadMappingsFromConfig();
    }

    private void onConfigLoad(ModConfigEvent.Loading event) {
        String currentVersion;
        if (event.getConfig().getType() == ModConfig.Type.CLIENT && !"0.5.0".equals(currentVersion = (String)SoundOfRainConfig.CLIENT.configVersion.get())) {
            SoundOfRainConfig.CLIENT.soundRadius.set((Object)15);
            SoundOfRainConfig.CLIENT.soundInterval.set((Object)2);
            SoundOfRainConfig.CLIENT.maxSoundsPerCycle.set((Object)2);
            SoundOfRainConfig.CLIENT.configVersion.set((Object)"0.5.0");
            event.getConfig().save();
            LOGGER.info("Config reset to defaults for version 0.5.0");
        }
    }

    private void setupSoundHandlers() {
        this.thunderSoundHandler = new ThunderSoundHandler();
        this.materialRainSoundHandler = new MaterialRainSoundHandler();
        MinecraftForge.EVENT_BUS.register((Object)this.materialRainSoundHandler);
        this.soundOverrideHandler = new SoundOverrideHandler(this.thunderSoundHandler);
        MinecraftForge.EVENT_BUS.register((Object)this.soundOverrideHandler);
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && mc.f_91074_ != null && this.thunderSoundHandler != null) {
            this.thunderSoundHandler.tick(mc.f_91073_.m_46467_());
        }
    }

    private void shutdown() {
        LOGGER.info("Sound of Rain is evaporating...");
        if (this.materialRainSoundHandler != null) {
            this.materialRainSoundHandler.shutdown();
        }
    }
}

