/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.soul_fire_d.api.client;

import it.crystalnest.soul_fire_d.Constants;
import it.crystalnest.soul_fire_d.api.Fire;
import it.crystalnest.soul_fire_d.api.FireManager;
import it.crystalnest.soul_fire_d.api.client.FireClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class FireClientManager {
    private static final ConcurrentHashMap<ResourceLocation, FireClient> FIRES = new ConcurrentHashMap();

    private FireClientManager() {
    }

    @Nullable
    private static synchronized FireClient registerFire(FireClient fire) {
        if (FIRES.putIfAbsent(fire.getFireType(), fire) != null) {
            ResourceLocation fireType = fire.getFireType();
            Constants.LOGGER.error("FireClient [{}] was already registered with the following value: {}", (Object)fireType, (Object)FIRES.get(fireType));
            return null;
        }
        return fire;
    }

    @Nullable
    public static synchronized FireClient registerFire(Fire fire) {
        return FireClientManager.registerFire(new FireClient(fire.getFireType()));
    }

    public static synchronized Map<ResourceLocation, @Nullable FireClient> registerFires(List<Fire> fires) {
        HashMap<ResourceLocation, @Nullable FireClient> outcomes = new HashMap<ResourceLocation, FireClient>();
        for (Fire fire : fires) {
            outcomes.put(fire.getFireType(), FireClientManager.registerFire(fire));
        }
        return outcomes;
    }

    public static synchronized Map<ResourceLocation, @Nullable FireClient> registerFires(Fire ... fires) {
        return FireClientManager.registerFires(List.of(fires));
    }

    @Nullable
    @ApiStatus.Internal
    public static synchronized FireClient unregisterFire(ResourceLocation fireType) {
        return FIRES.remove(fireType);
    }

    public static Material getMaterial0(ResourceLocation fireType) {
        if (FireManager.isRegisteredType(fireType) && FIRES.containsKey(fireType)) {
            return FIRES.get(fireType).getMaterial0();
        }
        return ModelBakery.f_119219_;
    }

    public static Material getMaterial1(ResourceLocation fireType) {
        if (FireManager.isRegisteredType(fireType) && FIRES.containsKey(fireType)) {
            return FIRES.get(fireType).getMaterial1();
        }
        return ModelBakery.f_119220_;
    }

    public static TextureAtlasSprite getSprite0(ResourceLocation fireType) {
        if (FireManager.isRegisteredType(fireType) && FIRES.containsKey(fireType)) {
            return FIRES.get(fireType).getSprite0();
        }
        return ModelBakery.f_119219_.m_119204_();
    }

    public static TextureAtlasSprite getSprite1(ResourceLocation fireType) {
        if (FireManager.isRegisteredType(fireType) && FIRES.containsKey(fireType)) {
            return FIRES.get(fireType).getSprite1();
        }
        return ModelBakery.f_119220_.m_119204_();
    }
}

