/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.soul_fire_d.api;

import com.google.common.collect.ImmutableMap;
import it.crystalnest.soul_fire_d.api.FireManager;
import it.crystalnest.soul_fire_d.api.enchantment.FireAspectBuilder;
import it.crystalnest.soul_fire_d.api.enchantment.FireEnchantmentBuilder;
import it.crystalnest.soul_fire_d.api.enchantment.FlameBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.enchantment.ArrowFireEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.FireAspectEnchantment;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Fire {
    private final ResourceLocation fireType;
    private final int light;
    private final float damage;
    private final boolean invertHealAndHarm;
    private final boolean canRainDouse;
    private final Function<Entity, DamageSource> inFireGetter;
    private final Function<Entity, DamageSource> onFireGetter;
    private final Predicate<Entity> behavior;
    private final ImmutableMap<Component<?, ?>, ResourceLocation> components;

    Fire(ResourceLocation fireType, int light, float damage, boolean invertHealAndHarm, boolean canRainDouse, Function<Entity, DamageSource> inFireGetter, Function<Entity, DamageSource> onFireGetter, Predicate<Entity> behavior, Map<Component<?, ?>, ResourceLocation> components) {
        this.fireType = fireType;
        this.light = light;
        this.damage = damage;
        this.invertHealAndHarm = invertHealAndHarm;
        this.canRainDouse = canRainDouse;
        this.inFireGetter = inFireGetter;
        this.onFireGetter = onFireGetter;
        this.behavior = behavior;
        this.components = ImmutableMap.copyOf(components);
    }

    public ResourceLocation getFireType() {
        return this.fireType;
    }

    public int getLight() {
        return this.light;
    }

    public float getDamage() {
        return this.damage;
    }

    public boolean invertHealAndHarm() {
        return this.invertHealAndHarm;
    }

    public boolean canRainDouse() {
        return this.canRainDouse;
    }

    public DamageSource getInFire(Entity entity) {
        return this.inFireGetter.apply(entity);
    }

    public DamageSource getOnFire(Entity entity) {
        return this.onFireGetter.apply(entity);
    }

    public Predicate<Entity> getBehavior() {
        return this.behavior;
    }

    @Nullable
    public ResourceLocation getComponent(Component<?, ?> component) {
        return (ResourceLocation)this.components.get(component);
    }

    public String toString() {
        return "Fire{fireType=" + String.valueOf(this.fireType) + ", light=" + this.light + ", damage=" + this.damage + ", invertHealAndHarm=" + this.invertHealAndHarm + ", canRainDouse=" + this.canRainDouse + ", components=" + String.valueOf(this.components) + "}";
    }

    public static final class Builder {
        public static final int DEFAULT_LIGHT = 15;
        public static final float DEFAULT_DAMAGE = 1.0f;
        public static final boolean DEFAULT_INVERT_HEAL_AND_HARM = false;
        public static final boolean DEFAULT_CAN_RAIN_DOUSE = false;
        public static final Function<Entity, DamageSource> DEFAULT_IN_FIRE_GETTER = entity -> entity.m_269291_().m_269387_();
        public static final Function<Entity, DamageSource> DEFAULT_ON_FIRE_GETTER = entity -> entity.m_269291_().m_269549_();
        public static final Predicate<Entity> DEFAULT_BEHAVIOR = entity -> true;
        private String modId;
        private String fireId;
        private int light;
        private float damage;
        private boolean invertHealAndHarm;
        private boolean canRainDouse;
        private Function<Entity, DamageSource> inFireGetter;
        private Function<Entity, DamageSource> onFireGetter;
        private Predicate<Entity> behavior;
        private Map<Component<?, ?>, ResourceLocation> components;
        @Nullable
        private Optional<UnaryOperator<FireAspectBuilder>> fireAspectConfigurator;
        @Nullable
        private Optional<UnaryOperator<FlameBuilder>> flameConfigurator;

        Builder(String modId, String fireId) {
            this.reset(modId, fireId);
        }

        Builder(ResourceLocation fireType) {
            this.reset(fireType);
        }

        @Nullable
        private static <T> T get(@Nullable Optional<T> optional) {
            return optional != null && optional.isPresent() ? (T)optional.get() : null;
        }

        private static <B extends FireEnchantmentBuilder<E>, E extends Enchantment> ResourceLocation register(ResourceLocation fireType, @Nullable Optional<UnaryOperator<B>> optional, Function<ResourceLocation, B> builder) {
            UnaryOperator<B> configurator = Builder.get(optional);
            if (configurator != null) {
                return ((FireEnchantmentBuilder)configurator.apply((FireEnchantmentBuilder)builder.apply(fireType))).register();
            }
            return null;
        }

        public Builder setLight(int light) {
            if (light >= 0 && light <= 15) {
                this.light = light;
            }
            return this;
        }

        public Builder setDamage(float damage) {
            this.damage = damage;
            return this;
        }

        public Builder setInvertHealAndHarm(boolean invertHealAndHarm) {
            this.invertHealAndHarm = invertHealAndHarm;
            return this;
        }

        public Builder setCanRainDouse(boolean canRainDouse) {
            this.canRainDouse = canRainDouse;
            return this;
        }

        public Builder setInFire(Function<Entity, DamageSource> getter) {
            this.inFireGetter = getter;
            return this;
        }

        public Builder setOnFire(Function<Entity, DamageSource> getter) {
            this.onFireGetter = getter;
            return this;
        }

        public Builder setBehavior(@NotNull Predicate<Entity> behavior) {
            this.behavior = behavior;
            return this;
        }

        public Builder setBehavior(@NotNull Consumer<Entity> behavior) {
            this.behavior = entity -> {
                behavior.accept((Entity)entity);
                return true;
            };
            return this;
        }

        public Builder setComponent(Component<?, ?> component, ResourceLocation id) {
            this.components.put(component, id);
            return this;
        }

        public Builder removeComponent(Component<?, ?> component) {
            this.components.remove(component);
            return this;
        }

        public Builder setFireAspectConfig(UnaryOperator<FireAspectBuilder> fireAspectConfigurator) {
            this.fireAspectConfigurator = Optional.of(fireAspectConfigurator);
            return this;
        }

        public Builder removeFireAspect() {
            this.fireAspectConfigurator = null;
            return this;
        }

        public Builder setFlameConfig(UnaryOperator<FlameBuilder> flameConfigurator) {
            this.flameConfigurator = Optional.of(flameConfigurator);
            return this;
        }

        public Builder removeFlame() {
            this.flameConfigurator = null;
            return this;
        }

        public Builder reset(ResourceLocation fireType) {
            return this.reset(fireType.m_135827_(), fireType.m_135815_());
        }

        public Builder reset(String modId, String fireId) {
            this.modId = modId;
            return this.reset(fireId);
        }

        public Builder reset(String fireId) {
            this.fireId = fireId;
            this.light = 15;
            this.damage = 1.0f;
            this.invertHealAndHarm = false;
            this.canRainDouse = false;
            this.inFireGetter = DEFAULT_IN_FIRE_GETTER;
            this.onFireGetter = DEFAULT_ON_FIRE_GETTER;
            this.behavior = DEFAULT_BEHAVIOR;
            this.components = new HashMap(Map.ofEntries(Component.SOURCE_BLOCK.getEntry(this.modId, fireId), Component.CAMPFIRE_BLOCK.getEntry(this.modId, fireId), Component.CAMPFIRE_ITEM.getEntry(this.modId, fireId), Component.LANTERN_BLOCK.getEntry(this.modId, fireId), Component.LANTERN_ITEM.getEntry(this.modId, fireId), Component.TORCH_BLOCK.getEntry(this.modId, fireId), Component.TORCH_ITEM.getEntry(this.modId, fireId), Component.WALL_TORCH_BLOCK.getEntry(this.modId, fireId), Component.FLAME_PARTICLE.getEntry(this.modId, fireId)));
            this.fireAspectConfigurator = Optional.empty();
            this.flameConfigurator = Optional.empty();
            return this;
        }

        public Fire build() throws IllegalStateException {
            if (FireManager.isValidFireId(this.fireId) && FireManager.isValidModId(this.modId)) {
                ResourceLocation fireType = FireManager.sanitize(this.modId, this.fireId);
                if (this.fireAspectConfigurator != null) {
                    if (this.fireAspectConfigurator.isEmpty()) {
                        this.fireAspectConfigurator = Optional.of(builder -> builder);
                    }
                    this.components.put(Component.FIRE_ASPECT_ENCHANTMENT, Builder.register(fireType, this.fireAspectConfigurator, FireAspectBuilder::new));
                }
                if (this.flameConfigurator != null) {
                    if (this.flameConfigurator.isEmpty()) {
                        this.flameConfigurator = Optional.of(builder -> builder);
                    }
                    this.components.put(Component.FLAME_ENCHANTMENT, Builder.register(fireType, this.flameConfigurator, FlameBuilder::new));
                }
                return new Fire(fireType, this.light, this.damage, this.invertHealAndHarm, this.canRainDouse, this.inFireGetter, this.onFireGetter, this.behavior, this.components);
            }
            throw new IllegalStateException("Attempted to build a Fire with a non-valid fireId [" + this.fireId + "] or modId [" + this.modId + "].");
        }
    }

    public static final class Component<R, T extends R> {
        public static final Component<Block, Block> SOURCE_BLOCK = new Component(Registries.f_256747_, "_fire");
        public static final Component<Block, Block> CAMPFIRE_BLOCK = new Component(Registries.f_256747_, "_campfire");
        public static final Component<Item, BlockItem> CAMPFIRE_ITEM = new Component(Registries.f_256913_, "_campfire");
        public static final Component<Block, Block> LANTERN_BLOCK = new Component(Registries.f_256747_, "_lantern");
        public static final Component<Item, BlockItem> LANTERN_ITEM = new Component(Registries.f_256913_, "_lantern");
        public static final Component<Block, Block> TORCH_BLOCK = new Component(Registries.f_256747_, "_torch");
        public static final Component<Item, StandingAndWallBlockItem> TORCH_ITEM = new Component(Registries.f_256913_, "_torch");
        public static final Component<Block, Block> WALL_TORCH_BLOCK = new Component(Registries.f_256747_, "_wall_torch");
        public static final Component<ParticleType<?>, ParticleType<?>> FLAME_PARTICLE = new Component(Registries.f_256890_, "_flame");
        public static final Component<Enchantment, FireAspectEnchantment> FIRE_ASPECT_ENCHANTMENT = new Component(Registries.f_256762_, "_fire_aspect");
        public static final Component<Enchantment, ArrowFireEnchantment> FLAME_ENCHANTMENT = new Component(Registries.f_256762_, "_flame");
        private final ResourceKey<? extends Registry<R>> key;
        private final String suffix;

        private Component(ResourceKey<? extends Registry<R>> key, String suffix) {
            this.key = key;
            this.suffix = suffix;
        }

        @NotNull
        Registry<R> getRegistry() {
            return (Registry)BuiltInRegistries.f_257047_.m_7745_(this.key.m_135782_());
        }

        @Nullable
        T getValue(ResourceLocation id) {
            return (T)this.getRegistry().m_7745_(id);
        }

        @Nullable
        T getValue(Fire fire) {
            return this.getValue(fire.getComponent(this));
        }

        Optional<T> getOptionalValue(ResourceLocation id) {
            return this.getRegistry().m_6612_(id);
        }

        Optional<T> getOptionalValue(Fire fire) {
            return this.getOptionalValue(fire.getComponent(this));
        }

        Map.Entry<Component<R, T>, ResourceLocation> getEntry(String modId, String fireId) {
            return Map.entry(this, new ResourceLocation(modId, fireId + this.suffix));
        }
    }
}

