/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public enum AlchemyCondition implements StringRepresentable
{
    NEVER(le -> false),
    ALWAYS(le -> true),
    UNDER_WATER(Entity::m_5842_),
    ON_FIRE(Entity::m_6060_),
    FALLING(le -> le.f_19789_ > 2.0f),
    MINING(le -> {
        if (!(le instanceof ServerPlayer)) return false;
        ServerPlayer serverPlayer = (ServerPlayer)le;
        if (!serverPlayer.f_8941_.f_9249_) return false;
        return true;
    }),
    SPRINTING(Entity::m_20142_),
    HURT((le, v) -> le.m_21223_() > 0.0f && le.m_21223_() < le.m_21233_() && le.m_21223_() / le.m_21233_() < v.floatValue(), 0.75f),
    NEGATIVE_EFFECT((le, v) -> le.m_21220_().stream().anyMatch(effect -> effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL));

    private final BiPredicate<LivingEntity, Float> predicate;
    private final float defaultValue;
    private static final Map<String, AlchemyCondition> NAME_VALUES;
    private static final AlchemyCondition[] VALUES;

    private AlchemyCondition(BiPredicate<LivingEntity, Float> predicate) {
        this(predicate, -1.0f);
    }

    private AlchemyCondition(BiPredicate<LivingEntity, Float> predicate, float defaultValue) {
        this.predicate = predicate;
        this.defaultValue = defaultValue;
    }

    private AlchemyCondition(Predicate<LivingEntity> predicate) {
        this.predicate = (le, v) -> predicate.test((LivingEntity)le);
        this.defaultValue = -1.0f;
    }

    public boolean test(LivingEntity livingEntity, float value) {
        return this.predicate.test(livingEntity, Float.valueOf(value));
    }

    public String m_7912_() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public AlchemyCondition next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    public static AlchemyCondition fromName(String name) {
        return NAME_VALUES.getOrDefault(name, NEVER);
    }

    public float defaultValue() {
        return this.defaultValue;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (AlchemyCondition value : AlchemyCondition.values()) {
            builder.put((Object)value.m_7912_(), (Object)value);
        }
        NAME_VALUES = builder.build();
        VALUES = AlchemyCondition.values();
    }
}

