/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import someassemblyrequired.ingredient.IngredientProperties;
import someassemblyrequired.ingredient.IngredientPropertiesManager;

public class IngredientSyncPacket {
    private final Map<Item, IngredientProperties> ingredients;

    public IngredientSyncPacket(Map<Item, IngredientProperties> ingredients) {
        this.ingredients = ingredients;
    }

    public IngredientSyncPacket(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        this.ingredients = new HashMap<Item, IngredientProperties>(size);
        for (int i = 0; i < size; ++i) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(buffer.m_130281_());
            IngredientProperties ingredient = IngredientProperties.fromNetwork(buffer);
            this.ingredients.put(item, ingredient);
        }
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.ingredients.size());
        this.ingredients.forEach((item, ingredient) -> {
            buffer.m_130085_(ForgeRegistries.ITEMS.getKey(item));
            ingredient.toNetwork(buffer);
        });
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> IngredientPropertiesManager.syncIngredientProperties(this.ingredients));
        context.get().setPacketHandled(true);
    }
}

