/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.item.sandwich.SandwichItemHandler;
import someassemblyrequired.registry.ModLootFunctions;

public class SetIngredientsFunction
extends LootItemConditionalFunction {
    private final List<LootPoolEntryContainer> entries;

    protected SetIngredientsFunction(LootItemCondition[] conditions, List<LootPoolEntryContainer> entries) {
        super(conditions);
        this.entries = entries;
    }

    protected ItemStack m_7372_(ItemStack item, LootContext context) {
        NonNullList ingredients = NonNullList.m_122779_();
        this.entries.forEach(entry -> entry.m_6562_(context, lootPoolEntry -> lootPoolEntry.m_6941_(this.splitStacks(arg_0 -> ingredients.add(arg_0)), context)));
        for (ItemStack ingredient : ingredients) {
            if (!ingredient.m_41619_() && ingredient.m_41613_() == 1) continue;
            SomeAssemblyRequired.LOGGER.warn("Tried to generate sandwich with invalid ingredient '{}', ingredients must have a stack size of 1", (Object)ingredient.toString());
            return ItemStack.f_41583_;
        }
        SandwichItemHandler.get((ICapabilityProvider)item).ifPresent(sandwich -> sandwich.setItems((List<ItemStack>)ingredients));
        return item;
    }

    private Consumer<ItemStack> splitStacks(Consumer<ItemStack> consumer) {
        return stack -> {
            if (stack.m_41613_() == 1) {
                consumer.accept((ItemStack)stack);
            } else if (stack.m_41613_() != 0) {
                int count = stack.m_41613_();
                stack.m_41764_(1);
                for (int i = 0; i < count; ++i) {
                    consumer.accept(stack.m_41777_());
                }
            }
        };
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)ModLootFunctions.SET_INGREDIENTS.get();
    }

    public static Builder setIngredients() {
        return new Builder();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final List<LootPoolEntryContainer> entries = Lists.newArrayList();

        protected Builder getThis() {
            return this;
        }

        public Builder withEntry(LootPoolEntryContainer.Builder<?> entry) {
            this.entries.add(entry.m_7512_());
            return this;
        }

        public LootItemFunction m_7453_() {
            return new SetIngredientsFunction(this.m_80699_(), this.entries);
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SetIngredientsFunction> {
        public void serialize(JsonObject object, SetIngredientsFunction function, JsonSerializationContext context) {
            super.m_6170_(object, (LootItemConditionalFunction)function, context);
            object.add("entries", context.serialize(function.entries));
        }

        public SetIngredientsFunction deserialize(JsonObject object, JsonDeserializationContext context, LootItemCondition[] conditions) {
            LootPoolEntryContainer[] entries = (LootPoolEntryContainer[])GsonHelper.m_13836_((JsonObject)object, (String)"entries", (JsonDeserializationContext)context, LootPoolEntryContainer[].class);
            return new SetIngredientsFunction(conditions, Arrays.asList(entries));
        }
    }
}

