/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.integration.jei;

import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.advanced.ISimpleRecipeManagerPlugin;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import someassemblyrequired.ingredient.Ingredients;
import someassemblyrequired.integration.ModCompat;
import someassemblyrequired.item.sandwich.SandwichItem;
import someassemblyrequired.item.sandwich.SandwichItemHandler;
import someassemblyrequired.registry.ModItems;
import someassemblyrequired.registry.ModTags;

public abstract class SandwichRecipeGenerator<RECIPE>
implements ISimpleRecipeManagerPlugin<RECIPE> {
    protected abstract int getMaxToppings();

    public boolean isHandledInput(ITypedIngredient<?> input) {
        if (input.getType() == VanillaTypes.ITEM_STACK) {
            ItemStack item = input.getItemStack().orElse(ItemStack.f_41583_);
            return item.m_204117_(ModTags.SANDWICH_BREAD) || this.isHandledFilling(item);
        }
        if (input.getType() == ForgeTypes.FLUID_STACK) {
            return this.isHandledFilling((FluidStack)input.getIngredient((IIngredientType)ForgeTypes.FLUID_STACK).orElseThrow());
        }
        return false;
    }

    protected boolean isHandledFilling(ItemStack filling) {
        return !filling.m_150930_((Item)ModItems.SANDWICH.get()) && !filling.m_204117_(ModTags.SANDWICH_BREAD) && this.getFluidFromFilling(filling).isEmpty() && Ingredients.canAddToSandwich(filling);
    }

    protected boolean isHandledFilling(FluidStack fluid) {
        return this.getFillingFromFluid(fluid).isPresent();
    }

    public boolean isHandledOutput(ITypedIngredient<?> output) {
        if (output.getType() == VanillaTypes.ITEM_STACK) {
            ItemStack stack = output.getItemStack().orElse(ItemStack.f_41583_);
            return stack.m_150930_((Item)ModItems.SANDWICH.get()) && SandwichItemHandler.get((ICapabilityProvider)stack).orElse(new SandwichItemHandler()).getItemCount() >= 2;
        }
        return false;
    }

    public List<RECIPE> getRecipesForInput(ITypedIngredient<?> input) {
        if (input.getType() == ForgeTypes.FLUID_STACK) {
            Optional<ItemStack> filling = this.getFillingFromFluid((FluidStack)input.getIngredient((IIngredientType)ForgeTypes.FLUID_STACK).orElseThrow());
            if (filling.isEmpty()) {
                return List.of();
            }
            return this.getRecipesForFilling(filling.get());
        }
        ItemStack stack = (ItemStack)input.getItemStack().orElseThrow();
        if ((stack = stack.m_255036_(1)).m_204117_(ModTags.SANDWICH_BREAD)) {
            ItemStack bottomBread = stack.m_150930_((Item)ModItems.BURGER_BUN_TOP.get()) ? new ItemStack((ItemLike)ModItems.BURGER_BUN_BOTTOM.get()) : stack;
            ItemStack topBread = stack.m_150930_((Item)ModItems.BURGER_BUN_BOTTOM.get()) ? new ItemStack((ItemLike)ModItems.BURGER_BUN_TOP.get()) : stack;
            return this.getRecipesForBread(bottomBread, topBread);
        }
        return this.getRecipesForFilling(stack);
    }

    protected List<RECIPE> getRecipesForBread(ItemStack bottomBread, ItemStack topBread) {
        ArrayList<RECIPE> recipes = new ArrayList<RECIPE>();
        Consumer<ItemStack> consumer = sandwich -> {
            SandwichItemHandler contents = SandwichItemHandler.get((ICapabilityProvider)sandwich).orElse(new SandwichItemHandler());
            if (contents.bottom().m_150930_(bottomBread.m_41720_()) && contents.top().m_150930_(topBread.m_41720_())) {
                recipes.add(this.getRecipeForSandwich(contents));
            }
        };
        ModCompat.gatherCreativeTabSandwiches(consumer);
        recipes.add(this.createRecipe(bottomBread, new ItemStack((ItemLike)Items.f_42787_), topBread));
        return recipes;
    }

    protected List<RECIPE> getRecipesForFilling(ItemStack filling) {
        ArrayList recipes = new ArrayList();
        BuiltInRegistries.f_257033_.m_203431_(ModTags.SANDWICH_BREAD).ifPresent(tag -> {
            for (Holder holder : tag) {
                if (holder.m_203656_(ModTags.BURGER_BUNS)) continue;
                ItemStack bread = new ItemStack((ItemLike)holder.m_203334_());
                recipes.add(this.createRecipe(bread, filling, bread));
            }
            ItemStack bottom = new ItemStack((ItemLike)ModItems.BURGER_BUN_BOTTOM.get());
            ItemStack top = new ItemStack((ItemLike)ModItems.BURGER_BUN_TOP.get());
            recipes.add(this.createRecipe(bottom, filling, top));
        });
        return recipes;
    }

    protected abstract Optional<ItemStack> getFillingFromFluid(FluidStack var1);

    protected abstract Optional<FluidIngredient> getFluidFromFilling(ItemStack var1);

    protected RECIPE createRecipe(ItemStack bottomBread, ItemStack filling, ItemStack topBread) {
        if (filling.m_41613_() != 1) {
            filling = filling.m_41777_();
            filling.m_41764_(1);
        }
        return this.getRecipeForSandwich(SandwichItemHandler.of(List.of(bottomBread, filling, topBread)));
    }

    public List<RECIPE> getRecipesForOutput(ITypedIngredient<?> output) {
        ItemStack sandwich = output.getItemStack().orElse(ItemStack.f_41583_);
        return List.of(this.getRecipeForSandwich(SandwichItemHandler.get((ICapabilityProvider)sandwich).orElse(new SandwichItemHandler())));
    }

    protected RECIPE getRecipeForSandwich(SandwichItemHandler contents) {
        List<ItemStack> items = contents.getItems();
        ItemStack prefix = items.get(0);
        int size = items.size();
        if (size - 1 > this.getMaxToppings()) {
            prefix = SandwichItem.of(items.subList(0, size - this.getMaxToppings()));
            items = items.subList(size - this.getMaxToppings(), size);
        } else {
            items = items.subList(1, size);
        }
        return this.getRecipeForSandwich(prefix, items, SandwichItem.of(contents.getItems()));
    }

    protected abstract RECIPE getRecipeForSandwich(ItemStack var1, List<ItemStack> var2, ItemStack var3);

    public List<RECIPE> getAllRecipes() {
        ArrayList<RECIPE> recipes = new ArrayList<RECIPE>();
        ModCompat.gatherCreativeTabSandwiches(sandwich -> recipes.add(this.getRecipeForSandwich(SandwichItemHandler.get((ICapabilityProvider)sandwich).orElse(new SandwichItemHandler()))));
        recipes.add(this.getRecipeForSandwich(SandwichItemHandler.get((ICapabilityProvider)SandwichItem.makeToastSandwich(new ItemLike[]{Items.f_42787_})).orElseThrow()));
        return recipes;
    }
}

