/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.data.providers;

import com.sammy.minersdelight.setup.MDItems;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.data.providers.Ingredients;
import someassemblyrequired.registry.ModItems;

public class ItemModels
extends ItemModelProvider {
    public ItemModels(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        super(packOutput, "some_assembly_required", existingFileHelper);
    }

    protected void registerModels() {
        Set<Item> items = ForgeRegistries.ITEMS.getValues().stream().filter(item -> ForgeRegistries.ITEMS.getKey(item).m_135827_().equals("some_assembly_required")).collect(Collectors.toSet());
        ItemModels.removeAll(items, (ItemLike)ModItems.SANDWICH.get());
        this.addSandwich();
        ItemModels.removeAll(items, (ItemLike)ModItems.SPREAD.get());
        ItemModels.removeAll(items, Ingredients.MODEL_OVERRIDES.toArray(new ItemLike[0]));
        this.addSpread();
        ItemModels.removeAll(items, (ItemLike)ModItems.ENCHANTED_GOLDEN_APPLE_SLICES.get());
        this.addGeneratedModel("enchanted_golden_apple_slices", this.prefixItem("golden_apple_slices"));
        ItemModels.removeAll(items, (T item) -> item instanceof BlockItem).forEach(block -> this.withExistingParent(ForgeRegistries.ITEMS.getKey(block).m_135815_(), this.prefixBlock(ForgeRegistries.ITEMS.getKey(block).m_135815_())));
        items.forEach(this::addGeneratedModel);
    }

    private void addSpread() {
        HashMap<Item, ItemModelBuilder> customModels = new HashMap<Item, ItemModelBuilder>();
        this.addCustomIngredientModels(customModels);
        ItemModelBuilder spreadModel = this.addGeneratedModel((Item)ModItems.SPREAD.get());
        for (int i = 0; i < Ingredients.MODEL_OVERRIDES.size(); ++i) {
            Item item = Ingredients.MODEL_OVERRIDES.get(i);
            if ("some_assembly_required".equals(ForgeRegistries.ITEMS.getKey((Object)item).m_135827_())) {
                this.addGeneratedModel(item);
            }
            String path = this.getIngredientPath(item);
            ItemModelBuilder model = customModels.containsKey(item) ? customModels.get(item) : this.addGeneratedModel(path, this.prefixItem(path));
            spreadModel.override().model((ModelFile)model).predicate(new ResourceLocation("custom_model_data"), (float)(i + 1)).end();
        }
    }

    private void addCustomIngredientModels(HashMap<Item, ItemModelBuilder> customModels) {
        this.addBeefPattyModels(customModels);
        String path = this.getIngredientPath(Items.f_42620_);
        ResourceLocation texture = this.prefixItem(path);
        customModels.put(Items.f_42620_, (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).texture("potato", texture)).element().from(5.0f, 0.0f, 4.0f).to(11.0f, 5.0f, 12.0f).face(Direction.NORTH).uvs(0.0f, 11.0f, 6.0f, 16.0f).end().face(Direction.EAST).uvs(8.0f, 0.0f, 16.0f, 5.0f).end().face(Direction.SOUTH).uvs(6.0f, 11.0f, 12.0f, 16.0f).end().face(Direction.WEST).uvs(0.0f, 0.0f, 8.0f, 5.0f).end().face(Direction.UP).uvs(0.0f, 5.0f, 8.0f, 11.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end().face(Direction.DOWN).uvs(8.0f, 5.0f, 16.0f, 11.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).end().faces((direction, builder) -> builder.texture("#potato")).end());
        path = this.getIngredientPath((Item)ModItems.BURGER_BUN.get());
        texture = this.prefixItem(path);
        customModels.put((Item)ModItems.BURGER_BUN.get(), (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).texture("burger_bun", texture)).element().from(2.0f, 0.0f, 2.0f).to(14.0f, 6.0f, 14.0f).face(Direction.NORTH).uvs(6.0f, 12.0f, 12.0f, 15.0f).end().face(Direction.EAST).uvs(0.0f, 12.0f, 6.0f, 15.0f).end().face(Direction.SOUTH).uvs(6.0f, 6.0f, 12.0f, 9.0f).end().face(Direction.WEST).uvs(6.0f, 9.0f, 12.0f, 12.0f).end().face(Direction.UP).uvs(0.0f, 0.0f, 6.0f, 6.0f).end().face(Direction.DOWN).uvs(0.0f, 6.0f, 6.0f, 12.0f).end().faces((direction, builder) -> builder.texture("#burger_bun")).end());
        path = this.getIngredientPath((Item)ModItems.BURGER_BUN_BOTTOM.get());
        customModels.put((Item)ModItems.BURGER_BUN_BOTTOM.get(), (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).texture("burger_bun", texture)).element().from(2.0f, 0.0f, 2.0f).to(14.0f, 2.0f, 14.0f).face(Direction.NORTH).uvs(6.0f, 14.0f, 12.0f, 15.0f).end().face(Direction.EAST).uvs(0.0f, 14.0f, 6.0f, 15.0f).end().face(Direction.SOUTH).uvs(6.0f, 8.0f, 12.0f, 9.0f).end().face(Direction.WEST).uvs(6.0f, 11.0f, 12.0f, 12.0f).end().face(Direction.UP).uvs(6.0f, 0.0f, 12.0f, 6.0f).end().face(Direction.DOWN).uvs(0.0f, 6.0f, 6.0f, 12.0f).end().faces((direction, builder) -> builder.texture("#burger_bun")).end());
        path = this.getIngredientPath((Item)ModItems.BURGER_BUN_TOP.get());
        customModels.put((Item)ModItems.BURGER_BUN_TOP.get(), (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).texture("burger_bun", texture)).element().from(2.0f, 0.0f, 2.0f).to(14.0f, 4.0f, 14.0f).face(Direction.NORTH).uvs(6.0f, 12.0f, 12.0f, 14.0f).end().face(Direction.EAST).uvs(0.0f, 12.0f, 6.0f, 14.0f).end().face(Direction.SOUTH).uvs(6.0f, 6.0f, 12.0f, 8.0f).end().face(Direction.WEST).uvs(6.0f, 9.0f, 12.0f, 11.0f).end().face(Direction.UP).uvs(0.0f, 0.0f, 6.0f, 6.0f).end().face(Direction.DOWN).uvs(6.0f, 0.0f, 12.0f, 6.0f).end().faces((direction, builder) -> builder.texture("#burger_bun")).end());
    }

    private void addBeefPattyModels(HashMap<Item, ItemModelBuilder> customModels) {
        for (Item item : Arrays.asList((Item)vectorwing.farmersdelight.common.registry.ModItems.BEEF_PATTY.get(), (Item)vectorwing.farmersdelight.common.registry.ModItems.MINCED_BEEF.get(), (Item)MDItems.VEGAN_PATTY.get())) {
            String path = this.getIngredientPath(item);
            ResourceLocation texture = this.prefixItem(path);
            customModels.put(item, (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).texture("beef_patty", texture)).element().from(2.0f, 0.0f, 2.0f).to(14.0f, 2.0f, 14.0f).face(Direction.NORTH).uvs(2.0f, 0.0f, 14.0f, 2.0f).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.EAST).uvs(14.0f, 2.0f, 16.0f, 14.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).end().face(Direction.SOUTH).uvs(2.0f, 14.0f, 14.0f, 16.0f).rotation(ModelBuilder.FaceRotation.ZERO).end().face(Direction.WEST).uvs(0.0f, 2.0f, 2.0f, 14.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end().face(Direction.UP).uvs(2.0f, 2.0f, 14.0f, 14.0f).end().face(Direction.DOWN).uvs(2.0f, 2.0f, 14.0f, 14.0f).end().faces((direction, builder) -> builder.texture("#beef_patty")).end());
        }
    }

    private String getIngredientPath(Item item) {
        return "ingredient/" + this.getItemPath(item);
    }

    private String getItemPath(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).toString().replace(':', '/');
    }

    private String getItemName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
    }

    private void addSandwich() {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.getItemName((Item)ModItems.SANDWICH.get()))).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).texture("particle", this.prefixItem("bread_slice"))).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 45.0f, 0.0f).scale(0.8f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 180.0f, 0.0f).scale(0.5f).end().transform(ItemDisplayContext.HEAD).rotation(0.0f, 180.0f, 0.0f).translation(0.0f, 0.5f, 0.0f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 180.0f, 0.0f).translation(0.0f, -4.0f, 0.0f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 315.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.55f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 315.0f, 0.0f).translation(0.0f, 1.0f, 0.0f).scale(0.5f).end().end();
    }

    private ResourceLocation prefixBlock(String path) {
        return SomeAssemblyRequired.id("block/" + path);
    }

    private ResourceLocation prefixItem(String path) {
        return SomeAssemblyRequired.id("item/" + path);
    }

    private ItemModelBuilder addGeneratedModel(Item item) {
        String name = ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("item/" + name, "item/generated")).texture("layer0", this.prefixItem(name));
    }

    private ItemModelBuilder addGeneratedModel(String name, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, "item/generated")).texture("layer0", texture);
    }

    private static void removeAll(Set<Item> set, ItemLike ... items) {
        Set result = Arrays.stream(items).map(ItemLike::m_5456_).collect(Collectors.toSet());
        set.removeAll(result);
    }

    private static <T> Collection<T> removeAll(Set<T> set, Predicate<T> pred) {
        Set result = set.stream().filter(pred).collect(Collectors.toSet());
        set.removeAll(result);
        if (result.size() <= 0) {
            throw new IllegalArgumentException();
        }
        return result;
    }
}

