/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.wreath_stuff.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.common.network.NetworkHandler;
import net.mehvahdjukaar.snowyspirit.reg.ModMemoryModules;
import net.mehvahdjukaar.snowyspirit.wreath_stuff.ai.PlaceWreathTask;
import net.mehvahdjukaar.snowyspirit.wreath_stuff.capabilities.ModCapabilities;
import net.mehvahdjukaar.snowyspirit.wreath_stuff.capabilities.WreathCapability;
import net.mehvahdjukaar.snowyspirit.wreath_stuff.network.ClientBoundSyncWreathMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;

public class RemoveWreathTask
extends Behavior<Villager> {
    private final float speedModifier;
    private int ticksSinceReached = 0;
    private int cooldown = 100;
    protected int lastBreakProgress = -1;

    public RemoveWreathTask(float speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26374_, (Object)MemoryStatus.VALUE_ABSENT, ModMemoryModules.WREATH_POS.get(), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), 270, 350);
        this.speedModifier = speed * 1.1f;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (SnowySpirit.isChristmasSeason((Level)pLevel)) {
            return false;
        }
        if (this.cooldown-- > 0) {
            return false;
        }
        if (!ForgeEventFactory.getMobGriefingEvent((Level)pLevel, (Entity)pOwner)) {
            this.cooldown = 1200;
            return false;
        }
        GlobalPos globalpos = (GlobalPos)pOwner.m_6274_().m_21952_(ModMemoryModules.WREATH_POS.get()).get();
        return globalpos.m_122640_() == pLevel.m_46472_() && !pOwner.m_6162_();
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        this.cooldown = 20 * (5 + pLevel.f_46441_.m_188503_(20)) + pLevel.f_46441_.m_188503_(20);
        this.ticksSinceReached = 0;
        this.lastBreakProgress = -1;
        GlobalPos globalpos = (GlobalPos)pEntity.m_6274_().m_21952_(ModMemoryModules.WREATH_POS.get()).get();
        pEntity.m_6274_().m_21936_(MemoryModuleType.f_26374_);
        pEntity.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(globalpos.m_122646_(), this.speedModifier, 1));
        PlaceWreathTask.displayAsHeldItem(pEntity, new ItemStack((ItemLike)Items.f_42574_));
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.m_6732_(pLevel, (LivingEntity)pEntity, pGameTime);
        PlaceWreathTask.clearHeldItem(pEntity);
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return pEntity.m_6274_().m_21874_(ModMemoryModules.WREATH_POS.get());
    }

    protected void tick(ServerLevel level, Villager pOwner, long pGameTime) {
        BlockPos pos = ((GlobalPos)pOwner.m_6274_().m_21952_(ModMemoryModules.WREATH_POS.get()).get()).m_122646_();
        pOwner.m_6274_().m_21936_(MemoryModuleType.f_26374_);
        pOwner.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(pos, this.speedModifier, 2));
        pOwner.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(pos));
        if (pos.m_203195_((Position)pOwner.m_20182_(), 2.3)) {
            ++this.ticksSinceReached;
            BlockState state = level.m_8055_(pos);
            if (state.m_60734_() instanceof DoorBlock) {
                boolean lower = state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER;
                WreathCapability c = ModCapabilities.get((ICapabilityProvider)level, ModCapabilities.WREATH_CAPABILITY);
                BlockPos blockPos = pos = lower ? pos.m_7494_() : pos;
                if (c != null && c.hasWreath(pos)) {
                    int k = (int)((float)this.ticksSinceReached / 10.0f * 10.0f);
                    if (k != this.lastBreakProgress) {
                        level.m_6801_(pOwner.m_19879_(), pos, k);
                        this.lastBreakProgress = k;
                    }
                    if (this.ticksSinceReached > 10) {
                        pOwner.m_6274_().m_21936_(ModMemoryModules.WREATH_POS.get());
                        c.removeWreath(pos, (Level)level, true);
                        NetworkHandler.CHANNEL.sendToAllClientPlayers((Message)new ClientBoundSyncWreathMessage(pos, false));
                    }
                    return;
                }
            }
            pOwner.m_6274_().m_21936_(ModMemoryModules.WREATH_POS.get());
        }
    }
}

