/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.wreath_stuff;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.mehvahdjukaar.snowyspirit.wreath_stuff.capabilities.ModCapabilities;
import net.mehvahdjukaar.snowyspirit.wreath_stuff.capabilities.WreathCapability;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="snowyspirit", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void tickEvent(TickEvent.ClientTickEvent event) {
        ClientLevel level;
        if (event.phase == TickEvent.Phase.END && (level = Minecraft.m_91087_().f_91073_) != null) {
            level.getCapability(ModCapabilities.WREATH_CAPABILITY).ifPresent(c -> c.refreshClientBlocksVisuals((Level)level));
        }
    }

    @SubscribeEvent
    public static void renderWreaths(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
            Minecraft mc = Minecraft.m_91087_();
            Level level = mc.f_91074_.m_9236_();
            PoseStack poseStack = event.getPoseStack();
            Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
            WreathCapability capability = ModCapabilities.get((ICapabilityProvider)level, ModCapabilities.WREATH_CAPABILITY);
            if (capability != null) {
                float dist = mc.f_91063_.m_109152_();
                dist *= dist;
                poseStack.m_85836_();
                MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
                RenderSystem.enableDepthTest();
                for (Map.Entry<BlockPos, WreathCapability.WreathData> entry : capability.getWreathBlocks().entrySet()) {
                    BlockPos pos = entry.getKey();
                    if (!(mc.f_91074_.m_20238_(Vec3.m_82512_((Vec3i)pos)) < (double)dist)) continue;
                    poseStack.m_85836_();
                    poseStack.m_85837_((double)pos.m_123341_() - cameraPos.m_7096_(), (double)pos.m_123342_() - cameraPos.m_7098_(), (double)pos.m_123343_() - cameraPos.m_7094_());
                    WreathCapability.WreathData data = entry.getValue();
                    Direction dir = data.getDirection();
                    BlockState state = ModRegistry.WREATH.get().m_49966_();
                    BlockRenderDispatcher blockRenderer = mc.m_91289_();
                    poseStack.m_85837_(0.5, 0.5, 0.5);
                    Pair<Float, Float> dim = data.getDimensions();
                    if (dim != null) {
                        poseStack.m_85836_();
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(-dir.m_122435_()));
                        poseStack.m_85837_(-0.5, -0.5, -0.5 + (double)((Float)dim.getSecond()).floatValue());
                        RenderUtil.renderBlock((long)0L, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (BlockState)state, (Level)level, (BlockPos)pos, (BlockRenderDispatcher)blockRenderer);
                        poseStack.m_85849_();
                        poseStack.m_85836_();
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(-dir.m_122424_().m_122435_()));
                        poseStack.m_85837_(-0.5, -0.5, -0.5 + (double)((Float)dim.getFirst()).floatValue());
                        RenderUtil.renderBlock((long)0L, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (BlockState)state, (Level)level, (BlockPos)pos, (BlockRenderDispatcher)blockRenderer);
                        poseStack.m_85849_();
                    }
                    poseStack.m_85849_();
                }
                RenderSystem.disableDepthTest();
                bufferSource.m_109911_();
                poseStack.m_85849_();
            }
        }
    }
}

