/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.entity;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.mehvahdjukaar.snowyspirit.common.block.GumdropButton;
import net.mehvahdjukaar.snowyspirit.common.entity.GingyEntity;
import net.mehvahdjukaar.snowyspirit.common.entity.MongoEntity;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.mehvahdjukaar.snowyspirit.reg.ModTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class GolemHelper {
    public static final Supplier<BlockPattern> MONGO_PATTERN = Suppliers.memoize(() -> BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~~~###~~~", "~~~###~~~", "~~~###~~~", "#########", "#########", "~~~###~~~", "~~~###~~~", "~~~###~~~", "~~~###~~~", "~~~###~~~", "~~~###~~~"}).m_61244_('~', BlockInWorld.m_61169_(BlockBehaviour.BlockStateBase::m_247087_)).m_61244_('#', BlockInWorld.m_61169_(s -> s.m_204336_(ModTags.GINGERBREADS))).m_61249_());

    public static void trySpawningGingy(BlockState pumpkinState, LevelAccessor level, BlockPos pumpkinPos, @Nullable Entity entity) {
        BlockPos below = pumpkinPos.m_7495_();
        if (level instanceof ServerLevel) {
            Direction dir;
            BlockPos button;
            BlockState state;
            Block block;
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.m_8055_(below).m_204336_(ModTags.GINGERBREADS) && (block = (state = level.m_8055_(button = below.m_121945_(dir = (Direction)pumpkinState.m_61143_((Property)CarvedPumpkinBlock.f_51367_)))).m_60734_()) instanceof GumdropButton) {
                GingyEntity golem;
                GumdropButton b = (GumdropButton)block;
                if (state.m_61143_((Property)GumdropButton.f_52588_) == dir && (golem = (GingyEntity)ModRegistry.GINGERBREAD_GOLEM.get().m_20615_((Level)serverLevel)) != null) {
                    level.m_7471_(pumpkinPos, false);
                    level.m_7471_(button, false);
                    level.m_7471_(below, false);
                    golem.m_7678_((double)pumpkinPos.m_123341_() + 0.5, (double)pumpkinPos.m_123342_() + 0.05 - 1.0, (double)pumpkinPos.m_123343_() + 0.5, dir.m_122435_(), 0.0f);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)golem);
                        golem.setOwnerUUID(serverPlayer.m_20148_());
                        golem.m_21530_();
                    }
                    golem.setColor(b.color);
                    golem.m_5616_(dir.m_122435_());
                    level.m_7967_((Entity)golem);
                }
            }
        }
    }

    public static void trySpawningMongo(BlockState buttonState, Level level, BlockPos buttonPos, @Nullable Entity entity) {
        MongoEntity giant;
        BlockPattern.BlockPatternMatch patternMatch;
        BlockPos behind = buttonPos.m_121945_(((Direction)buttonState.m_61143_((Property)GumdropButton.f_52588_)).m_122424_());
        if (level.m_8055_(behind).m_204336_(ModTags.GINGERBREADS) && (patternMatch = MONGO_PATTERN.get().m_61184_((LevelReader)level, behind)) != null && (giant = (MongoEntity)ModRegistry.GINGERBREAD_GIANT.get().m_20615_(level)) != null) {
            giant.setColor(((GumdropButton)buttonState.m_60734_()).color);
            GolemHelper.clearBlocks(level, patternMatch);
            BlockPos bottom = patternMatch.m_61229_(patternMatch.m_155970_() / 2, patternMatch.m_155971_(), 0).m_61176_();
            giant.m_7678_((double)bottom.m_123341_() + 0.5, (double)bottom.m_123342_() + 0.05, (double)bottom.m_123343_() + 0.5, 0.0f, 0.0f);
            level.m_7967_((Entity)giant);
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)giant);
            }
        }
    }

    private static void clearBlocks(Level level, BlockPattern.BlockPatternMatch patternMatch) {
        Direction front = patternMatch.m_61233_();
        for (int i = 0; i < patternMatch.m_155970_(); ++i) {
            for (int j = 0; j < patternMatch.m_155971_(); ++j) {
                BlockInWorld blockInWorld = patternMatch.m_61229_(i, j, 0);
                if (!blockInWorld.m_61168_().m_204336_(ModTags.GINGERBREADS)) continue;
                BlockPos inFront = blockInWorld.m_61176_().m_121945_(front);
                BlockState gum = level.m_8055_(inFront);
                if (gum.m_60734_() instanceof GumdropButton) {
                    level.m_7731_(inFront, Blocks.f_50016_.m_49966_(), 2);
                    level.m_46796_(2001, inFront, Block.m_49956_((BlockState)gum));
                }
                level.m_7731_(blockInWorld.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                level.m_46796_(2001, blockInWorld.m_61176_(), Block.m_49956_((BlockState)blockInWorld.m_61168_()));
            }
        }
    }
}

