/*
 * Decompiled with CFR 0.152.
 */
package mod.swift.snowysniffer.mixin;

import java.util.Objects;
import mod.swift.snowysniffer.interfaces.MaybeSnowy;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Sniffer.class})
public abstract class SnifferEntityMixin
extends Entity
implements MaybeSnowy {
    @Unique
    private static final EntityDataAccessor<Boolean> HAS_SNOW = SynchedEntityData.m_135353_(Sniffer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private static final EntityDataAccessor<Boolean> LOADED_ON_SERVER = SynchedEntityData.m_135353_(Sniffer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    private void init(EntityType<? extends Animal> entityType, Level level, CallbackInfo ci) {
        this.f_19804_.m_135372_(HAS_SNOW, (Object)false);
        this.f_19804_.m_135372_(LOADED_ON_SERVER, (Object)false);
        if (!level.m_5776_()) {
            this.f_19804_.m_135381_(LOADED_ON_SERVER, (Object)true);
        }
    }

    public SnifferEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void tick(CallbackInfo ci) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.f_146808_ && !this.isSnowy()) {
            this.setSnowy(true);
        } else if (this.m_204029_(FluidTags.f_13131_) && this.isSnowy()) {
            this.setSnowy(false);
        }
        if (this.shouldSetHasSnowToTrue()) {
            this.f_19804_.m_135381_(HAS_SNOW, (Object)true);
        } else if (this.shouldRemoveHasSnow()) {
            this.f_19804_.m_135381_(HAS_SNOW, (Object)false);
        }
        if (this.f_19796_.m_188503_(240) == 0 && this.closeToHeat()) {
            this.f_19804_.m_135381_(HAS_SNOW, (Object)false);
        }
    }

    @Unique
    private boolean closeToHeat() {
        int maxCheckDistance = 3;
        for (BlockPos blockPos : BlockPos.m_121976_((int)(this.m_146903_() - maxCheckDistance), (int)(this.m_146904_() - maxCheckDistance), (int)(this.m_146907_() - maxCheckDistance), (int)(this.m_146903_() + maxCheckDistance), (int)(this.m_146904_() + maxCheckDistance), (int)(this.m_146907_() + maxCheckDistance))) {
            BlockState blockState = this.m_9236_().m_8055_(blockPos);
            if (!blockState.m_60819_().m_192917_((Fluid)Fluids.f_76195_) && !blockState.m_60713_(Blocks.f_50683_) && !blockState.m_60713_(Blocks.f_50083_)) continue;
            return true;
        }
        return false;
    }

    @Inject(at={@At(value="HEAD")}, method={"onSyncedDataUpdated"})
    private void updateSnowy(EntityDataAccessor<?> entityDataAccessor, CallbackInfo ci) {
        if (HAS_SNOW.equals(entityDataAccessor) && !this.isSnowy()) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_175821_);
        }
    }

    @Unique
    protected void addParticlesAroundSelf(ParticleOptions particleOptions) {
        for (int i = 0; i < 60; ++i) {
            double d = this.f_19796_.m_188583_() * 0.02;
            double e = this.f_19796_.m_188583_() * 0.02;
            double f = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_(particleOptions, this.m_20208_(0.75), this.m_20187_() + 0.75, this.m_20262_(0.75), d, e, f);
        }
    }

    @Unique
    private boolean isSnowingAt() {
        Level level = this.m_9236_();
        BlockPos blockPos = this.m_20183_();
        if (!level.m_46471_()) {
            return false;
        }
        if (!level.m_45527_(blockPos)) {
            return false;
        }
        if (level.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockPos).m_123342_() > blockPos.m_123342_()) {
            return false;
        }
        Biome biome = (Biome)level.m_204166_(blockPos).m_203334_();
        return biome.m_264600_(blockPos) == Biome.Precipitation.SNOW;
    }

    @Override
    public void setSnowy(boolean snowy) {
        this.f_19804_.m_135381_(HAS_SNOW, (Object)snowy);
    }

    @Override
    public boolean isSnowy() {
        if (((Boolean)this.f_19804_.m_135370_(LOADED_ON_SERVER)).booleanValue()) {
            return (Boolean)this.f_19804_.m_135370_(HAS_SNOW);
        }
        return Objects.equals(this.m_7770_(), Component.m_237113_((String)"Snowy")) || this.isSnowingAt();
    }

    @Unique
    private boolean shouldSetHasSnowToTrue() {
        return this.isSnowingAt() && !this.isSnowy();
    }

    @Unique
    private boolean shouldRemoveHasSnow() {
        return this.isSnowy() && (this.isTooHot() || this.m_9236_().m_46758_(this.m_20183_()));
    }

    @Unique
    private boolean isTooHot() {
        return ((Biome)this.m_9236_().m_204166_(this.m_20183_()).m_203334_()).m_47554_() > 1.0f;
    }
}

