/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcus8448.snowy;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.github.marcus8448.snowy.ForgeSnowyConfig;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="snowy")
public class SnowyForge {
    public static final ForgeSnowyConfig CONFIG = new ForgeSnowyConfig();
    private static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"snowy");
    private static final DeferredRegister<BiomeModifier> BIOME_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (String)"snowy");
    public static final RegistryObject<Codec<? extends BiomeModifier>> BIOME_MODIFIER_CODEC = BIOME_MODIFIER_SERIALIZERS.register("transform", () -> SnowyBiomeModifier.CODEC);

    public SnowyForge() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, SnowyForge.CONFIG.commonSpec);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(CONFIG::onLoad);
        MinecraftForge.EVENT_BUS.addListener(this::serverTick);
        BIOME_MODIFIER_SERIALIZERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        BIOME_MODIFIERS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public void serverTick(TickEvent.LevelTickEvent event) {
        if (event.side == LogicalSide.SERVER && CONFIG.enableConstantSnow() && (CONFIG.enableNonOverworldBiomes() || event.level.m_46472_().equals((Object)Level.f_46428_))) {
            ((ServerLevel)event.level).m_8606_(0, 6000, true, false);
        }
    }

    private static boolean canModify(Holder<Biome> biome) {
        for (String forceEnabledBiome : CONFIG.forceEnabledBiomes()) {
            if (!biome.m_203373_(new ResourceLocation(forceEnabledBiome))) continue;
            return true;
        }
        for (String forceDisabledBiome : CONFIG.forceDisabledBiomes()) {
            if (!biome.m_203373_(new ResourceLocation(forceDisabledBiome))) continue;
            return false;
        }
        return CONFIG.enableNonOverworldBiomes() || biome.m_203656_(BiomeTags.f_215817_);
    }

    private record SnowyBiomeModifier(HolderGetter<PlacedFeature> getter) implements BiomeModifier
    {
        private static final Codec<SnowyBiomeModifier> CODEC = new Codec<SnowyBiomeModifier>(){

            public <T> DataResult<Pair<SnowyBiomeModifier, T>> decode(DynamicOps<T> ops, T input) {
                if (ops instanceof RegistryOps) {
                    RegistryOps registryOps = (RegistryOps)ops;
                    return DataResult.success((Object)new Pair((Object)new SnowyBiomeModifier((HolderGetter<PlacedFeature>)((HolderGetter)registryOps.m_255006_(Registries.f_256988_).get())), input));
                }
                throw new UnsupportedOperationException("Non-registry ops");
            }

            public <T> DataResult<T> encode(SnowyBiomeModifier input, DynamicOps<T> ops, T prefix) {
                return DataResult.success(prefix);
            }
        };

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD) {
                if (SnowyForge.canModify(biome)) {
                    for (Holder feature : builder.getGenerationSettings().getFeatures(GenerationStep.Decoration.TOP_LAYER_MODIFICATION)) {
                        if (!feature.m_203565_(MiscOverworldPlacements.f_195271_)) continue;
                        return;
                    }
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, (Holder)this.getter.m_255043_(MiscOverworldPlacements.f_195271_));
                }
            } else if (phase == BiomeModifier.Phase.MODIFY && SnowyForge.canModify(biome)) {
                builder.getClimateSettings().setHasPrecipitation(true);
                builder.getClimateSettings().setTemperature(0.0f);
                builder.getClimateSettings().setDownfall(0.5f);
                builder.getClimateSettings().setTemperatureModifier(CONFIG.enableTemperatureNoise() ? Biome.TemperatureModifier.FROZEN : Biome.TemperatureModifier.NONE);
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return CODEC;
        }
    }
}

