/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcus8448.snowy;

import io.github.marcus8448.snowy.Constant;
import io.github.marcus8448.snowy.SnowyConfig;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeSnowyConfig
implements SnowyConfig {
    public final Common common;
    public final IConfigSpec<?> commonSpec;

    @SubscribeEvent
    public void onLoad(ModConfigEvent.Loading configEvent) {
        Constant.LOGGER.debug("Successfully loaded Snowy's config file!");
    }

    public ForgeSnowyConfig() {
        Pair configure = new ForgeConfigSpec.Builder().configure(Common::new);
        this.common = (Common)configure.getLeft();
        this.commonSpec = (IConfigSpec)configure.getRight();
    }

    @Override
    public boolean enableNonOverworldBiomes() {
        return (Boolean)this.common.enableNonOverworldBiomes.get();
    }

    @Override
    public List<String> forceDisabledBiomes() {
        return (List)this.common.forceDisabledBiomes.get();
    }

    @Override
    public List<String> forceEnabledBiomes() {
        return (List)this.common.forceEnabledBiomes.get();
    }

    @Override
    public boolean enableTemperatureNoise() {
        return (Boolean)this.common.enableTemperatureNoise.get();
    }

    @Override
    public boolean enableConstantSnow() {
        return (Boolean)this.common.enableConstantSnow.get();
    }

    @Override
    public void enableNonOverworldBiomes(boolean value) {
        this.common.enableNonOverworldBiomes.set((Object)value);
    }

    @Override
    public void forceDisabledBiomes(List<String> list) {
        this.common.forceDisabledBiomes.set(list);
    }

    @Override
    public void forceEnabledBiomes(List<String> list) {
        this.common.forceEnabledBiomes.set(list);
    }

    @Override
    public void enableTemperatureNoise(boolean value) {
        this.common.enableTemperatureNoise.set((Object)value);
    }

    @Override
    public void enableConstantSnow(boolean value) {
        this.common.enableConstantSnow.set((Object)value);
    }

    @Override
    public void save() {
    }

    public static class Common {
        final ForgeConfigSpec.BooleanValue enableNonOverworldBiomes;
        final ForgeConfigSpec.ConfigValue<List<? extends String>> forceDisabledBiomes;
        final ForgeConfigSpec.ConfigValue<List<? extends String>> forceEnabledBiomes;
        final ForgeConfigSpec.BooleanValue enableTemperatureNoise;
        final ForgeConfigSpec.BooleanValue enableConstantSnow;

        Common(@Nonnull ForgeConfigSpec.Builder builder) {
            builder.comment("Snowy config").push("general");
            this.enableNonOverworldBiomes = builder.comment("Enable non-overworld biomes").translation("option.snowy.enable_non_overworld_biomes").worldRestart().define("enable_non_overworld_biomes", false);
            this.forceDisabledBiomes = builder.comment("Force disabled biomes").translation("option.snowy.force_disabled_biomes").worldRestart().defineListAllowEmpty(Collections.singletonList("force_disabled_biomes"), Collections::emptyList, o -> true);
            this.forceEnabledBiomes = builder.comment("Force enabled biomes").translation("option.snowy.force_enabled_biomes").worldRestart().defineListAllowEmpty(Collections.singletonList("force_enabled_biomes"), Collections::emptyList, o -> true);
            this.enableTemperatureNoise = builder.comment("Enable temperature noise").translation("option.snowy.enable_temperature_noise").worldRestart().define("enable_temperature_noise", false);
            this.enableConstantSnow = builder.comment("Enable constant snow").translation("option.snowy.enable_constant_snow").define("enable_constant_snow", true);
            builder.pop();
        }
    }
}

