/*
 * Decompiled with CFR 0.152.
 */
package me.mc.mods.smallbats.vampire.actions;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.actions.VampireActions;
import java.util.Optional;
import me.mc.mods.smallbats.caps.SmallBatsPlayerCapabilityProvider;
import me.mc.mods.smallbats.vampire.SmallBatsVampireActions;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class MistShapeAction
implements ILastingAction<IVampirePlayer> {
    public static final EntityDimensions MIST_DIMENSIONS = EntityDimensions.m_20398_((float)0.25f, (float)0.25f);
    public static final DustColorTransitionOptions PARTICLE_MISTEFFECT = new DustColorTransitionOptions(new Vector3f(0.22f, 0.22f, 0.22f), new Vector3f(0.15f, 0.15f, 0.15f), 2.0f);

    public static boolean isMistShape(Player p) {
        LazyOptional vampirePlayer = VampirismAPI.getVampirePlayer((Player)p);
        if (vampirePlayer.isPresent()) {
            return ((IVampirePlayer)vampirePlayer.resolve().get()).getActionHandler().isActionActive((ILastingAction)SmallBatsVampireActions.MISTFORM.get());
        }
        return false;
    }

    public IAction.PERM canUse(IVampirePlayer player) {
        return player.getActionHandler().isActionActive((ILastingAction)VampireActions.BAT.get()) ? IAction.PERM.DISALLOWED : IAction.PERM.ALLOWED;
    }

    public int getCooldown(IVampirePlayer player) {
        return 20;
    }

    @NotNull
    public Optional<IPlayableFaction<?>> getFaction() {
        return Optional.ofNullable(VReference.VAMPIRE_FACTION);
    }

    public String getTranslationKey() {
        return "action.smallbats.mist";
    }

    public boolean onActivated(IVampirePlayer player, IAction.ActivationContext context) {
        this.updatePlayer(player, true);
        return true;
    }

    public int getDuration(IVampirePlayer player) {
        return Integer.MAX_VALUE;
    }

    public void onActivatedClient(IVampirePlayer player) {
        player.getRepresentingPlayer().m_6210_();
    }

    public void onDeactivated(IVampirePlayer player) {
        if (!player.isRemote()) {
            this.updatePlayer(player, false);
        } else {
            player.getRepresentingPlayer().m_6210_();
        }
    }

    public void onReActivated(IVampirePlayer player) {
    }

    public boolean showHudDuration(Player player) {
        return true;
    }

    public boolean onUpdate(IVampirePlayer player) {
        if (player.isGettingSundamage((LevelAccessor)player.getRepresentingPlayer().m_9236_())) {
            this.updatePlayer(player, false);
            return true;
        }
        return false;
    }

    void updatePlayer(IVampirePlayer p, boolean activated) {
        Player player = p.getRepresentingPlayer();
        LazyOptional cap = player.getCapability(SmallBatsPlayerCapabilityProvider.SMALLBATS_PLAYER_CAP);
        cap.ifPresent(c -> c.setIsMist(activated));
        player.m_150110_().f_35935_ = p.getRepresentingPlayer().m_5833_();
        player.m_150110_().f_35936_ = activated || p.getRepresentingPlayer().m_7500_() || p.getRepresentingPlayer().m_5833_();
        player.m_150110_().f_35938_ = !activated;
        player.setForcedPose((Pose)(activated ? Pose.STANDING : null));
        if (!p.isRemote()) {
            cap.ifPresent(c -> c.sync((Entity)player));
        }
        player.m_6210_();
        player.m_6885_();
    }
}

