/*
 * Decompiled with CFR 0.152.
 */
package me.mc.mods.smallbats.vampire.actions;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import java.util.Optional;
import me.mc.mods.smallbats.util.VerticalCollisionUtil;
import me.mc.mods.smallbats.vampire.SmallBatsVampireActions;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class BatSleepAction
implements ILastingAction<IVampirePlayer>,
IAction<IVampirePlayer> {
    public static boolean isSleepingAsBat(Player p) {
        LazyOptional vampirePlayer = VampirismAPI.getVampirePlayer((Player)p);
        if (vampirePlayer.isPresent()) {
            return ((IVampirePlayer)vampirePlayer.resolve().get()).getActionHandler().isActionActive((ILastingAction)SmallBatsVampireActions.BATSLEEP.get());
        }
        return false;
    }

    public IAction.PERM canUse(IVampirePlayer player) {
        return player.getRepresentingPlayer().m_9236_().m_46461_() && VerticalCollisionUtil.verticalCollisionUp((Entity)player.getRepresentingEntity()) ? IAction.PERM.ALLOWED : IAction.PERM.DISALLOWED;
    }

    public int getCooldown(IVampirePlayer player) {
        return 20;
    }

    @NotNull
    public Optional<IPlayableFaction<?>> getFaction() {
        return Optional.ofNullable(VReference.VAMPIRE_FACTION);
    }

    public String getTranslationKey() {
        return "skill.smallbats.batsleep";
    }

    public boolean onActivated(IVampirePlayer player, IAction.ActivationContext context) {
        boolean isOnCeiling;
        if (VampirismPlayerAttributes.get((Player)player.getRepresentingPlayer()).getVampSpecial().bat && player.getRepresentingPlayer().m_9236_().m_46461_() && (isOnCeiling = VerticalCollisionUtil.verticalCollisionUp((Entity)player.getRepresentingEntity()))) {
            BlockPos pos = player.getRepresentingEntity().m_20183_();
            player.getRepresentingPlayer().m_5802_(pos);
            ((ServerLevel)player.getRepresentingPlayer().m_9236_()).m_8878_();
            return true;
        }
        return false;
    }

    public int getDuration(IVampirePlayer player) {
        return 200;
    }

    public void onActivatedClient(IVampirePlayer player) {
    }

    public void onDeactivated(IVampirePlayer player) {
    }

    public void onReActivated(IVampirePlayer player) {
    }

    public boolean showHudDuration(Player player) {
        return true;
    }

    public boolean onUpdate(IVampirePlayer player) {
        if (!player.getRepresentingPlayer().m_9236_().m_5776_()) {
            return player.getRepresentingPlayer().m_9236_().m_46462_();
        }
        return Screen.m_96638_();
    }
}

