/*
 * Decompiled with CFR 0.152.
 */
package me.mc.mods.smallbats.eventhandler;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import me.mc.mods.smallbats.caps.SmallBatsPlayerCapabilityProvider;
import me.mc.mods.smallbats.vampire.SmallBatsVampireActions;
import me.mc.mods.smallbats.vampire.actions.MistShapeAction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GameEventHandler {
    @SubscribeEvent
    public void onSleepingLocationCheckEvent(SleepingLocationCheckEvent e) {
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            e.setResult(VampirismPlayerAttributes.get((Player)player).getVampSpecial().bat ? Event.Result.ALLOW : Event.Result.DEFAULT);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void sleepTimeFinish(SleepFinishedTimeEvent event) {
        boolean sleepingAsBat;
        if (event.getLevel() instanceof ServerLevel && ((ServerLevel)event.getLevel()).m_46461_() && (sleepingAsBat = event.getLevel().m_6907_().stream().anyMatch(player -> {
            LazyOptional vampPlayer = VampirismAPI.getVampirePlayer((Player)player);
            if (vampPlayer.isPresent()) {
                return ((IVampirePlayer)vampPlayer.resolve().get()).getActionHandler().isActionActive((ILastingAction)SmallBatsVampireActions.BATSLEEP.get());
            }
            return false;
        }))) {
            long dist = ((ServerLevel)event.getLevel()).m_46468_() % 24000L > 12000L ? 13000L : -11000L;
            event.setTimeAddition(event.getNewTime() + dist);
        }
    }

    @SubscribeEvent
    public void onPlayerDamage(LivingDamageEvent e) {
    }

    @SubscribeEvent
    public void onEntityEventSize(EntityEvent.Size e) {
        Entity entity = e.getEntity();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            p.getCapability(SmallBatsPlayerCapabilityProvider.SMALLBATS_PLAYER_CAP).ifPresent(cap -> {
                if (cap.getIsMist()) {
                    e.setNewSize(MistShapeAction.MIST_DIMENSIONS);
                    e.setNewEyeHeight(MistShapeAction.MIST_DIMENSIONS.f_20378_);
                }
            });
        }
    }

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof Player) {
            e.addCapability(SmallBatsPlayerCapabilityProvider.SMALLBATS_PLAYER_CAP_LOC, (ICapabilityProvider)new SmallBatsPlayerCapabilityProvider());
        }
    }
}

