/*
 * Decompiled with CFR 0.152.
 */
package me.mc.mods.smallbats.eventhandler;

import de.teamlapen.vampirism.api.VampirismAPI;
import me.mc.mods.smallbats.util.MathUtils;
import me.mc.mods.smallbats.vampire.actions.MistShapeAction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientGameEventHandler {
    private static void spawnMistParticlesAt(Level l, Vec3 p) {
        Vec3 particlePos = MathUtils.randomSpherePositions(l.m_213780_(), p, 0.5f);
        double x = particlePos.f_82479_;
        double y = particlePos.f_82480_;
        double z = particlePos.f_82481_;
        l.m_7106_((ParticleOptions)MistShapeAction.PARTICLE_MISTEFFECT, x, y, z, 0.0, 0.0, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderLivingEventPre(RenderLivingEvent.Pre<Player, PlayerModel<Player>> e) {
        Player p;
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Player && MistShapeAction.isMistShape(p = (Player)livingEntity)) {
            e.setCanceled(true);
            Level l = e.getEntity().m_9236_();
            if (e.getEntity().m_7306_((Entity)Minecraft.m_91087_().f_91074_)) {
                if (!Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) {
                    ClientGameEventHandler.spawnMistParticlesAt(l, e.getEntity().m_20182_());
                }
            } else {
                ClientGameEventHandler.spawnMistParticlesAt(l, e.getEntity().m_20182_());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderLivingEventPost(RenderLivingEvent.Post<Player, PlayerModel<Player>> e) {
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Player) {
            Player p = (Player)livingEntity;
            VampirismAPI.getVampirePlayer((Player)p).ifPresent(player -> {
                int ticksInSun = player.getTicksInSun();
                if (ticksInSun == 0 || player.isIgnoringSundamage() || p.m_7500_() || p.m_5833_()) {
                    return;
                }
                int fireTicks = Math.max(1, ticksInSun - 600) * 10;
                if (p.m_9236_().m_46467_() % (long)fireTicks == 0L) {
                    RandomSource r = p.m_9236_().m_213780_();
                    double rX = r.m_188500_() * (double)p.m_20205_() * (double)(r.m_188499_() ? 1 : -1) / 2.0;
                    double rY = r.m_188500_() * (double)p.m_20206_();
                    double rZ = r.m_188500_() * (double)p.m_20205_() * (double)(r.m_188499_() ? 1 : -1) / 2.0;
                    double speedFactor = 0.02;
                    e.getEntity().m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175834_, e.getEntity().m_20185_() + rX, e.getEntity().m_20186_() + rY, e.getEntity().m_20189_() + rZ, r.m_188500_() * 0.02 * (double)(r.m_188499_() ? 1 : -1), r.m_188500_() * 0.02, r.m_188500_() * 0.02 * (double)(r.m_188499_() ? 1 : -1));
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onHandRenderEVent(RenderHandEvent e) {
        if (MistShapeAction.isMistShape((Player)Minecraft.m_91087_().f_91074_)) {
            e.setCanceled(true);
        }
    }
}

