/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.api.compat;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.platform.Services;
import java.util.List;

public class CompatibilityInstance {
    public final String name;
    public final String modId;
    public final CompatibilityConfig config;
    public final List<CompatibilityInstance> incompatibleWith;
    public final String compatibleFor;
    public boolean enabled = false;
    public boolean isLoaded = false;
    public boolean fitsVersion = false;

    public CompatibilityInstance(String name, String modId, CompatibilityConfig config, List<CompatibilityInstance> incompatibleWith, String compatibleFor) {
        this.name = name;
        this.modId = modId;
        this.config = config;
        this.incompatibleWith = incompatibleWith;
        this.compatibleFor = compatibleFor;
    }

    public CompatibilityInstance(String name, String modId, CompatibilityConfig config, List<CompatibilityInstance> incompatibleWith) {
        this(name, modId, config, incompatibleWith, null);
    }

    public CompatibilityInstance(String name, String modId, CompatibilityConfig config, String compatibleFor) {
        this(name, modId, config, List.of(), compatibleFor);
    }

    public CompatibilityInstance(String name, String modId, CompatibilityConfig config) {
        this(name, modId, config, List.of(), null);
    }

    public boolean isLoaded() {
        return Services.PLATFORM.isModLoaded(this.modId);
    }

    public void spout() {
        this.enabled = false;
        if (this.isLoaded()) {
            this.isLoaded = true;
            CommonSimpleRadio.info("{} is present!", this.name);
            for (CompatibilityInstance instance : this.incompatibleWith) {
                if (!instance.isLoaded()) continue;
                CommonSimpleRadio.info("..but so is {}?!", instance.name);
                return;
            }
            String version = Services.PLATFORM.getModVersion(this.modId);
            if (this.compatibleFor != null && !Services.PLATFORM.isVersionWithin(version, this.compatibleFor)) {
                CommonSimpleRadio.info("..but it is not a supported version!", new Object[0]);
                this.fitsVersion = false;
                return;
            }
            this.fitsVersion = true;
            if (this.config.isEnabled()) {
                this.enabled = true;
                CommonSimpleRadio.info("..and compat is enabled!", new Object[0]);
            } else {
                CommonSimpleRadio.info("..but compat is disabled!", new Object[0]);
            }
        }
    }

    public static interface CompatibilityConfig {
        public boolean isEnabled();
    }
}

