/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.api.central;

import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.core.registry.SimpleRadioSounds;
import com.codinglitch.simpleradio.core.registry.entities.Wire;
import com.codinglitch.simpleradio.radio.RadioRouter;
import com.codinglitch.simpleradio.radio.RadioSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public interface Socket {
    default public boolean canConnect() {
        return true;
    }

    default public boolean canConnectTo(Socket other) {
        return true;
    }

    default public boolean distribute(RadioSource source) {
        boolean result = false;
        List<Wire> wires = this.getWires();
        wires.removeIf(Predicate.not(Entity::m_6084_));
        for (int i = 0; i < wires.size(); ++i) {
            Wire wire = wires.get(i);
            if (source.wireMedium != null && source.wireMedium.m_20148_().equals(wire.m_20148_())) continue;
            RadioSource oldSource = source;
            if (i < wires.size() - 1) {
                source = source.copy();
            }
            wire.relay(oldSource, this);
            result = true;
        }
        return result;
    }

    default public boolean hasWire(Wire wire) {
        return this.hasWire(wire.getFrom().orElse(null), wire.getTo().orElse(null));
    }

    default public boolean hasWire(UUID from, UUID to) {
        if (from == null || to == null) {
            return false;
        }
        for (Wire otherWire : this.getWires()) {
            Optional<UUID> otherFrom = otherWire.getFrom();
            Optional<UUID> otherTo = otherWire.getTo();
            if (otherFrom.isEmpty() || otherTo.isEmpty()) continue;
            if (otherFrom.get().equals(from) && otherTo.get().equals(to)) {
                return true;
            }
            if (!otherFrom.get().equals(to) || !otherTo.get().equals(from)) continue;
            return true;
        }
        return false;
    }

    default public void connect(Wire wire) {
        this.getWires().add(wire);
    }

    default public void disconnect(Wire wire) {
        this.getWires().removeIf(otherWire -> otherWire.equals(wire));
    }

    default public void disconnect(UUID wire) {
        this.getWires().removeIf(otherWire -> otherWire.m_20148_().equals(wire));
    }

    default public UUID getReference() {
        return this.getRouter().getReference();
    }

    default public short getIdentifier() {
        return this.getRouter().getIdentifier();
    }

    default public List<Wire> getWires() {
        RadioRouter router = this.getRouter();
        if (router == null) {
            return List.of();
        }
        return router.getWires();
    }

    default public void shortCircuit() {
        RadioRouter router = this.getRouter();
        WorldlyPosition location = router.getLocation();
        Level level = location.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Socket.shortAt(serverLevel, location);
        }
        for (Object wire : ((ArrayList)router.getWires()).toArray()) {
            ((Wire)wire).burnOut();
        }
        this.getWires().clear();
    }

    public static void shortAt(ServerLevel level, Vector3f location) {
        level.m_6263_(null, (double)location.x, (double)location.y, (double)location.z, SimpleRadioSounds.SHORT_CIRCUIT, SoundSource.BLOCKS, 0.3f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
        level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, (double)location.x, (double)location.y, (double)location.z, 10, -0.2 + level.f_46441_.m_188500_() * 0.4, -0.2 + level.f_46441_.m_188500_() * 0.4, -0.2 + level.f_46441_.m_188500_() * 0.4, 1.0);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123797_, (double)location.x, (double)location.y, (double)location.z, 8, -0.2 + level.f_46441_.m_188500_() * 0.4, -0.2 + level.f_46441_.m_188500_() * 0.4, -0.2 + level.f_46441_.m_188500_() * 0.4, 1.0);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)location.x, (double)location.y, (double)location.z, 5, 0.2, 0.2, 0.2, 0.1);
    }

    public RadioRouter getRouter();
}

