/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.utils;

import java.util.List;
import me.wesley1808.servercore.common.config.data.mob_spawning.EnforcedMobcap;
import me.wesley1808.servercore.common.utils.ModCompat;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.NaturalSpawner;

public class Mobcaps {
    public static final LocalMobCapCalculator.MobCounts EMPTY_MOBCOUNTS = new LocalMobCapCalculator.MobCounts();
    public static final int MAGIC_NUMBER = (int)Math.pow(17.0, 2.0);

    public static boolean canSpawnForCategory(ServerLevel level, ChunkPos pos, MobCategory category, EnforcedMobcap config) {
        NaturalSpawner.SpawnState state = level.m_7726_().m_8485_();
        if (state == null || category == MobCategory.MISC || !config.enforcesMobcap()) {
            return true;
        }
        int capacity = category.m_21608_() + config.additionalCapacity();
        int globalCapacity = Mobcaps.toGlobalCapacity(state, capacity);
        int globalCount = state.m_47148_().getInt((Object)category);
        if (globalCount >= globalCapacity) {
            return false;
        }
        for (ServerPlayer player : Mobcaps.getPlayersNear(level, pos, state.f_186542_)) {
            LocalMobCapCalculator.MobCounts mobCounts = (LocalMobCapCalculator.MobCounts)state.f_186542_.f_186498_.get(player);
            if (mobCounts != null && mobCounts.f_186515_.getOrDefault((Object)category, 0) >= capacity) continue;
            return true;
        }
        return false;
    }

    private static int toGlobalCapacity(NaturalSpawner.SpawnState state, int capacity) {
        return capacity * state.m_47126_() / MAGIC_NUMBER;
    }

    private static List<ServerPlayer> getPlayersNear(ServerLevel level, ChunkPos pos, LocalMobCapCalculator calculator) {
        return ModCompat.VMP ? level.m_7726_().f_8325_.m_183888_(pos) : calculator.m_186507_(pos);
    }
}

