/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.dynamic;

import me.wesley1808.servercore.common.config.Config;
import me.wesley1808.servercore.common.config.data.dynamic.DynamicConfig;
import me.wesley1808.servercore.common.dynamic.DynamicSetting;
import me.wesley1808.servercore.common.interfaces.IMinecraftServer;
import me.wesley1808.servercore.common.interfaces.IMobCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.MobCategory;

public class DynamicManager {
    private final MinecraftServer server;
    private final boolean isClient;
    private double averageTickTime;
    private int count;

    public DynamicManager(MinecraftServer server) {
        this.server = server;
        this.isClient = server.m_129792_();
        DynamicConfig config = Config.get().dynamic();
        if (config.enabled()) {
            int maxViewDistance = DynamicSetting.VIEW_DISTANCE.getMax();
            if (server.m_6846_().m_11312_() > maxViewDistance) {
                this.modifyViewDistance(maxViewDistance);
            }
            int maxSimDistance = DynamicSetting.SIMULATION_DISTANCE.getMax();
            if (server.m_6846_().m_184213_() > maxSimDistance) {
                this.modifySimulationDistance(maxSimDistance);
            }
            DynamicManager.modifyMobcaps(DynamicSetting.MOBCAP_PERCENTAGE.getMax());
        }
    }

    public static DynamicManager getInstance(MinecraftServer server) {
        return ((IMinecraftServer)server).servercore$getDynamicManager();
    }

    public static void update(MinecraftServer server) {
        if (server.m_129921_() % 20 == 0) {
            DynamicManager manager = DynamicManager.getInstance(server);
            manager.updateValues();
            DynamicConfig config = Config.get().dynamic();
            if (config.enabled()) {
                manager.runPerformanceChecks(config);
            }
        }
    }

    private void updateValues() {
        this.averageTickTime = this.calculateAverageTickTime();
        ++this.count;
    }

    protected double calculateAverageTickTime() {
        return this.server.m_129903_();
    }

    private void runPerformanceChecks(DynamicConfig config) {
        boolean increase;
        double targetMspt = config.targetMspt();
        boolean decrease = this.averageTickTime > targetMspt + 5.0;
        boolean bl = increase = this.averageTickTime < Math.max(targetMspt - 5.0, 2.0);
        if (decrease || increase) {
            DynamicSetting setting;
            DynamicSetting[] dynamicSettingArray = DynamicSetting.values();
            int n = dynamicSettingArray.length;
            for (int i = 0; !(i >= n || (setting = dynamicSettingArray[i]).shouldRun(this.count) && setting.modify(increase, this)); ++i) {
            }
        }
    }

    public void modifyViewDistance(int distance) {
        this.server.m_6846_().m_11217_(distance);
        if (this.isClient) {
            Minecraft.m_91087_().f_91066_.m_231984_().m_231514_((Object)distance);
        }
    }

    public void modifySimulationDistance(int distance) {
        this.server.m_6846_().m_184211_(distance);
        if (this.isClient) {
            Minecraft.m_91087_().f_91066_.m_232001_().m_231514_((Object)distance);
        }
    }

    public static void modifyMobcaps(int percentage) {
        double modifier = (float)percentage / 100.0f;
        for (MobCategory category : MobCategory.values()) {
            IMobCategory.modifyCapacity(category, modifier);
        }
    }

    public double getAverageTickTime() {
        return this.averageTickTime;
    }
}

