/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.scp_objects;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.scp_objects.init.ScpObjectsModAttributes;
import net.mcreator.scp_objects.init.ScpObjectsModBlockEntities;
import net.mcreator.scp_objects.init.ScpObjectsModBlocks;
import net.mcreator.scp_objects.init.ScpObjectsModItems;
import net.mcreator.scp_objects.init.ScpObjectsModMenus;
import net.mcreator.scp_objects.init.ScpObjectsModMobEffects;
import net.mcreator.scp_objects.init.ScpObjectsModSounds;
import net.mcreator.scp_objects.init.ScpObjectsModTabs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="scp_objects")
public class ScpObjectsMod {
    public static final Logger LOGGER = LogManager.getLogger(ScpObjectsMod.class);
    public static final String MODID = "scp_objects";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("scp_objects", "scp_objects"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public ScpObjectsMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ScpObjectsModSounds.REGISTRY.register(bus);
        ScpObjectsModBlocks.REGISTRY.register(bus);
        ScpObjectsModBlockEntities.REGISTRY.register(bus);
        ScpObjectsModItems.REGISTRY.register(bus);
        ScpObjectsModTabs.REGISTRY.register(bus);
        ScpObjectsModMobEffects.REGISTRY.register(bus);
        ScpObjectsModMenus.REGISTRY.register(bus);
        ScpObjectsModAttributes.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

