/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.util;

import com.infamous.sapience.util.GeneralHelper;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;

public class ZoglinTasksHelper {
    public static final TagKey<EntityType<?>> ZOGLINS_IGNORE = GeneralHelper.createEntityTag(new ResourceLocation("sapience", "zoglins_ignore"));

    public static Optional<? extends LivingEntity> findNearestValidAttackTarget(Zoglin zoglin) {
        return zoglin.m_6274_().m_21952_(MemoryModuleType.f_148205_).orElse(NearestVisibleLivingEntities.m_186106_()).m_186116_(le -> ZoglinTasksHelper.isTargetable(zoglin, le));
    }

    public static boolean isTargetable(Zoglin zoglin, LivingEntity target) {
        EntityType entitytype = target.m_6095_();
        return !entitytype.m_204039_(ZOGLINS_IGNORE) && Sensor.m_148312_((LivingEntity)zoglin, (LivingEntity)target);
    }

    public static void setAttackTarget(Zoglin zoglin, LivingEntity target) {
        LivingChangeTargetEvent changeTargetEvent = ForgeHooks.onLivingChangeTarget((LivingEntity)zoglin, (LivingEntity)target, (LivingChangeTargetEvent.ILivingTargetType)LivingChangeTargetEvent.LivingTargetType.BEHAVIOR_TARGET);
        if (changeTargetEvent.isCanceled()) {
            return;
        }
        zoglin.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)target);
        zoglin.m_6274_().m_21936_(MemoryModuleType.f_26326_);
    }
}

