/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.util;

import com.infamous.sapience.Sapience;
import com.infamous.sapience.SapienceConfig;
import com.infamous.sapience.capability.reputation.Reputation;
import com.infamous.sapience.capability.reputation.ReputationProvider;
import com.infamous.sapience.util.GeneralHelper;
import com.infamous.sapience.util.PiglinReputationType;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.gossip.GossipContainer;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;

public class ReputationHelper {
    private static final int NEUTRAL_REPUTATION = 0;

    @Nullable
    public static Reputation getReputationCapability(Entity entity) {
        LazyOptional lazyCap = entity.getCapability(ReputationProvider.REPUTATION_CAPABILITY);
        if (lazyCap.isPresent()) {
            return (Reputation)lazyCap.orElseThrow(() -> new IllegalStateException("Couldn't get the reputation capability from the Entity!"));
        }
        Sapience.LOGGER.error("Couldn't get the reputation capability from the Entity in ReputationHelper#getReputationCapability!");
        return null;
    }

    public static void updatePiglinReputation(LivingEntity host, ReputationEventType type, Entity target) {
        Reputation reputation = ReputationHelper.getReputationCapability((Entity)host);
        if (reputation != null) {
            GossipContainer gossipManager = reputation.getGossipManager();
            if (type == PiglinReputationType.WITHER_KILLED) {
                gossipManager.m_26191_(target.m_20148_(), GossipType.MAJOR_POSITIVE, ((Integer)SapienceConfig.COMMON.WITHER_KILLED_GOSSIP_VALUE.get()).intValue());
                gossipManager.m_26191_(target.m_20148_(), GossipType.MINOR_POSITIVE, ((Integer)SapienceConfig.COMMON.WITHER_KILLED_BONUS_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.WITHER_SKELETON_KILLED) {
                gossipManager.m_26191_(target.m_20148_(), GossipType.MAJOR_POSITIVE, ((Integer)SapienceConfig.COMMON.WITHER_SKELETON_KILLED_GOSSIP_VALUE.get()).intValue());
                gossipManager.m_26191_(target.m_20148_(), GossipType.MINOR_POSITIVE, ((Integer)SapienceConfig.COMMON.WITHER_SKELETON_KILLED_BONUS_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.GOLD_GIFT) {
                gossipManager.m_26191_(target.m_20148_(), GossipType.MINOR_POSITIVE, ((Integer)SapienceConfig.COMMON.GOLD_GIFT_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.FOOD_GIFT) {
                gossipManager.m_26191_(target.m_20148_(), GossipType.MINOR_POSITIVE, ((Integer)SapienceConfig.COMMON.FOOD_GIFT_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.BARTER) {
                gossipManager.m_26191_(target.m_20148_(), GossipType.TRADING, ((Integer)SapienceConfig.COMMON.BARTER_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.GOLD_STOLEN) {
                gossipManager.m_26191_(target.m_20148_(), GossipType.MINOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.GOLD_STOLEN_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.ADULT_PIGLIN_HURT) {
                gossipManager.m_26191_(target.m_20148_(), GossipType.MINOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.ADULT_PIGLIN_HURT_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.ALLY_HURT) {
                gossipManager.m_26191_(target.m_20148_(), GossipType.MINOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.ALLY_HURT_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.BABY_PIGLIN_HURT) {
                gossipManager.m_26191_(target.m_20148_(), GossipType.MINOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.BABY_PIGLIN_HURT_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.ADULT_PIGLIN_KILLED) {
                gossipManager.m_26191_(target.m_20148_(), GossipType.MAJOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.ADULT_PIGLIN_KILLED_GOSSIP_VALUE.get()).intValue());
                gossipManager.m_26191_(target.m_20148_(), GossipType.MINOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.ADULT_PIGLIN_KILLED_BONUS_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.ALLY_KILLED) {
                gossipManager.m_26191_(target.m_20148_(), GossipType.MAJOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.ALLY_KILLED_GOSSIP_VALUE.get()).intValue());
                gossipManager.m_26191_(target.m_20148_(), GossipType.MINOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.ALLY_KILLED_BONUS_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.BABY_PIGLIN_KILLED) {
                gossipManager.m_26191_(target.m_20148_(), GossipType.MAJOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.BABY_PIGLIN_KILLED_GOSSIP_VALUE.get()).intValue());
                gossipManager.m_26191_(target.m_20148_(), GossipType.MINOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.BABY_PIGLIN_KILLED_BONUS_GOSSIP_VALUE.get()).intValue());
            } else if (type == PiglinReputationType.BRUTE_KILLED) {
                gossipManager.m_26191_(target.m_20148_(), GossipType.MAJOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.BRUTE_KILLED_GOSSIP_VALUE.get()).intValue());
                gossipManager.m_26191_(target.m_20148_(), GossipType.MINOR_NEGATIVE, ((Integer)SapienceConfig.COMMON.BRUTE_KILLED_BONUS_GOSSIP_VALUE.get()).intValue());
            }
        }
    }

    public static void spreadGossip(LivingEntity host, LivingEntity ally, long gameTime) {
        Reputation hostReputation = ReputationHelper.getReputationCapability((Entity)host);
        Reputation allyReputation = ReputationHelper.getReputationCapability((Entity)ally);
        if (!(hostReputation == null || allyReputation == null || gameTime >= hostReputation.getLastGossipTime() && gameTime < hostReputation.getLastGossipTime() + 1200L || gameTime >= allyReputation.getLastGossipTime() && gameTime < allyReputation.getLastGossipTime() + 1200L)) {
            hostReputation.getGossipManager().m_217762_(allyReputation.getGossipManager(), host.m_217043_(), 10);
            hostReputation.setLastGossipTime(gameTime);
            allyReputation.setLastGossipTime(gameTime);
        }
    }

    public static void spreadGossipDirect(LivingEntity host, LivingEntity ally) {
        Reputation hostReputation = ReputationHelper.getReputationCapability((Entity)host);
        Reputation allyReputation = ReputationHelper.getReputationCapability((Entity)ally);
        if (hostReputation != null && allyReputation != null) {
            hostReputation.getGossipManager().m_217762_(allyReputation.getGossipManager(), host.m_217043_(), 10);
        }
    }

    public static void makeWitnessesOfMurder(LivingEntity victim, Entity murderer, ReputationEventType killedReputationType, Predicate<LivingEntity> additionalCheck) {
        Level level = victim.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverworld = (ServerLevel)level;
            if (victim.m_6274_().m_21874_(MemoryModuleType.f_148205_)) {
                Optional optional = victim.m_6274_().m_21952_(MemoryModuleType.f_148205_);
                optional.ifPresent(nvle -> nvle.m_186123_(le -> ReputationHelper.hasModdedReputationHandling((Entity)le) && additionalCheck.test((LivingEntity)le)).forEach(le -> ReputationHelper.updatePiglinReputation(le, killedReputationType, murderer)));
            } else {
                double scale = 16.0;
                AABB aabb = victim.m_20191_().m_82400_(16.0);
                serverworld.m_6443_(LivingEntity.class, aabb, le -> le != victim && le.m_6084_() && ReputationHelper.hasModdedReputationHandling((Entity)le) && additionalCheck.test((LivingEntity)le)).forEach(le -> ReputationHelper.updatePiglinReputation(le, killedReputationType, murderer));
            }
        }
    }

    public static void updateGossip(Mob mobEntity) {
        Reputation reputation = ReputationHelper.getReputationCapability((Entity)mobEntity);
        if (reputation != null && mobEntity.m_9236_() instanceof ServerLevel) {
            long gameTime = mobEntity.m_9236_().m_46467_();
            if (reputation.getLastGossipDecay() == 0L) {
                reputation.setLastGossipDecay(gameTime);
            } else if (gameTime >= reputation.getLastGossipDecay() + 24000L) {
                reputation.getGossipManager().m_26198_();
                reputation.setLastGossipDecay(gameTime);
            }
        }
    }

    public static void setGossip(Mob mobEntity, Tag gossip) {
        Reputation reputation = ReputationHelper.getReputationCapability((Entity)mobEntity);
        if (reputation != null) {
            reputation.getGossipManager().m_26177_(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)gossip));
        }
    }

    public static int getEntityReputation(Entity host, Entity entityToCheck) {
        Reputation reputation = ReputationHelper.getReputationCapability(host);
        if (reputation != null) {
            return reputation.getGossipManager().m_26195_(entityToCheck.m_20148_(), gossipType -> true);
        }
        return 0;
    }

    @Nullable
    public static Entity getPreviousInteractor(Mob mobEntity) {
        Reputation reputation = ReputationHelper.getReputationCapability((Entity)mobEntity);
        if (reputation != null && mobEntity.m_9236_() instanceof ServerLevel) {
            if (reputation.getPreviousInteractor() != null) {
                return ((ServerLevel)mobEntity.m_9236_()).m_8791_(reputation.getPreviousInteractor());
            }
            return null;
        }
        return null;
    }

    public static void setPreviousInteractor(Mob mobEntity, @Nullable Entity interactor) {
        Reputation reputation = ReputationHelper.getReputationCapability((Entity)mobEntity);
        if (reputation != null) {
            if (interactor != null) {
                reputation.setPreviousInteractor(interactor.m_20148_());
            } else {
                reputation.setPreviousInteractor(null);
            }
        }
    }

    public static void updatePreviousInteractorReputation(Mob mobEntity, ReputationEventType reputationType) {
        Level level;
        Entity previousInteractor = ReputationHelper.getPreviousInteractor(mobEntity);
        if (previousInteractor != null && (level = mobEntity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            ReputationHelper.updatePiglinReputation((LivingEntity)mobEntity, reputationType, previousInteractor);
            ReputationHelper.setPreviousInteractor(mobEntity, null);
        }
    }

    public static boolean isAllowedToTouchGold(Player playerEntity, Piglin nearbyPiglin) {
        return ReputationHelper.isAlly((LivingEntity)nearbyPiglin, (LivingEntity)playerEntity) || GeneralHelper.isOnSameTeam((LivingEntity)nearbyPiglin, (LivingEntity)playerEntity);
    }

    public static boolean hasAcceptableAttire(LivingEntity livingEntity, LivingEntity sensorEntity) {
        return PiglinAi.m_34808_((LivingEntity)livingEntity) && ReputationHelper.getEntityReputation((Entity)sensorEntity, (Entity)livingEntity) > (Integer)SapienceConfig.COMMON.ENEMY_GOSSIP_REQUIREMENT.get() || ReputationHelper.getEntityReputation((Entity)sensorEntity, (Entity)livingEntity) >= (Integer)SapienceConfig.COMMON.FRIENDLY_GOSSIP_REQUIREMENT.get();
    }

    public static boolean isAllowedToBarter(Piglin piglinEntity, LivingEntity interactorEntity) {
        return ReputationHelper.getEntityReputation((Entity)piglinEntity, (Entity)interactorEntity) > (Integer)SapienceConfig.COMMON.UNFRIENDLY_GOSSIP_REQUIREMENT.get();
    }

    public static boolean hasVanillaOrModdedReputationHandling(Entity target) {
        return target instanceof ReputationEventHandler || ReputationHelper.hasModdedReputationHandling(target);
    }

    public static boolean hasModdedReputationHandling(Entity target) {
        return target.getCapability(ReputationProvider.REPUTATION_CAPABILITY).isPresent();
    }

    public static boolean isAlly(LivingEntity host, LivingEntity toCheck) {
        return ReputationHelper.getEntityReputation((Entity)host, (Entity)toCheck) >= (Integer)SapienceConfig.COMMON.ALLY_GOSSIP_REQUIREMENT.get();
    }
}

