/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.util;

import com.google.common.collect.ImmutableList;
import com.infamous.sapience.Sapience;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.ShufflingList;
import net.minecraft.world.entity.ai.behavior.StartCelebratingIfTargetDead;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class ReflectionHelper {
    private static final Map<String, Method> CACHED_METHODS = new HashMap<String, Method>();
    private static final Map<String, Field> CACHED_FIELDS = new HashMap<String, Field>();

    public static Optional<Object> callMethod(String methodName, Object invokeOn, Class<?> inClass, Object[] parameters, Class<?>[] parameterTypes) {
        Method method = CACHED_METHODS.computeIfAbsent(methodName, k -> ObfuscationReflectionHelper.findMethod((Class)inClass, (String)methodName, (Class[])parameterTypes));
        try {
            return Optional.ofNullable(method.invoke(invokeOn, parameters));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Sapience.LOGGER.info("Reflection error for method {}! Invoked on {} with parameter {}", (Object)methodName, inClass, (Object)Arrays.toString(parameterTypes));
            return Optional.empty();
        }
    }

    public static Optional<Object> accessField(String fieldName, Object accessFrom, Class<?> inClass) {
        Field field = CACHED_FIELDS.computeIfAbsent(fieldName, k -> ObfuscationReflectionHelper.findField((Class)inClass, (String)fieldName));
        try {
            return Optional.ofNullable(field.get(accessFrom));
        }
        catch (IllegalAccessException e) {
            Sapience.LOGGER.info("Reflection error for field {}! Invoked on {}", (Object)fieldName, inClass);
            return Optional.empty();
        }
    }

    public static long getSpawnChildAtTime(AnimalMakeLove behavior) {
        return (Long)ReflectionHelper.accessField("f_22389_", behavior, behavior.getClass()).get();
    }

    public static int getCelebrateDuration(StartCelebratingIfTargetDead behavior) {
        return (Integer)ReflectionHelper.accessField("f_24219_", behavior, behavior.getClass()).get();
    }

    public static EntityType<? extends Animal> getPartnerType(AnimalMakeLove behavior) {
        return (EntityType)ReflectionHelper.accessField("f_22387_", behavior, behavior.getClass()).get();
    }

    public static Map<Integer, Map<Activity, Set<BehaviorControl<? extends LivingEntity>>>> getAvailableBehaviorsByPriority(Brain<?> brain) {
        return (Map)ReflectionHelper.accessField("f_21845_", brain, brain.getClass()).get();
    }

    public static ShufflingList<BehaviorControl<?>> getBehaviors(GateBehavior<?> gateBehavior) {
        return (ShufflingList)ReflectionHelper.accessField("f_22871_", gateBehavior, GateBehavior.class).get();
    }

    public static ImmutableList<MemoryModuleType<?>> getMEMORY_TYPES(@Nullable Piglin piglin) {
        return (ImmutableList)ReflectionHelper.accessField("f_34672_", piglin, Piglin.class).get();
    }

    public static ImmutableList<MemoryModuleType<?>> getMEMORY_TYPES(@Nullable Hoglin hoglin) {
        return (ImmutableList)ReflectionHelper.accessField("f_34481_", hoglin, Hoglin.class).get();
    }

    public static ImmutableList<? extends SensorType<? extends Sensor<? super Hoglin>>> getSENSOR_TYPES(@Nullable Hoglin hoglin) {
        return (ImmutableList)ReflectionHelper.accessField("f_34480_", hoglin, Hoglin.class).get();
    }

    public static PartPose getHeadDefault(PiglinModel<?> piglinModel) {
        return (PartPose)ReflectionHelper.accessField("f_103338_", piglinModel, PiglinModel.class).get();
    }

    public static PartPose getLeftArmDefault(PiglinModel<?> piglinModel) {
        return (PartPose)ReflectionHelper.accessField("f_103333_", piglinModel, PiglinModel.class).get();
    }

    public static PartPose getRightArmDefault(PiglinModel<?> piglinModel) {
        return (PartPose)ReflectionHelper.accessField("f_103334_", piglinModel, PiglinModel.class).get();
    }

    public static boolean callCanReplaceCurrentItem(Piglin piglin, ItemStack stack) {
        return (Boolean)ReflectionHelper.callMethod("m_34787_", piglin, Piglin.class, new Object[]{stack}, new Class[]{ItemStack.class}).get();
    }

    public static boolean getDead(LivingEntity livingEntity) {
        return (Boolean)ReflectionHelper.accessField("f_20890_", livingEntity, LivingEntity.class).get();
    }

    public static void callSetAngerTargetIfCloserThanCurrent(AbstractPiglin piglin, LivingEntity target) {
        ReflectionHelper.callMethod("m_34962_", null, PiglinAi.class, new Object[]{piglin, target}, new Class[]{AbstractPiglin.class, LivingEntity.class});
    }
}

