/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.util;

import com.google.common.collect.Lists;
import com.infamous.sapience.SapienceConfig;
import com.infamous.sapience.capability.emotive.EmotiveProvider;
import com.infamous.sapience.mod.ModMemoryModuleTypes;
import com.infamous.sapience.tasks.CraftWithGoldTask;
import com.infamous.sapience.tasks.CreateBabyTask;
import com.infamous.sapience.tasks.FeedHoglinsTask;
import com.infamous.sapience.tasks.ShareGoldTask;
import com.infamous.sapience.util.AgeableHelper;
import com.infamous.sapience.util.BrainHelper;
import com.infamous.sapience.util.GeneralHelper;
import com.infamous.sapience.util.GreedHelper;
import com.infamous.sapience.util.PiglinReputationType;
import com.infamous.sapience.util.ReflectionHelper;
import com.infamous.sapience.util.ReputationHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.InteractWith;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinArmPose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class PiglinTasksHelper {
    public static final TagKey<EntityType<?>> PIGLINS_HUNT = GeneralHelper.createEntityTag(new ResourceLocation("sapience", "piglins_hunt"));
    public static final TagKey<EntityType<?>> PIGLINS_AVOID = GeneralHelper.createEntityTag(new ResourceLocation("sapience", "piglins_avoid"));
    public static final TagKey<EntityType<?>> PIGLINS_HATE = GeneralHelper.createEntityTag(new ResourceLocation("sapience", "piglins_hate"));
    public static final TagKey<Item> PIGLINS_BARTER = ItemTags.create((ResourceLocation)new ResourceLocation("sapience", "piglins_barter"));
    public static final TagKey<Item> PIGLINS_BARTER_CHEAP = ItemTags.create((ResourceLocation)new ResourceLocation("sapience", "piglins_barter_cheap"));
    public static final TagKey<Item> PIGLINS_BARTER_EXPENSIVE = ItemTags.create((ResourceLocation)new ResourceLocation("sapience", "piglins_barter_expensive"));
    public static final ResourceLocation PIGLIN_BARTERING_CHEAP = new ResourceLocation("sapience", "gameplay/piglin_bartering_cheap");
    public static final ResourceLocation PIGLIN_BARTERING_EXPENSIVE = new ResourceLocation("sapience", "gameplay/piglin_bartering_expensive");
    private static final UniformInt RANGED_FEEDING_TIMER = TimeUtil.m_145020_((int)30, (int)120);
    public static final UniformInt TIME_BETWEEN_HUNTS = TimeUtil.m_145020_((int)30, (int)120);

    private static void dropItems(AbstractPiglin piglinEntity, List<ItemStack> itemStacks, Vec3 vector3d) {
        if (!itemStacks.isEmpty()) {
            piglinEntity.m_6674_(InteractionHand.OFF_HAND);
            for (ItemStack itemstack : itemStacks) {
                BehaviorUtils.m_22613_((LivingEntity)piglinEntity, (ItemStack)itemstack, (Vec3)vector3d.m_82520_(0.0, 1.0, 0.0));
            }
        }
    }

    private static Vec3 getNearbyVectorOrPositionVector(AbstractPiglin piglinEntity) {
        Vec3 vector3d = LandRandomPos.m_148488_((PathfinderMob)piglinEntity, (int)4, (int)2);
        return vector3d == null ? piglinEntity.m_20182_() : vector3d;
    }

    private static void dropItemsNearSelf(AbstractPiglin piglinEntity, List<ItemStack> itemStacks) {
        PiglinTasksHelper.dropItems(piglinEntity, itemStacks, PiglinTasksHelper.getNearbyVectorOrPositionVector(piglinEntity));
    }

    public static void setAteRecently(AbstractPiglin piglinEntity) {
        piglinEntity.m_6274_().m_21882_(MemoryModuleType.f_26355_, (Object)true, 200L);
    }

    public static ItemStack extractSingletonFromItemEntity(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.m_32055_();
        ItemStack itemstack1 = itemstack.m_41620_(1);
        if (itemstack.m_41619_()) {
            itemEntity.m_146870_();
        } else {
            itemEntity.m_32045_(itemstack);
        }
        return itemstack1;
    }

    public static boolean isPiglinFoodItem(ItemStack item) {
        return item.m_204117_(ItemTags.f_144310_) && item.m_41614_();
    }

    public static boolean hasAteRecently(AbstractPiglin piglinEntity) {
        return piglinEntity.m_6274_().m_21874_(MemoryModuleType.f_26355_);
    }

    public static boolean hasOpenOffhandSlot(Piglin piglinEntity) {
        return piglinEntity.m_21206_().m_41619_() || !PiglinTasksHelper.isPiglinLoved(piglinEntity.m_21206_());
    }

    public static boolean isPiglinLoved(ItemStack item) {
        return item.m_204117_(ItemTags.f_13151_);
    }

    private static boolean hasAdmiringDisabled(AbstractPiglin piglinEntity) {
        return piglinEntity.m_6274_().m_21874_(MemoryModuleType.f_26339_);
    }

    public static boolean hasNotFedRecently(Piglin piglinEntity) {
        return !PiglinTasksHelper.hasFedRecently(piglinEntity);
    }

    public static void setFedRecently(Piglin piglinEntity) {
        piglinEntity.m_6274_().m_21882_((MemoryModuleType)ModMemoryModuleTypes.FED_RECENTLY.get(), (Object)true, (long)RANGED_FEEDING_TIMER.m_214085_(piglinEntity.m_9236_().f_46441_));
    }

    private static boolean hasFedRecently(Piglin piglinEntity) {
        return piglinEntity.m_6274_().m_21874_((MemoryModuleType)ModMemoryModuleTypes.FED_RECENTLY.get());
    }

    public static void removeTimeTryingToReachAdmireItem(Piglin piglinEntity) {
        piglinEntity.m_6274_().m_21936_(MemoryModuleType.f_26337_);
    }

    public static void dropOffhandItemAndSetItemStackToOffhand(AbstractPiglin piglinEntity, ItemStack itemStack) {
        if (PiglinTasksHelper.hasOffhandItem(piglinEntity)) {
            piglinEntity.m_19983_(piglinEntity.m_21120_(InteractionHand.OFF_HAND));
        }
        PiglinTasksHelper.setItemStackToOffhandAndPersist(piglinEntity, itemStack);
    }

    private static boolean hasOffhandItem(AbstractPiglin piglinEntity) {
        return !piglinEntity.m_21206_().m_41619_();
    }

    private static void setItemStackToOffhandAndPersist(AbstractPiglin piglinEntity, ItemStack itemStack) {
        piglinEntity.m_8061_(EquipmentSlot.OFFHAND, itemStack);
        piglinEntity.m_21508_(EquipmentSlot.OFFHAND);
        piglinEntity.m_21530_();
    }

    public static void clearWalkPath(AbstractPiglin piglinEntity) {
        piglinEntity.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        piglinEntity.m_21573_().m_26573_();
    }

    public static boolean hasConsumableOffhandItem(AbstractPiglin piglinEntity) {
        ItemStack offhandStack = piglinEntity.m_21206_();
        return PiglinTasksHelper.isPiglinFoodItem(offhandStack) || offhandStack.m_41780_() == UseAnim.DRINK;
    }

    public static void setAdmiringItem(LivingEntity livingEntity) {
        livingEntity.m_6274_().m_21882_(MemoryModuleType.f_26336_, (Object)true, 120L);
    }

    private static boolean hasAdmiringItem(AbstractPiglin piglinEntity) {
        return piglinEntity.m_6274_().m_21874_(MemoryModuleType.f_26336_);
    }

    public static boolean isNormalBarterItem(ItemStack item) {
        return item.m_204117_(PIGLINS_BARTER);
    }

    public static boolean isBarterItem(ItemStack item) {
        return PiglinTasksHelper.isNormalBarterItem(item) || PiglinTasksHelper.isAlternativeGreedItem(item);
    }

    private static boolean isAlternativeGreedItem(ItemStack item) {
        return PiglinTasksHelper.isExpensiveBarterItem(item) || PiglinTasksHelper.isCheapBarterItem(item);
    }

    private static InteractionResult processInteractionForFoodItem(AbstractPiglin piglinEntity, Player playerEntity, InteractionHand hand) {
        ItemStack itemstack = playerEntity.m_21120_(hand);
        if (PiglinTasksHelper.canAcceptFoodItem(piglinEntity, itemstack)) {
            ItemStack foodStack = itemstack.m_41620_(1);
            PiglinTasksHelper.dropOffhandItemAndSetItemStackToOffhand(piglinEntity, foodStack);
            PiglinTasksHelper.setAdmiringItem((LivingEntity)piglinEntity);
            PiglinTasksHelper.clearWalkPath(piglinEntity);
            ReputationHelper.setPreviousInteractor((Mob)piglinEntity, (Entity)playerEntity);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult processInteractionForPiglinGreedItem(AbstractPiglin piglinEntity, Player playerEntity, InteractionHand handIn) {
        ItemStack itemstack = playerEntity.m_21120_(handIn);
        if (PiglinTasksHelper.canAcceptPiglinGreedItem(piglinEntity, itemstack)) {
            ItemStack greedStack = itemstack.m_41620_(1);
            PiglinTasksHelper.dropOffhandItemAndSetItemStackToOffhand(piglinEntity, greedStack);
            PiglinTasksHelper.setAdmiringItem((LivingEntity)piglinEntity);
            PiglinTasksHelper.clearWalkPath(piglinEntity);
            ReputationHelper.setPreviousInteractor((Mob)piglinEntity, (Entity)playerEntity);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult processInteractionForPiglinLovedItem(AbstractPiglin piglinEntity, Player playerEntity, InteractionHand handIn) {
        ItemStack itemstack = playerEntity.m_21120_(handIn);
        if (PiglinTasksHelper.canAcceptPiglinLovedItem(piglinEntity, itemstack)) {
            ItemStack greedStack = itemstack.m_41620_(1);
            PiglinTasksHelper.dropOffhandItemAndSetItemStackToOffhand(piglinEntity, greedStack);
            PiglinTasksHelper.setAdmiringItem((LivingEntity)piglinEntity);
            PiglinTasksHelper.clearWalkPath(piglinEntity);
            ReputationHelper.setPreviousInteractor((Mob)piglinEntity, (Entity)playerEntity);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private static boolean canAcceptPiglinGreedItem(AbstractPiglin piglinEntity, ItemStack itemStack) {
        return !PiglinTasksHelper.hasAdmiringDisabled(piglinEntity) && !PiglinTasksHelper.hasAdmiringItem(piglinEntity) && PiglinTasksHelper.isBarterItem(itemStack) && !PiglinTasksHelper.hasConsumableOffhandItem(piglinEntity);
    }

    private static boolean canAcceptPiglinLovedItem(AbstractPiglin piglinEntity, ItemStack itemStack) {
        return !PiglinTasksHelper.hasAdmiringDisabled(piglinEntity) && !PiglinTasksHelper.hasAdmiringItem(piglinEntity) && PiglinTasksHelper.isPiglinLoved(itemStack) && !PiglinTasksHelper.hasConsumableOffhandItem(piglinEntity);
    }

    private static boolean canAcceptFoodItem(AbstractPiglin piglinEntity, ItemStack itemStack) {
        return !PiglinTasksHelper.hasAdmiringDisabled(piglinEntity) && !PiglinTasksHelper.hasAdmiringItem(piglinEntity) && PiglinTasksHelper.isPiglinFoodItem(itemStack) && !PiglinTasksHelper.hasAteRecently(piglinEntity) && !piglinEntity.m_5912_() && !PiglinTasksHelper.hasConsumableOffhandItem(piglinEntity);
    }

    public static InteractionResult getAgeableActionResultType(AbstractPiglin piglinEntity, Player playerEntity, InteractionHand handIn, InteractionResult actionResultTypeIn) {
        ItemStack itemStack = playerEntity.m_21120_(handIn);
        if (PiglinTasksHelper.isPiglinFoodItem(itemStack)) {
            if (!piglinEntity.m_9236_().f_46443_) {
                actionResultTypeIn = PiglinTasksHelper.processInteractionForFoodItem(piglinEntity, playerEntity, handIn);
            } else {
                boolean canAcceptFoodItem = PiglinTasksHelper.canAcceptFoodItem(piglinEntity, itemStack) && PiglinTasksHelper.isNotAdmiringClientSide(piglinEntity);
                actionResultTypeIn = canAcceptFoodItem ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
        }
        return actionResultTypeIn;
    }

    public static InteractionResult getGreedActionResultType(AbstractPiglin piglinEntity, Player playerEntity, InteractionHand handIn, InteractionResult actionResultTypeIn) {
        ItemStack itemStack = playerEntity.m_21120_(handIn);
        if (PiglinTasksHelper.isBarterItem(itemStack)) {
            if (!piglinEntity.m_9236_().f_46443_) {
                actionResultTypeIn = PiglinTasksHelper.processInteractionForPiglinGreedItem(piglinEntity, playerEntity, handIn);
            } else {
                boolean canTakeGreedItem = PiglinTasksHelper.canAcceptPiglinGreedItem(piglinEntity, itemStack) && PiglinTasksHelper.isNotAdmiringClientSide(piglinEntity);
                actionResultTypeIn = canTakeGreedItem ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
        } else if (PiglinTasksHelper.isPiglinLoved(itemStack)) {
            if (!piglinEntity.m_9236_().f_46443_) {
                actionResultTypeIn = PiglinTasksHelper.processInteractionForPiglinLovedItem(piglinEntity, playerEntity, handIn);
            } else {
                boolean canTakeLovedItem = PiglinTasksHelper.canAcceptPiglinLovedItem(piglinEntity, itemStack) && PiglinTasksHelper.isNotAdmiringClientSide(piglinEntity);
                actionResultTypeIn = canTakeLovedItem ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
        }
        return actionResultTypeIn;
    }

    private static boolean isNotAdmiringClientSide(AbstractPiglin piglinEntity) {
        return piglinEntity.m_6389_() != PiglinArmPose.ADMIRING_ITEM || !PiglinTasksHelper.shouldAdmire(piglinEntity.m_21206_());
    }

    private static List<ItemStack> getBlockBarteringLoot(AbstractPiglin piglinEntity) {
        if (piglinEntity.m_9236_().m_7654_() != null) {
            LootTable loottable = piglinEntity.m_9236_().m_7654_().m_278653_().m_278676_(PIGLIN_BARTERING_EXPENSIVE);
            return loottable.m_287195_(new LootParams.Builder((ServerLevel)piglinEntity.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)piglinEntity).m_287235_(LootContextParamSets.f_81417_));
        }
        return Collections.emptyList();
    }

    private static List<ItemStack> getBarterResponseItems(AbstractPiglin piglin) {
        LootTable loottable = piglin.m_9236_().m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_78738_);
        return loottable.m_287195_(new LootParams.Builder((ServerLevel)piglin.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)piglin).m_287235_(LootContextParamSets.f_81417_));
    }

    private static List<ItemStack> getNuggetBarteringLoot(AbstractPiglin piglinEntity) {
        if (piglinEntity.m_9236_().m_7654_() != null) {
            LootTable loottable = piglinEntity.m_9236_().m_7654_().m_278653_().m_278676_(PIGLIN_BARTERING_CHEAP);
            return loottable.m_287195_(new LootParams.Builder((ServerLevel)piglinEntity.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)piglinEntity).m_287235_(LootContextParamSets.f_81417_));
        }
        return Collections.emptyList();
    }

    public static boolean isExpensiveBarterItem(ItemStack item) {
        return item.m_204117_(PIGLINS_BARTER_EXPENSIVE);
    }

    public static boolean isCheapBarterItem(ItemStack item) {
        return item.m_204117_(PIGLINS_BARTER_CHEAP);
    }

    public static void dropItemsAccountingForNearbyPlayer(AbstractPiglin piglinEntity, List<ItemStack> itemStacks) {
        Optional<Player> optionalPlayerEntity = PiglinTasksHelper.getNearestVisiblePlayer(piglinEntity);
        if (optionalPlayerEntity.isPresent()) {
            PiglinTasksHelper.dropItemsNearPlayer(piglinEntity, optionalPlayerEntity.get(), itemStacks);
        } else {
            PiglinTasksHelper.dropItemsNearSelf(piglinEntity, itemStacks);
        }
    }

    private static Optional<Player> getNearestVisiblePlayer(AbstractPiglin piglinEntity) {
        return piglinEntity.m_6274_().m_21952_(MemoryModuleType.f_26368_);
    }

    private static void dropItemsNearPlayer(AbstractPiglin piglinEntity, Player playerEntity, List<ItemStack> itemStacks) {
        PiglinTasksHelper.dropItems(piglinEntity, itemStacks, playerEntity.m_20182_());
    }

    public static boolean hasIdle(AbstractPiglin piglinEntity) {
        return piglinEntity.m_6274_().m_21954_(Activity.f_37979_);
    }

    public static boolean piglinsAvoid(EntityType<?> entityType) {
        return entityType.m_204039_(PIGLINS_AVOID);
    }

    public static boolean piglinsHate(EntityType<?> entityType) {
        return entityType.m_204039_(PIGLINS_HATE);
    }

    public static void additionalSensorLogic(LivingEntity entityIn) {
        Brain brain = entityIn.m_6274_();
        Optional<Object> optionalNemesis = Optional.empty();
        Optional<Object> optionalHuntableHoglin = Optional.empty();
        Optional<Object> optionalPlayerNotGilded = Optional.empty();
        Optional<Object> optionalZombified = Optional.empty();
        Optional<Object> optionalNearestVisibleAdultHoglin = Optional.empty();
        ArrayList visibleAdultPiglins = Lists.newArrayList();
        NearestVisibleLivingEntities nearestvisiblelivingentities = brain.m_21952_(MemoryModuleType.f_148205_).orElse(NearestVisibleLivingEntities.m_186106_());
        for (LivingEntity nearby : nearestvisiblelivingentities.m_186123_(le -> true)) {
            if (nearby instanceof Hoglin) {
                Hoglin hoglin = (Hoglin)nearby;
                if (hoglin.m_34552_() && optionalNearestVisibleAdultHoglin.isEmpty()) {
                    optionalNearestVisibleAdultHoglin = Optional.of(hoglin);
                }
                if (!optionalHuntableHoglin.isEmpty() || !hoglin.m_34555_() || !GeneralHelper.isNotOnSameTeam(entityIn, (LivingEntity)hoglin)) continue;
                optionalHuntableHoglin = Optional.of(hoglin);
                continue;
            }
            if (nearby instanceof AbstractPiglin) {
                AbstractPiglin piglin = (AbstractPiglin)nearby;
                if (!piglin.m_34667_()) continue;
                visibleAdultPiglins.add(piglin);
                continue;
            }
            if (nearby instanceof Player) {
                Player player = (Player)nearby;
                if (!optionalPlayerNotGilded.isEmpty() || !entityIn.m_6779_(nearby) || ReputationHelper.hasAcceptableAttire(nearby, entityIn) || !GeneralHelper.isNotOnSameTeam(entityIn, nearby)) continue;
                optionalPlayerNotGilded = Optional.of(player);
                continue;
            }
            if (optionalNemesis.isPresent() || !PiglinTasksHelper.piglinsHate(nearby.m_6095_())) {
                if (!optionalZombified.isEmpty() || !PiglinTasksHelper.piglinsAvoid(nearby.m_6095_()) || !GeneralHelper.isNotOnSameTeam(entityIn, nearby)) continue;
                optionalZombified = Optional.of(nearby);
                continue;
            }
            if (!GeneralHelper.isNotOnSameTeam(entityIn, nearby)) continue;
            optionalNemesis = Optional.of((Mob)nearby);
        }
        brain.m_21886_(MemoryModuleType.f_26333_, optionalNemesis);
        brain.m_21886_(MemoryModuleType.f_26343_, optionalHuntableHoglin);
        brain.m_21886_(MemoryModuleType.f_26351_, optionalZombified);
        brain.m_21886_(MemoryModuleType.f_26345_, optionalPlayerNotGilded);
        brain.m_21886_((MemoryModuleType)ModMemoryModuleTypes.NEAREST_VISIBLE_ADULT_HOGLIN.get(), optionalNearestVisibleAdultHoglin);
        brain.m_21879_(MemoryModuleType.f_26347_, (Object)visibleAdultPiglins);
        brain.m_21879_(MemoryModuleType.f_26352_, (Object)visibleAdultPiglins.size());
    }

    public static void addAdditionalIdleMovementBehaviors(GateBehavior<Piglin> gateBehavior) {
        BrainHelper.addToGateBehavior(gateBehavior, Pair.of((Object)InteractWith.m_257746_((EntityType)EntityType.f_20511_, (int)8, AgeableHelper::canBreed, AgeableHelper::canBreed, (MemoryModuleType)((MemoryModuleType)ModMemoryModuleTypes.BREEDING_TARGET.get()), (float)0.5f, (int)2), (Object)1), Pair.of(new CreateBabyTask(), (Object)3), Pair.of(new ShareGoldTask(), (Object)2), Pair.of(new CraftWithGoldTask(), (Object)2), Pair.of(new FeedHoglinsTask(), (Object)2));
    }

    public static InteractionResult handlePiglinInteraction(Piglin piglin, Player playerEntity, InteractionHand handIn) {
        InteractionResult interactionResult = InteractionResult.PASS;
        if (!interactionResult.m_19077_() && !(interactionResult = PiglinTasksHelper.getGreedActionResultType((AbstractPiglin)piglin, playerEntity, handIn, interactionResult)).m_19077_()) {
            interactionResult = PiglinTasksHelper.getAgeableActionResultType((AbstractPiglin)piglin, playerEntity, handIn, interactionResult);
        }
        return interactionResult;
    }

    public static void handlePiglinInteractPost(Piglin piglin, Player player, InteractionResult interactionResult) {
        if (!interactionResult.m_19077_()) {
            piglin.getCapability(EmotiveProvider.EMOTIVE_CAPABILITY).ifPresent(e -> e.setShakeHeadTicks(40));
            if (piglin.m_9236_().f_46443_) {
                piglin.m_5496_(SoundEvents.f_12240_, 1.0f, piglin.m_6100_());
            } else {
                piglin.m_9236_().m_7605_((Entity)piglin, (byte)6);
            }
        } else if (piglin.m_9236_().f_46443_) {
            piglin.m_5496_(SoundEvents.f_12241_, 1.0f, piglin.m_6100_());
        } else {
            piglin.m_9236_().m_7605_((Entity)piglin, (byte)8);
            ReputationHelper.setPreviousInteractor((Mob)piglin, (Entity)player);
        }
    }

    public static boolean shouldAdmire(ItemStack stack) {
        return PiglinTasksHelper.isPiglinLoved(stack) || PiglinTasksHelper.isBarterItem(stack);
    }

    public static boolean wantsToDance(Piglin dancer, LivingEntity victim) {
        if (victim.m_6095_().m_204039_(PIGLINS_HUNT)) {
            return false;
        }
        return (double)new Random(dancer.m_9236_().m_46467_()).nextFloat() < (Double)SapienceConfig.COMMON.DANCE_CHANCE.get();
    }

    public static boolean wantsToPickUp(Piglin piglin, ItemStack itemStack) {
        return piglin.m_9236_().m_46469_().m_46207_(GameRules.f_46132_) && piglin.m_21531_() && PiglinTasksHelper.piglinWantsToPickUp(piglin, itemStack);
    }

    public static boolean piglinWantsToPickUp(Piglin piglin, ItemStack stack) {
        if (piglin.m_6162_() && stack.m_204117_(ItemTags.f_144309_)) {
            return false;
        }
        if (stack.m_204117_(ItemTags.f_13150_)) {
            return false;
        }
        if (PiglinTasksHelper.hasAdmiringDisabled((AbstractPiglin)piglin) && PiglinTasksHelper.hasAttackTarget(piglin)) {
            return false;
        }
        if (PiglinTasksHelper.isBarterItem(stack)) {
            return PiglinTasksHelper.hasOpenOffhandSlot(piglin) && !PiglinTasksHelper.hasConsumableOffhandItem((AbstractPiglin)piglin);
        }
        boolean canAddToInventory = PiglinTasksHelper.getInventory(piglin).m_19183_(stack);
        if (PiglinTasksHelper.isPiglinFoodItem(stack)) {
            return !PiglinTasksHelper.hasAteRecently((AbstractPiglin)piglin) && canAddToInventory && !PiglinTasksHelper.hasConsumableOffhandItem((AbstractPiglin)piglin);
        }
        if (!PiglinTasksHelper.isPiglinLoved(stack)) {
            return ReflectionHelper.callCanReplaceCurrentItem(piglin, stack);
        }
        return PiglinTasksHelper.hasOpenOffhandSlot(piglin) && canAddToInventory && !PiglinTasksHelper.hasConsumableOffhandItem((AbstractPiglin)piglin);
    }

    private static SimpleContainer getInventory(Piglin piglin) {
        return piglin.m_35311_();
    }

    public static void pickUpPiglinItem(Piglin piglin, ItemEntity itemEntity) {
        PiglinTasksHelper.clearWalkPath((AbstractPiglin)piglin);
        piglin.m_7938_((Entity)itemEntity, 1);
        ItemStack itemstack = PiglinTasksHelper.extractSingletonFromItemEntity(itemEntity);
        if (PiglinTasksHelper.isPiglinLoved(itemstack) || PiglinTasksHelper.isBarterItem(itemstack)) {
            PiglinTasksHelper.removeTimeTryingToReachAdmireItem(piglin);
            PiglinTasksHelper.dropOffhandItemAndSetItemStackToOffhand((AbstractPiglin)piglin, itemstack);
            PiglinTasksHelper.setAdmiringItem((LivingEntity)piglin);
        } else if (PiglinTasksHelper.isPiglinFoodItem(itemstack) && !PiglinTasksHelper.hasAteRecently((AbstractPiglin)piglin)) {
            PiglinTasksHelper.removeTimeTryingToReachAdmireItem(piglin);
            PiglinTasksHelper.dropOffhandItemAndSetItemStackToOffhand((AbstractPiglin)piglin, itemstack);
            PiglinTasksHelper.setAdmiringItem((LivingEntity)piglin);
        } else {
            boolean equippedItem;
            boolean bl = equippedItem = !piglin.m_255207_(itemstack).m_41619_();
            if (!equippedItem) {
                PiglinTasksHelper.putInInventory(piglin, itemstack);
            }
        }
    }

    private static boolean hasAttackTarget(Piglin piglin) {
        return piglin.m_6274_().m_21874_(MemoryModuleType.f_26372_);
    }

    private static void putInInventory(Piglin piglin, ItemStack stack) {
        ItemStack remainder;
        if (PiglinTasksHelper.isBarterItem(stack)) {
            CompoundTag tag = stack.m_41784_();
            remainder = GreedHelper.addGreedItemToGreedInventory((Mob)piglin, stack, tag.m_128471_("Bartered"));
        } else {
            remainder = PiglinTasksHelper.getInventory(piglin).m_19173_(stack);
        }
        if (remainder.m_41619_() || !PiglinTasksHelper.isPiglinLoved(remainder) && !PiglinTasksHelper.isBarterItem(remainder)) {
            PiglinTasksHelper.dropItemsNearSelf((AbstractPiglin)piglin, Collections.singletonList(remainder));
        }
    }

    public static void stopHoldingOffHandItem(Piglin piglin, boolean doBarter) {
        Entity interactor = ReputationHelper.getPreviousInteractor((Mob)piglin);
        boolean willDropLoot = PiglinTasksHelper.willDropLootFor(piglin, interactor);
        ItemStack offHandItem = piglin.m_21120_(InteractionHand.OFF_HAND);
        piglin.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
        if (piglin.m_34667_()) {
            boolean barterItem = PiglinTasksHelper.isBarterItem(offHandItem);
            if (doBarter && barterItem) {
                if (willDropLoot) {
                    PiglinTasksHelper.dropItemsAccountingForNearbyPlayer((AbstractPiglin)piglin, PiglinTasksHelper.isCheapBarterItem(offHandItem) ? PiglinTasksHelper.getNuggetBarteringLoot((AbstractPiglin)piglin) : (PiglinTasksHelper.isExpensiveBarterItem(offHandItem) ? PiglinTasksHelper.getBlockBarteringLoot((AbstractPiglin)piglin) : PiglinTasksHelper.getBarterResponseItems((AbstractPiglin)piglin)));
                }
                ReputationHelper.updatePreviousInteractorReputation((Mob)piglin, PiglinReputationType.BARTER);
                PiglinTasksHelper.markAsBartered(offHandItem);
                PiglinTasksHelper.putInInventory(piglin, offHandItem);
            } else if (!barterItem) {
                boolean equippedItem;
                if (PiglinTasksHelper.isPiglinLoved(offHandItem)) {
                    ReputationHelper.updatePreviousInteractorReputation((Mob)piglin, PiglinReputationType.GOLD_GIFT);
                }
                boolean bl = equippedItem = !piglin.m_255207_(offHandItem).m_41619_();
                if (!equippedItem) {
                    PiglinTasksHelper.putInInventory(piglin, offHandItem);
                }
            }
        } else {
            boolean equippedItem;
            boolean bl = equippedItem = !piglin.m_255207_(offHandItem).m_41619_();
            if (!equippedItem) {
                ItemStack mainHandItem = piglin.m_21205_();
                if (PiglinTasksHelper.isPiglinLoved(mainHandItem)) {
                    PiglinTasksHelper.putInInventory(piglin, mainHandItem);
                } else {
                    PiglinTasksHelper.dropItemsAccountingForNearbyPlayer((AbstractPiglin)piglin, Collections.singletonList(mainHandItem));
                }
                piglin.m_8061_(EquipmentSlot.MAINHAND, offHandItem);
                piglin.m_21508_(EquipmentSlot.MAINHAND);
                piglin.m_21530_();
            }
        }
    }

    private static void markAsBartered(ItemStack offHandItem) {
        CompoundTag compoundNBT = offHandItem.m_41784_();
        compoundNBT.m_128379_("Bartered", true);
    }

    private static boolean willDropLootFor(Piglin piglinEntity, Entity interactorEntity) {
        LivingEntity living;
        return interactorEntity instanceof LivingEntity && ReputationHelper.isAllowedToBarter(piglinEntity, living = (LivingEntity)interactorEntity) || interactorEntity == null && (Boolean)SapienceConfig.COMMON.REQUIRE_LIVING_FOR_BARTER.get() == false;
    }

    public static boolean wantsToStopFleeing(Piglin piglin) {
        Brain brain = piglin.m_6274_();
        if (!brain.m_21874_(MemoryModuleType.f_26383_)) {
            return true;
        }
        LivingEntity avoidTarget = (LivingEntity)brain.m_21952_(MemoryModuleType.f_26383_).get();
        EntityType entitytype = avoidTarget.m_6095_();
        if (avoidTarget instanceof Hoglin) {
            return PiglinTasksHelper.piglinsEqualOrOutnumberHoglins(piglin);
        }
        if (PiglinTasksHelper.piglinsAvoid(entitytype)) {
            return !brain.m_21938_(MemoryModuleType.f_26351_, (Object)avoidTarget);
        }
        return false;
    }

    private static boolean piglinsEqualOrOutnumberHoglins(Piglin piglin) {
        return !PiglinTasksHelper.hoglinsOutnumberPiglins(piglin);
    }

    private static boolean hoglinsOutnumberPiglins(Piglin piglin) {
        int piglins = piglin.m_6274_().m_21952_(MemoryModuleType.f_26352_).orElse(0) + 1;
        int hoglins = piglin.m_6274_().m_21952_(MemoryModuleType.f_26353_).orElse(0);
        return hoglins > piglins;
    }
}

