/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.infamous.sapience.util.ReflectionHelper;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class BrainHelper {
    public static ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<?>>> createPriorityPairs(int priorityStart, List<? extends BehaviorControl<?>> tasks) {
        int priorityIndex = priorityStart;
        ImmutableList.Builder priorityPairs = ImmutableList.builder();
        for (BehaviorControl<?> task : tasks) {
            priorityPairs.add((Object)Pair.of((Object)priorityIndex++, task));
        }
        return priorityPairs.build();
    }

    public static void addPrioritizedBehaviors(Activity activity, List<? extends Pair<Integer, ? extends BehaviorControl<?>>> prioritizedTasks, Brain<?> brain) {
        for (Pair<Integer, BehaviorControl<?>> pair : prioritizedTasks) {
            ReflectionHelper.getAvailableBehaviorsByPriority(brain).computeIfAbsent((Integer)pair.getFirst(), p -> Maps.newHashMap()).computeIfAbsent(activity, a -> Sets.newLinkedHashSet()).add((BehaviorControl)pair.getSecond());
        }
    }

    public static Optional<BehaviorControl<?>> retrieveFirstAvailableTask(Brain<?> brain, Activity activityType, int priority, Predicate<BehaviorControl<?>> predicate) {
        return ReflectionHelper.getAvailableBehaviorsByPriority(brain).get(priority).get(activityType).stream().filter(predicate).findFirst();
    }

    public static void addAdditionalTasks(Brain<?> brain, Activity activityType, int priorityStart, BehaviorControl<?> ... tasks) {
        List<BehaviorControl<?>> additionalCoreTasks = Arrays.asList(tasks);
        ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<?>>> prioritizedAdditionalCoreTasks = BrainHelper.createPriorityPairs(priorityStart, additionalCoreTasks);
        BrainHelper.addPrioritizedBehaviors(activityType, prioritizedAdditionalCoreTasks, brain);
    }

    public static void addToGateBehavior(GateBehavior<?> gateBehavior, Pair<BehaviorControl<?>, Integer> ... weightedTasks) {
        for (Pair<BehaviorControl<?>, Integer> weightedBehavior : weightedTasks) {
            ReflectionHelper.getBehaviors(gateBehavior).m_147929_((Object)((BehaviorControl)weightedBehavior.getFirst()), ((Integer)weightedBehavior.getSecond()).intValue());
        }
    }

    public static Collection<? extends SensorType<? extends Sensor<?>>> addSensorTypes(Collection<? extends SensorType<? extends Sensor<?>>> original, SensorType<? extends Sensor<?>> ... additional) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(original);
        for (SensorType<? extends Sensor<?>> sensorType : additional) {
            builder.add(sensorType);
        }
        return builder.build();
    }

    public static Collection<? extends MemoryModuleType<?>> addMemoryModules(Collection<? extends MemoryModuleType<?>> original, MemoryModuleType<?> ... additional) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(original);
        for (MemoryModuleType<?> memoryModuleType : additional) {
            builder.add(memoryModuleType);
        }
        return builder.build();
    }
}

