/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.util;

import com.infamous.sapience.Sapience;
import com.infamous.sapience.capability.ageable.Ageable;
import com.infamous.sapience.capability.ageable.AgeableProvider;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.util.LazyOptional;

public class AgeableHelper {
    private static final int BIRTH_AGE = -24000;
    private static final int BREEDING_COOLDOWN = 6000;
    public static final int BREEDING_ID = 12;
    public static final int GROWING_ID = 14;

    @Nullable
    public static Ageable getAgeableCapability(Entity entity) {
        LazyOptional lazyCap = entity.getCapability(AgeableProvider.AGEABLE_CAPABILITY);
        if (lazyCap.isPresent()) {
            return (Ageable)lazyCap.orElseThrow(() -> new IllegalStateException("Couldn't get the ageable capability from the Entity!"));
        }
        Sapience.LOGGER.error("Couldn't get the ageable capability from " + entity.toString() + "in AgeableHelper#getAgeableCapability!");
        return null;
    }

    public static void depleteParentsFoodValue(Mob parent, Mob partner) {
        AgeableHelper.depleteFoodValue(parent);
        AgeableHelper.depleteFoodValue(partner);
    }

    private static void depleteFoodValue(Mob parent) {
        Ageable parentAging = AgeableHelper.getAgeableCapability((Entity)parent);
        if (parentAging != null) {
            parentAging.depleteFoodValue();
        }
    }

    public static boolean canBreed(Mob parent) {
        Ageable parentAging = AgeableHelper.getAgeableCapability((Entity)parent);
        return parentAging != null && parentAging.canBreed();
    }

    public static boolean canPartnersBreed(Mob parent, Mob partner) {
        return AgeableHelper.canBreed(parent) && AgeableHelper.canBreed(partner);
    }

    public static void setParentsOnBreedCooldown(Mob parent, Mob partner) {
        AgeableHelper.setParentOnBreedCooldown(parent);
        AgeableHelper.setParentOnBreedCooldown(partner);
    }

    private static void setParentOnBreedCooldown(Mob parent) {
        Ageable parentAging = AgeableHelper.getAgeableCapability((Entity)parent);
        if (parentAging != null) {
            parentAging.setGrowingAge(6000);
        }
    }

    public static void increaseFoodLevel(Mob mobEntity, int foodValueIn) {
        Ageable ageable = AgeableHelper.getAgeableCapability((Entity)mobEntity);
        if (ageable != null) {
            ageable.increaseFoodLevel(foodValueIn);
        }
    }

    public static void updateGrowingAge(Mob mobEntity) {
        Ageable ageable = AgeableHelper.getAgeableCapability((Entity)mobEntity);
        if (ageable != null) {
            int i = ageable.getGrowingAge();
            if (i < 0) {
                ageable.setGrowingAge(++i);
            } else if (i > 0) {
                ageable.setGrowingAge(--i);
            } else if (mobEntity.m_6162_()) {
                mobEntity.m_6863_(false);
            }
        }
    }

    public static void updateForcedAge(Mob mobEntity) {
        Ageable ageable = AgeableHelper.getAgeableCapability((Entity)mobEntity);
        if (ageable != null && ageable.getForcedAgeTimer() > 0) {
            if (ageable.getForcedAgeTimer() % 4 == 0) {
                mobEntity.m_9236_().m_7605_((Entity)mobEntity, (byte)14);
            }
            ageable.setForcedAgeTimer(ageable.getForcedAgeTimer() - 1);
        }
    }

    public static void initializeChild(Mob child) {
        Ageable childAgeable = AgeableHelper.getAgeableCapability((Entity)child);
        if (childAgeable != null && !childAgeable.wasBorn()) {
            childAgeable.setGrowingAge(-24000);
            childAgeable.setBorn(true);
        }
    }

    @Nullable
    public static Mob createChild(ServerLevel serverWorld, Mob parent, Mob partner) {
        Mob child;
        EntityType partnerType;
        EntityType parentType = parent.m_6095_();
        if (parentType == (partnerType = partner.m_6095_()) && (child = (Mob)parentType.m_20615_((Level)serverWorld)) != null) {
            child.m_6863_(true);
            AgeableHelper.initializeChild(child);
            child.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(child.m_20183_()), MobSpawnType.BREEDING, (SpawnGroupData)null, (CompoundTag)null);
            return child;
        }
        return null;
    }

    public static void updateSelfAge(Mob mobEntity) {
        Ageable ageable = AgeableHelper.getAgeableCapability((Entity)mobEntity);
        if (ageable != null && ageable.canSelfAge()) {
            ageable.depleteFoodValue();
            ageable.ageUp((int)((float)(-ageable.getGrowingAge() / 20) * 0.1f), true);
        }
    }
}

