/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.tasks;

import com.google.common.collect.ImmutableMap;
import com.infamous.sapience.mod.ModMemoryModuleTypes;
import com.infamous.sapience.util.AgeableHelper;
import com.infamous.sapience.util.ReputationHelper;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class CreateBabyTask<T extends Mob>
extends Behavior<T> {
    private long duration;

    public CreateBabyTask() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)ModMemoryModuleTypes.BREEDING_TARGET.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT), 350, 350);
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, T owner) {
        return this.canBreed((Mob)owner);
    }

    protected boolean canStillUse(ServerLevel worldIn, T entityIn, long gameTimeIn) {
        return gameTimeIn <= this.duration && this.canBreed((Mob)entityIn);
    }

    private boolean canBreed(Mob owner) {
        Brain brain = owner.m_6274_();
        EntityType ownerEntityType = owner.m_6095_();
        Optional<Mob> breedingTarget = brain.m_21952_((MemoryModuleType)ModMemoryModuleTypes.BREEDING_TARGET.get()).filter(breedTarget -> breedTarget.m_6095_() == ownerEntityType);
        return breedingTarget.filter(partner -> AgeableHelper.canPartnersBreed(owner, partner)).isPresent() && BehaviorUtils.m_22639_((Brain)brain, (MemoryModuleType)((MemoryModuleType)ModMemoryModuleTypes.BREEDING_TARGET.get()), (EntityType)ownerEntityType);
    }

    protected void start(ServerLevel worldIn, T entityIn, long gameTimeIn) {
        if (entityIn.m_6274_().m_21952_((MemoryModuleType)ModMemoryModuleTypes.BREEDING_TARGET.get()).isPresent()) {
            Mob breedTarget = (Mob)entityIn.m_6274_().m_21952_((MemoryModuleType)ModMemoryModuleTypes.BREEDING_TARGET.get()).get();
            BehaviorUtils.m_22602_(entityIn, (LivingEntity)breedTarget, (float)0.5f);
            worldIn.m_7605_((Entity)breedTarget, (byte)12);
            worldIn.m_7605_(entityIn, (byte)12);
            int i = 275 + entityIn.m_217043_().m_188503_(50);
            this.duration = gameTimeIn + (long)i;
        }
    }

    protected void tick(ServerLevel worldIn, T owner, long gameTime) {
        Mob breedTarget;
        if (owner.m_6274_().m_21952_((MemoryModuleType)ModMemoryModuleTypes.BREEDING_TARGET.get()).isPresent() && owner.m_20280_((Entity)(breedTarget = (Mob)owner.m_6274_().m_21952_((MemoryModuleType)ModMemoryModuleTypes.BREEDING_TARGET.get()).get())) <= 5.0) {
            BehaviorUtils.m_22602_(owner, (LivingEntity)breedTarget, (float)0.5f);
            if (gameTime >= this.duration) {
                AgeableHelper.depleteParentsFoodValue(owner, breedTarget);
                this.createChild(worldIn, (Mob)owner, breedTarget);
            } else if (owner.m_217043_().m_188503_(35) == 0) {
                worldIn.m_7605_((Entity)breedTarget, (byte)12);
                worldIn.m_7605_(owner, (byte)12);
            }
        }
    }

    private void createChild(ServerLevel world, Mob parent, Mob partner) {
        Mob child = AgeableHelper.createChild(world, parent, partner);
        if (child != null) {
            ReputationHelper.spreadGossipDirect((LivingEntity)child, (LivingEntity)parent);
            ReputationHelper.spreadGossipDirect((LivingEntity)child, (LivingEntity)partner);
            AgeableHelper.setParentsOnBreedCooldown(parent, partner);
            child.m_7678_(parent.m_20185_(), parent.m_20186_(), parent.m_20189_(), 0.0f, 0.0f);
            world.m_47205_((Entity)child);
            world.m_7605_((Entity)child, (byte)12);
        }
    }

    protected void stop(ServerLevel worldIn, T entityIn, long gameTimeIn) {
        entityIn.m_6274_().m_21936_((MemoryModuleType)ModMemoryModuleTypes.BREEDING_TARGET.get());
    }
}

