/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.mixin;

import com.infamous.sapience.util.BruteTasksHelper;
import com.infamous.sapience.util.HoglinTasksHelper;
import com.infamous.sapience.util.PiglinTasksHelper;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.HoglinSpecificSensor;
import net.minecraft.world.entity.ai.sensing.NearestItemSensor;
import net.minecraft.world.entity.ai.sensing.PiglinBruteSpecificSensor;
import net.minecraft.world.entity.ai.sensing.PiglinSpecificSensor;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Sensor.class})
public class SensorMixin<E extends LivingEntity> {
    /*
     * Enabled aggressive block sorting
     */
    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/sensing/Sensor;doTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)V", shift=At.Shift.AFTER)}, method={"tick"})
    private void postDoTick(ServerLevel serverLevel, E entity, CallbackInfo ci) {
        if (entity instanceof PiglinBrute) {
            PiglinBrute brute = (PiglinBrute)entity;
            if (this.cast() instanceof PiglinBruteSpecificSensor) {
                BruteTasksHelper.additionalSensorLogic(brute);
                return;
            }
        }
        if (entity instanceof Piglin) {
            Piglin piglin = (Piglin)entity;
            if (this.cast() instanceof PiglinSpecificSensor) {
                PiglinTasksHelper.additionalSensorLogic((LivingEntity)piglin);
                return;
            }
        }
        if (!(entity instanceof Hoglin)) return;
        Hoglin hoglin = (Hoglin)entity;
        if (!(this.cast() instanceof HoglinSpecificSensor)) return;
        HoglinTasksHelper.additionalSensorLogic(hoglin);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/sensing/Sensor;doTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)V")}, method={"tick"}, cancellable=true)
    private void preDoTick(ServerLevel serverLevel, E entity, CallbackInfo ci) {
        if (this.cast() instanceof NearestItemSensor && entity instanceof Hoglin) {
            Hoglin hoglin = (Hoglin)entity;
            ci.cancel();
            Brain brain = entity.m_6274_();
            List nearbyItems = serverLevel.m_6443_(ItemEntity.class, entity.m_20191_().m_82377_(8.0, 4.0, 8.0), ie -> true);
            nearbyItems.sort(Comparator.comparingDouble(arg_0 -> entity.m_20280_(arg_0)));
            Optional<ItemEntity> wantedItem = nearbyItems.stream().filter(ie -> HoglinTasksHelper.wantsToPickUp(hoglin, ie.m_32055_())).filter(ie -> ie.m_19950_((Entity)entity, 9.0)).filter(arg_0 -> entity.m_142582_(arg_0)).findFirst();
            brain.m_21886_(MemoryModuleType.f_26332_, wantedItem);
        }
    }

    private Sensor<?> cast() {
        return (Sensor)this;
    }
}

