/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.mixin;

import com.infamous.sapience.capability.emotive.EmotiveProvider;
import com.infamous.sapience.util.PiglinTasksHelper;
import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinArmPose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PiglinModel.class})
public class PiglinModelMixin<T extends Mob>
extends PlayerModel<T> {
    public PiglinModelMixin(ModelPart bakedLayer, boolean smallArms) {
        super(bakedLayer, smallArms);
    }

    @Inject(at={@At(value="TAIL")}, method={"setupAnim(Lnet/minecraft/world/entity/Mob;FFFFF)V"})
    private void postSetupAnim(T piglinLike, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (piglinLike instanceof Piglin) {
            Piglin piglin = (Piglin)piglinLike;
            this.handleCustomAdmiringAnimation(piglin);
            this.handleEmotiveAnimation(ageInTicks, piglin);
            this.handleEatingAnimation((LivingEntity)piglin, ageInTicks);
            this.f_102809_.m_104315_(this.f_102808_);
            this.f_103374_.m_104315_(this.f_102812_);
            this.f_103375_.m_104315_(this.f_102811_);
        }
    }

    private void handleEatingAnimation(LivingEntity entityIn, float ageInTicks) {
        if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
            this.eatingAnimationRightHand(InteractionHand.MAIN_HAND, entityIn, ageInTicks);
            this.eatingAnimationLeftHand(InteractionHand.OFF_HAND, entityIn, ageInTicks);
        } else {
            this.eatingAnimationRightHand(InteractionHand.OFF_HAND, entityIn, ageInTicks);
            this.eatingAnimationLeftHand(InteractionHand.MAIN_HAND, entityIn, ageInTicks);
        }
    }

    private void eatingAnimationRightHand(InteractionHand hand, LivingEntity entity, float ageInTicks) {
        boolean drinkingoreating;
        ItemStack itemstack = entity.m_21120_(hand);
        boolean bl = drinkingoreating = itemstack.m_41780_() == UseAnim.EAT || itemstack.m_41780_() == UseAnim.DRINK;
        if (entity.m_21212_() > 0 && drinkingoreating && entity.m_7655_() == hand) {
            this.f_102811_.f_104204_ = -0.5f;
            this.f_102811_.f_104203_ = -1.3f;
            this.f_102811_.f_104205_ = Mth.m_14089_((float)ageInTicks) * 0.1f;
            this.f_103375_.m_104315_(this.f_102811_);
            this.f_102808_.f_104203_ = Mth.m_14089_((float)ageInTicks) * 0.2f;
            this.f_102808_.f_104204_ = 0.0f;
        }
    }

    private void eatingAnimationLeftHand(InteractionHand hand, LivingEntity entity, float ageInTicks) {
        boolean drinkingoreating;
        ItemStack itemstack = entity.m_21120_(hand);
        boolean bl = drinkingoreating = itemstack.m_41780_() == UseAnim.EAT || itemstack.m_41780_() == UseAnim.DRINK;
        if (entity.m_21212_() > 0 && drinkingoreating && entity.m_7655_() == hand) {
            this.f_102812_.f_104204_ = 0.5f;
            this.f_102812_.f_104203_ = -1.3f;
            this.f_102812_.f_104205_ = Mth.m_14089_((float)ageInTicks) * 0.1f;
            this.f_103374_.m_104315_(this.f_102812_);
            this.f_102808_.f_104203_ = Mth.m_14089_((float)ageInTicks) * 0.2f;
            this.f_102808_.f_104204_ = 0.0f;
        }
    }

    private void handleCustomAdmiringAnimation(Piglin piglin) {
        if (piglin.m_6389_() == PiglinArmPose.DEFAULT && PiglinTasksHelper.shouldAdmire(piglin.m_21206_())) {
            this.f_102808_.f_104203_ = 0.5f;
            this.f_102808_.f_104204_ = 0.0f;
            if (piglin.m_21526_()) {
                this.f_102811_.f_104204_ = -0.5f;
                this.f_102811_.f_104203_ = -0.9f;
            } else {
                this.f_102812_.f_104204_ = 0.5f;
                this.f_102812_.f_104203_ = -0.9f;
            }
        }
    }

    private void handleEmotiveAnimation(float ageInTicks, Piglin piglin) {
        piglin.getCapability(EmotiveProvider.EMOTIVE_CAPABILITY).ifPresent(e -> {
            if (e.getShakeHeadTicks() > 0) {
                this.f_102808_.f_104205_ = 0.3f * Mth.m_14031_((float)(0.45f * ageInTicks));
                this.f_102808_.f_104203_ = 0.4f;
            }
        });
    }
}

