/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import com.talhanation.recruits.world.RecruitsGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class RecruitsGroupsSaveData
extends SavedData {
    private static final String FILE_ID = "recruitsGroups";
    private List<RecruitsGroup> groups = new ArrayList<RecruitsGroup>();
    private Map<UUID, UUID> redirects = new HashMap<UUID, UUID>();
    private Map<UUID, UUID> recruitRedirects = new HashMap<UUID, UUID>();

    public static RecruitsGroupsSaveData get(ServerLevel level) {
        return (RecruitsGroupsSaveData)level.m_8895_().m_164861_(RecruitsGroupsSaveData::load, RecruitsGroupsSaveData::new, FILE_ID);
    }

    public static RecruitsGroupsSaveData load(CompoundTag nbt) {
        UUID newId;
        UUID oldId;
        CompoundTag tag;
        RecruitsGroupsSaveData data = new RecruitsGroupsSaveData();
        if (nbt.m_128425_("groups", 9)) {
            ListTag list = nbt.m_128437_("groups", 10);
            for (Tag t : list) {
                data.groups.add(RecruitsGroup.fromNBT((CompoundTag)t));
            }
        }
        if (nbt.m_128425_("redirects", 9)) {
            ListTag redirectList = nbt.m_128437_("redirects", 10);
            for (Tag t : redirectList) {
                tag = (CompoundTag)t;
                oldId = tag.m_128342_("old");
                newId = tag.m_128342_("new");
                data.redirects.put(oldId, newId);
            }
        }
        if (nbt.m_128425_("recruitRedirects", 9)) {
            ListTag recruitRedirectList = nbt.m_128437_("recruitRedirects", 10);
            for (Tag t : recruitRedirectList) {
                tag = (CompoundTag)t;
                oldId = tag.m_128342_("recruit");
                newId = tag.m_128342_("group");
                data.recruitRedirects.put(oldId, newId);
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (RecruitsGroup recruitsGroup : this.groups) {
            list.add((Object)recruitsGroup.toNBT());
        }
        nbt.m_128365_("groups", (Tag)list);
        ListTag redirectList = new ListTag();
        for (Map.Entry<UUID, UUID> entry : this.redirects.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("old", entry.getKey());
            tag.m_128362_("new", entry.getValue());
            redirectList.add((Object)tag);
        }
        nbt.m_128365_("redirects", (Tag)redirectList);
        ListTag listTag = new ListTag();
        for (Map.Entry<UUID, UUID> e : this.recruitRedirects.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("recruit", e.getKey());
            tag.m_128362_("group", e.getValue());
            listTag.add((Object)tag);
        }
        nbt.m_128365_("recruitRedirects", (Tag)listTag);
        return nbt;
    }

    public List<RecruitsGroup> getAllGroups() {
        return this.groups;
    }

    public void setAllGroups(List<RecruitsGroup> groups) {
        this.groups = groups;
    }

    public Map<UUID, UUID> getRedirects() {
        return this.redirects;
    }

    public Map<UUID, UUID> getRecruitRedirects() {
        return this.recruitRedirects;
    }

    public void setRedirects(Map<UUID, UUID> map) {
        this.redirects = map;
    }

    public void setRecruitRedirects(Map<UUID, UUID> map) {
        this.recruitRedirects = map;
    }
}

