/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class RecruitsFaction {
    public String stringID;
    public String teamDisplayName;
    public UUID teamLeaderID;
    public String teamLeaderName;
    public CompoundTag banner;
    public List<String> joinRequests = new ArrayList<String>();
    public int players;
    public int npcs;
    public byte unitColor;
    public int teamColor;
    public int maxPlayers;
    public int maxNPCs;
    public int maxNPCsPerPlayer = -1;
    private int biome = -1;

    public RecruitsFaction(String stringID, String teamLeaderName, CompoundTag banner) {
        this.stringID = stringID;
        this.teamDisplayName = stringID;
        this.teamLeaderName = teamLeaderName;
        this.banner = banner;
    }

    public RecruitsFaction() {
    }

    public CompoundTag getBanner() {
        return this.banner;
    }

    public UUID getTeamLeaderUUID() {
        return this.teamLeaderID;
    }

    public String getStringID() {
        return this.stringID;
    }

    public String getTeamDisplayName() {
        return this.teamDisplayName;
    }

    public String getTeamLeaderName() {
        return this.teamLeaderName;
    }

    public void setStringID(String stringID) {
        this.stringID = stringID;
    }

    public void setTeamDisplayName(String teamDisplayName) {
        this.teamDisplayName = teamDisplayName;
    }

    public void setTeamLeaderID(UUID uuid) {
        this.teamLeaderID = uuid;
    }

    public void setTeamLeaderName(String leaderName) {
        this.teamLeaderName = leaderName;
    }

    public void setBanner(CompoundTag nbt) {
        this.banner = nbt;
    }

    public void setPlayers(int players) {
        this.players = players;
    }

    public void setNPCs(int npcs) {
        this.npcs = npcs;
    }

    public void setMaxPlayers(int max) {
        this.maxPlayers = max;
    }

    public void setMaxNPCs(int max) {
        this.maxNPCs = max;
    }

    public boolean addPlayerAsJoinRequest(String player) {
        if (!this.joinRequests.contains(player)) {
            this.joinRequests.add(player);
            return true;
        }
        return false;
    }

    public void removeJoinRequest(String player) {
        this.joinRequests.remove(player);
    }

    public List<String> getJoinRequests() {
        return this.joinRequests;
    }

    public int getNPCs() {
        return this.npcs;
    }

    public int getPlayers() {
        return this.players;
    }

    public byte getUnitColor() {
        return this.unitColor;
    }

    public int getMaxNPCsPerPlayer() {
        return this.maxNPCsPerPlayer;
    }

    public int getTeamColor() {
        return this.teamColor;
    }

    public int getMaxNPCs() {
        return this.maxNPCs;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public void addNPCs(int x) {
        this.npcs += x;
        if (this.npcs < 0) {
            this.npcs = 0;
        }
    }

    public void addPlayer(int x) {
        this.players += x;
        if (this.players < 0) {
            this.players = 0;
        }
    }

    public void setUnitColor(byte unitColor) {
        this.unitColor = unitColor;
    }

    public void setTeamColor(int color) {
        this.teamColor = color;
    }

    public void setMaxNPCsPerPlayer(int maxNPCsPerPlayer) {
        this.maxNPCsPerPlayer = maxNPCsPerPlayer;
    }

    public String toString() {
        return this.getStringID();
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("teamName", this.stringID);
        nbt.m_128359_("teamDisplayName", this.teamDisplayName);
        nbt.m_128362_("teamLeaderID", this.teamLeaderID);
        nbt.m_128359_("teamLeaderName", this.teamLeaderName);
        nbt.m_128365_("banner", (Tag)this.banner);
        ListTag joinRequestsTag = new ListTag();
        for (String request : this.joinRequests) {
            joinRequestsTag.add((Object)StringTag.m_129297_((String)request));
        }
        nbt.m_128365_("joinRequests", (Tag)joinRequestsTag);
        nbt.m_128405_("players", this.players);
        nbt.m_128405_("npcs", this.npcs);
        nbt.m_128405_("maxPlayers", this.maxPlayers);
        nbt.m_128405_("maxNpcs", this.maxNPCs);
        nbt.m_128344_("unitColor", this.unitColor);
        nbt.m_128405_("teamColor", this.teamColor);
        nbt.m_128405_("maxPlayers", this.maxPlayers);
        nbt.m_128405_("biome", this.biome);
        nbt.m_128405_("maxNPCsPerPlayer", this.maxNPCsPerPlayer);
        return nbt;
    }

    public static RecruitsFaction fromNBT(CompoundTag nbt) {
        if (nbt == null || nbt.m_128456_()) {
            return null;
        }
        RecruitsFaction team = new RecruitsFaction();
        team.setStringID(nbt.m_128461_("teamName"));
        if (nbt.m_128461_("teamDisplayName").isEmpty()) {
            team.setTeamDisplayName(team.getStringID());
        } else {
            team.setTeamDisplayName(nbt.m_128461_("teamDisplayName"));
        }
        team.setTeamLeaderID(nbt.m_128342_("teamLeaderID"));
        team.setTeamLeaderName(nbt.m_128461_("teamLeaderName"));
        team.setBanner(nbt.m_128469_("banner"));
        ListTag joinRequestsTag = nbt.m_128437_("joinRequests", 8);
        for (int i = 0; i < joinRequestsTag.size(); ++i) {
            team.addPlayerAsJoinRequest(joinRequestsTag.m_128778_(i));
        }
        team.setPlayers(nbt.m_128451_("players"));
        team.setNPCs(nbt.m_128451_("npcs"));
        team.setMaxPlayers(nbt.m_128451_("maxPlayers"));
        team.setMaxNPCs(nbt.m_128451_("maxNpcs"));
        team.setUnitColor(nbt.m_128445_("unitColor"));
        team.setTeamColor(nbt.m_128451_("teamColor"));
        team.maxPlayers = nbt.m_128451_("maxPlayers");
        team.biome = nbt.m_128451_("biome");
        team.setMaxNPCsPerPlayer(nbt.m_128451_("maxNPCsPerPlayer"));
        return team;
    }

    public static CompoundTag toNBT(List<RecruitsFaction> list) {
        CompoundTag nbt = new CompoundTag();
        ListTag teamList = new ListTag();
        for (RecruitsFaction team : list) {
            teamList.add((Object)team.toNBT());
        }
        nbt.m_128365_("Teams", (Tag)teamList);
        return nbt;
    }

    public static List<RecruitsFaction> getListFromNBT(CompoundTag nbt) {
        ArrayList<RecruitsFaction> list = new ArrayList<RecruitsFaction>();
        ListTag teamList = nbt.m_128437_("Teams", 10);
        for (int i = 0; i < teamList.size(); ++i) {
            CompoundTag teamTag = teamList.m_128728_(i);
            list.add(RecruitsFaction.fromNBT(teamTag));
        }
        return list;
    }

    public static enum PlayerRank {
        NONE,
        LEADER,
        CAPTAIN,
        COMMANDER;

    }
}

