/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import com.talhanation.recruits.FactionEvents;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.network.MessageToClientUpdateClaim;
import com.talhanation.recruits.network.MessageToClientUpdateClaims;
import com.talhanation.recruits.world.RecruitsClaim;
import com.talhanation.recruits.world.RecruitsClaimSaveData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.network.PacketDistributor;

public class RecruitsClaimManager {
    private final Map<ChunkPos, RecruitsClaim> claims = new HashMap<ChunkPos, RecruitsClaim>();

    public void load(ServerLevel level) {
        RecruitsClaimSaveData data = RecruitsClaimSaveData.get(level);
        this.claims.clear();
        for (RecruitsClaim claim : data.getAllClaims()) {
            for (ChunkPos pos : claim.getClaimedChunks()) {
                this.claims.put(pos, claim);
            }
        }
    }

    public void save(ServerLevel level) {
        RecruitsClaimSaveData data = RecruitsClaimSaveData.get(level);
        data.setAllClaims(new ArrayList<RecruitsClaim>(new HashSet<RecruitsClaim>(this.claims.values())));
        data.m_77762_();
    }

    public void addOrUpdateClaim(ServerLevel level, RecruitsClaim claim) {
        if (claim == null) {
            return;
        }
        this.claims.entrySet().removeIf(entry -> ((RecruitsClaim)entry.getValue()).getUUID().equals(claim.getUUID()));
        for (ChunkPos pos : claim.getClaimedChunks()) {
            this.claims.put(pos, claim);
        }
        this.broadcastClaimsToAll(level);
    }

    public void removeClaim(RecruitsClaim claim) {
        if (claim != null) {
            this.claims.entrySet().removeIf(entry -> ((RecruitsClaim)entry.getValue()).equals(claim));
        }
    }

    @Nullable
    public RecruitsClaim getClaim(ChunkPos chunkPos) {
        return this.claims.get(chunkPos);
    }

    @Nullable
    public RecruitsClaim getClaim(int chunkX, int chunkZ) {
        return this.getClaim(new ChunkPos(chunkX, chunkZ));
    }

    public List<RecruitsClaim> getAllClaims() {
        return new ArrayList<RecruitsClaim>(new HashSet<RecruitsClaim>(this.claims.values()));
    }

    public boolean claimExists(RecruitsClaim claim, List<ChunkPos> allPos) {
        for (ChunkPos pos : allPos) {
            if (!this.claims.containsKey(pos)) continue;
            return true;
        }
        return false;
    }

    public static RecruitsClaim getClaimAt(ChunkPos pos, List<RecruitsClaim> allClaims) {
        for (RecruitsClaim claim : allClaims) {
            if (!claim.containsChunk(pos)) continue;
            return claim;
        }
        return null;
    }

    public void broadcastClaimsToAll(ServerLevel level) {
        for (ServerPlayer player : level.m_7654_().m_6846_().m_11314_()) {
            Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageToClientUpdateClaims(this.getAllClaims(), (Integer)RecruitsServerConfig.ClaimingCost.get(), (Integer)RecruitsServerConfig.ChunkCost.get(), (Boolean)RecruitsServerConfig.CascadeThePriceOfClaims.get(), FactionEvents.getCurrency()));
        }
    }

    public void broadcastClaimUpdateTo(RecruitsClaim claim, List<ServerPlayer> players) {
        if (claim == null || players == null || players.isEmpty()) {
            return;
        }
        for (ServerPlayer player : players) {
            Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageToClientUpdateClaim(claim));
        }
    }
}

