/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.util;

import com.talhanation.recruits.world.RecruitsClaim;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ClaimUtil {
    public static List<LivingEntity> getLivingEntitiesInClaim(Level level, RecruitsClaim claim, Predicate<LivingEntity> filter) {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (ChunkPos chunkPos : claim.getClaimedChunks()) {
            list.addAll(ClaimUtil.getLivingEntitiesInChunk(level, chunkPos, filter));
        }
        return list;
    }

    public static List<LivingEntity> getLivingEntitiesInChunk(Level level, ChunkPos chunkPos, Predicate<LivingEntity> filter) {
        int minX = chunkPos.m_45604_();
        int minZ = chunkPos.m_45605_();
        int maxX = chunkPos.m_45608_();
        int maxZ = chunkPos.m_45609_();
        int minY = -64;
        int maxY = level.m_151558_();
        AABB box = new AABB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)maxY, (double)(maxZ + 1));
        return level.m_6443_(LivingEntity.class, box, filter);
    }

    public static List<LivingEntity> getLivingEntitiesInArea(Level level, AABB area, Predicate<LivingEntity> filter) {
        return level.m_6443_(LivingEntity.class, area, filter);
    }
}

